/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity;

import com.legacy.rediscovered.client.render.IMD3Render;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.lwjgl.opengl.GL11;

public abstract class MD3EntityRenderer<T extends LivingEntity>
extends EntityRenderer<T>
implements IMD3Render {
    public MD3EntityRenderer(EntityRendererManager renderer) {
        super(renderer);
    }

    public ResourceLocation getEntityTexture(T entity) {
        return this.getMD3Texture();
    }

    public void render(T entityIn, float yaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLightIn) {
        Vector3d vec3d = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double camX = vec3d.func_82615_a();
        double camY = vec3d.func_82617_b();
        double camZ = vec3d.func_82616_c();
        double d0 = MathHelper.func_219803_d((double)partialTicks, (double)((LivingEntity)entityIn).field_70142_S, (double)entityIn.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)partialTicks, (double)((LivingEntity)entityIn).field_70137_T, (double)entityIn.func_226278_cu_());
        double d2 = MathHelper.func_219803_d((double)partialTicks, (double)((LivingEntity)entityIn).field_70136_U, (double)entityIn.func_226281_cx_());
        this.render((Entity)entityIn, yaw, partialTicks, matrix, buffer, packedLightIn, d0 - camX, d1 - camY, d2 - camZ);
    }

    @Override
    public <E extends Entity> void render(E entityIn, float rotationYawIn, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLightIn, double xIn, double yIn, double zIn) {
        if (!(entityIn instanceof LivingEntity)) {
            return;
        }
        LivingEntity steve = (LivingEntity)entityIn;
        Minecraft mc = Minecraft.func_71410_x();
        ActiveRenderInfo renderInfo = mc.field_71460_t.func_215316_n();
        GL11.glPushMatrix();
        double camX = renderInfo.func_216785_c().func_82615_a();
        double camY = renderInfo.func_216785_c().func_82617_b();
        double camZ = renderInfo.func_216785_c().func_82616_c();
        double entityX = entityIn.func_226277_ct_();
        double entityY = entityIn.func_226278_cu_();
        double entityZ = entityIn.func_226281_cx_();
        GL11.glRotated((double)renderInfo.func_216777_e(), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)renderInfo.func_216778_f(), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)(camX - entityX), (double)(-(camY - entityY)), (double)(camZ - entityZ));
        float f5 = steve.field_70760_ar + (steve.field_70761_aq - steve.field_70760_ar) * partialTicks;
        mc.field_71446_o.func_110577_a(this.getMD3Texture());
        if (steve.field_70725_aQ > 0) {
            float f = ((float)steve.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GL11.glRotatef((float)(f * 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glRotatef((float)(-f5), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)0.02f, (float)-0.02f, (float)0.02f);
        float rotation = (float)steve.field_70173_aa + partialTicks * this.getSpeedMultiplier();
        try {
            GlStateManager.func_227740_m_();
            GlStateManager.func_227700_d_();
            GlStateManager.func_227734_k_();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_227667_a_((!entityIn.func_82150_aj() ? 1 : 0) != 0);
            int frame1 = (int)rotation % this.getMD3Renderer().getAnimFrames();
            int frame2 = (frame1 + 1) % this.getMD3Renderer().getAnimFrames();
            GlStateManager.func_227667_a_((boolean)true);
            GL11.glShadeModel((int)7425);
            GL11.glEnable((int)2977);
            if (steve.field_70737_aN > 0 || steve.field_70725_aQ > 0) {
                GL11.glColor3d((double)1.0, (double)0.5, (double)0.5);
            }
            this.getMD3Renderer().render(frame1, frame2, rotation - (float)((int)rotation));
            GL11.glDisable((int)2977);
            GlStateManager.func_227667_a_((boolean)true);
            GlStateManager.func_227737_l_();
            GlStateManager.func_227709_e_();
            GlStateManager.func_227731_j_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GL11.glPopMatrix();
    }
}

