/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.md3;

import com.legacy.rediscovered.client.render.md3.MD3Frame;
import com.legacy.rediscovered.client.render.md3.MD3Model;
import com.legacy.rediscovered.client.render.md3.MD3Shader;
import com.legacy.rediscovered.client.render.md3.MD3Surface;
import com.legacy.rediscovered.client.render.md3.MD3Tag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class MD3Loader {
    public final MD3Model load(ResourceLocation md3Location) throws IOException {
        int byteLength;
        InputStream md3Model = Minecraft.func_71410_x().func_195551_G().func_199002_a(md3Location).func_199027_b();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byteData = new byte[4096];
        while ((byteLength = md3Model.read(byteData)) >= 0) {
            byteArrayOutputStream.write(byteData, 0, byteLength);
        }
        md3Model.close();
        byteArrayOutputStream.close();
        ByteBuffer finalMd3Model = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        return this.load(finalMd3Model);
    }

    private MD3Model load(ByteBuffer md3Model) throws IOException {
        int i;
        md3Model.order(ByteOrder.LITTLE_ENDIAN);
        if (!MD3Loader.readString(md3Model, 4).equals("IDP3")) {
            throw new IOException("Not a valid MD3 file (bad magic number)");
        }
        MD3Model model = new MD3Model();
        md3Model.getInt();
        MD3Loader.readString(md3Model, 64);
        md3Model.getInt();
        int frames = md3Model.getInt();
        System.out.println(frames + " frames");
        int tags = md3Model.getInt();
        int surfaces = md3Model.getInt();
        md3Model.getInt();
        int frameOffset = md3Model.getInt();
        md3Model.getInt();
        int surfaceOffset = md3Model.getInt();
        md3Model.getInt();
        model.animFrames = frames;
        model.frames = new MD3Frame[frames];
        model.tags = new HashMap();
        model.surfaces = new MD3Surface[surfaces];
        md3Model.position(frameOffset);
        for (int i2 = 0; i2 < frames; ++i2) {
            MD3Frame frame = new MD3Frame();
            frame.radius = Float.valueOf(md3Model.getFloat());
            frame.name = MD3Loader.readString(md3Model, 16);
            model.frames[i2] = frame;
        }
        MD3Tag[] tagList = new MD3Tag[tags];
        for (i = 0; i < tags; ++i) {
            tagList[i] = new MD3Tag(frames);
        }
        for (i = 0; i < frames; ++i) {
            for (int j = 0; j < tags; ++j) {
                MD3Tag var11 = tagList[j];
                var11.name = MD3Loader.readString(md3Model, 64);
            }
        }
        for (i = 0; i < tags; ++i) {
            model.tags.put(tagList[i].name, tagList[i]);
        }
        md3Model.position(surfaceOffset);
        for (i = 0; i < surfaces; ++i) {
            model.surfaces[i] = this.loadSurface(md3Model);
        }
        return model;
    }

    private MD3Surface loadSurface(ByteBuffer md3Model) throws IOException {
        int i;
        int position = md3Model.position();
        if (!MD3Loader.readString(md3Model, 4).equals("IDP3")) {
            throw new IOException("Not a valid MD3 file (bad surface magic number)");
        }
        String name = MD3Loader.readString(md3Model, 64);
        System.out.println("Name: " + name);
        md3Model.getInt();
        int frames = md3Model.getInt();
        int shaderCount = md3Model.getInt();
        int verts = md3Model.getInt();
        int triangles = md3Model.getInt();
        MD3Surface surface = new MD3Surface(triangles, verts, frames);
        int ofsTriangles = md3Model.getInt() + position;
        int ofsShaders = md3Model.getInt() + position;
        int ofsSt = md3Model.getInt() + position;
        position += md3Model.getInt();
        md3Model.getInt();
        surface.verts = verts;
        surface.shaders = new MD3Shader[shaderCount];
        System.out.println("Triangles: " + triangles);
        System.out.println("OFS_SHADERS: " + ofsShaders + " (current location: " + md3Model.position() + ")");
        md3Model.position(ofsShaders);
        for (i = 0; i < shaderCount; ++i) {
            MD3Shader shader = new MD3Shader();
            MD3Loader.readString(md3Model, 64);
            md3Model.getInt();
            surface.shaders[i] = shader;
        }
        System.out.println("OFS_TRIANGLES: " + ofsTriangles + " (current location: " + md3Model.position() + ")");
        md3Model.position(ofsTriangles);
        for (i = 0; i < triangles * 3; ++i) {
            surface.triangles.put(md3Model.getInt());
        }
        System.out.println("OFS_ST: " + ofsSt + " (current location: " + md3Model.position() + ")");
        md3Model.position(ofsSt);
        for (i = 0; i < verts << 1; ++i) {
            surface.d.put(md3Model.getFloat());
        }
        System.out.println("OFS_XYZ_NORMAL: " + position + " (current location: " + md3Model.position() + ")");
        md3Model.position(position);
        for (i = 0; i < verts * frames; ++i) {
            surface.vertices.put((float)md3Model.getShort() / 64.0f);
            surface.vertices.put((float)md3Model.getShort() / 64.0f);
            surface.vertices.put((float)md3Model.getShort() / 64.0f);
            double var15 = (double)(md3Model.get() & 0xFF) * Math.PI * 2.0 / 255.0;
            double var17 = (double)(md3Model.get() & 0xFF) * Math.PI * 2.0 / 255.0;
            float var19 = (float)(Math.cos(var17) * Math.sin(var15));
            float var21 = (float)(Math.sin(var17) * Math.sin(var15));
            float var22 = (float)Math.cos(var15);
            surface.normals.put(var19);
            surface.normals.put(var21);
            surface.normals.put(var22);
        }
        return surface;
    }

    private static String readString(ByteBuffer md3Model, int bytePos) {
        byte[] bytes = new byte[bytePos];
        md3Model.get(bytes);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0) continue;
            return new String(bytes, 0, i);
        }
        return new String(bytes);
    }
}

