/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.event;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.capability.RediscoveredPiglinCapability;
import com.legacy.rediscovered.capability.util.CapabilityProvider;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.ScarecrowEntity;
import com.legacy.rediscovered.entity.util.MountableBlockEntity;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredDimensions;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.legacy.rediscovered.world.AnvilRecipeManager;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.GiantEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RediscoveredEvents {
    protected static Random itemRand = new Random();

    @SubscribeEvent
    public void onCapabilityAttached(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ZombifiedPiglinEntity && !((Entity)event.getObject()).getCapability(RediscoveredPiglinCapability.INSTANCE).isPresent()) {
            event.addCapability(RediscoveredMod.locate("pigman_capability"), (ICapabilityProvider)new CapabilityProvider(new RediscoveredPiglinCapability((ZombifiedPiglinEntity)event.getObject())));
        }
    }

    @SubscribeEvent
    public void anvilUpdate(AnvilUpdateEvent event) {
        AnvilRecipeManager.AnvilRecipe recipe;
        if (RediscoveredMod.anvilRecipeManager.getRecipes().containsKey(event.getLeft().func_77973_b()) && event.getRight().func_77973_b() == RediscoveredItems.quiver && (recipe = RediscoveredMod.anvilRecipeManager.getRecipes().get(event.getLeft().func_77973_b())) != null) {
            ItemStack output = new ItemStack((IItemProvider)recipe.outputItem);
            CompoundNBT leftNBT = event.getLeft().func_77978_p();
            CompoundNBT outputNBT = new CompoundNBT();
            if (leftNBT != null) {
                outputNBT = leftNBT.func_74737_b();
            }
            output.func_77982_d(outputNBT);
            if (!event.getName().isEmpty()) {
                output.func_200302_a((ITextComponent)new StringTextComponent(event.getName()));
            }
            int c = 0;
            if (event.getLeft().func_82837_s()) {
                if (!new StringTextComponent(event.getName()).toString().equals(event.getLeft().func_200301_q().toString())) {
                    c = 1;
                }
            } else if (!event.getName().isEmpty()) {
                c = 1;
            }
            event.setOutput(output);
            event.setCost(recipe.cost + c);
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        PlayerEntity player = event.getPlayer();
        PlayerInventory inv = player.field_71071_by;
        ItemStack itemStack = inv.func_70301_a(inv.field_70461_c);
        World world = event.getEntityLiving().field_70170_p;
        if (!(RediscoveredConfig.disableBedTeleportation || player.field_70170_p.func_234923_W_() != World.field_234918_g_ || world.func_72935_r() || itemRand.nextInt(100) > 12 || itemStack != null && itemStack.func_77973_b() == RediscoveredItems.dream_pillow || !(player instanceof ServerPlayerEntity))) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            RegistryKey<World> transferDimension = player.field_70170_p.func_234923_W_() == RediscoveredDimensions.skylandsKey() ? World.field_234918_g_ : RediscoveredDimensions.skylandsKey();
            serverPlayer.func_200619_a(player.func_184102_h().func_71218_a(transferDimension), 2.5, 80.0, 2.5, serverPlayer.field_70177_z, serverPlayer.field_70125_A);
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof ServerPlayerEntity && event.getEntityLiving().field_70170_p.func_234923_W_() == RediscoveredDimensions.skylandsKey() && event.getSource() == DamageSource.field_76380_i) {
            ServerWorld world = (ServerWorld)event.getEntityLiving().field_70170_p;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)event.getEntityLiving();
            if (serverPlayer.func_226278_cu_() <= 10.0) {
                event.setCanceled(true);
                IChunk chunk = serverPlayer.func_184102_h().func_71218_a(World.field_234918_g_).func_217349_x(serverPlayer.func_233580_cy_());
                int transferY = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, serverPlayer.func_233580_cy_().func_177958_n(), serverPlayer.func_233580_cy_().func_177952_p()) + 1;
                Vector3d teleportationPos = new Vector3d((double)serverPlayer.func_233580_cy_().func_177958_n() + 0.5, (double)transferY, (double)serverPlayer.func_233580_cy_().func_177952_p() + 0.5);
                serverPlayer.func_200619_a(serverPlayer.func_184102_h().func_71218_a(World.field_234918_g_), teleportationPos.func_82615_a(), teleportationPos.func_82617_b(), teleportationPos.func_82616_c(), serverPlayer.field_70177_z, serverPlayer.field_70125_A);
                BlockPos coordinates = serverPlayer.func_233580_cy_();
                if (coordinates != null) {
                    coordinates = RediscoveredEvents.verifyRespawnCoordinates((World)serverPlayer.func_184102_h().func_71218_a(World.field_234918_g_), coordinates, true, serverPlayer);
                }
                if (coordinates == null) {
                    coordinates = world.func_241135_u_();
                    serverPlayer.func_70634_a((double)coordinates.func_177958_n() + 0.5, (double)coordinates.func_177956_o() + 3.0, (double)coordinates.func_177952_p() + 0.5);
                    serverPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("message.missingbed"), true);
                } else if (coordinates != null) {
                    serverPlayer.func_70634_a((double)coordinates.func_177958_n() + 0.5, (double)coordinates.func_177956_o() + 3.0, (double)coordinates.func_177952_p() + 0.5);
                }
                serverPlayer.field_70143_R = 0.0f;
                serverPlayer.func_213317_d(Vector3d.field_186680_a);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        PlayerInventory inv = player.field_71071_by;
        ItemStack itemStack = inv.func_70301_a(inv.field_70461_c);
        World world = event.getEntityLiving().field_70170_p;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && world.func_180495_p(event.getPos()).func_177230_c() instanceof BedBlock && (itemStack != null && itemStack.func_77973_b() == RediscoveredItems.dream_pillow && (RediscoveredConfig.daytimeDreamPillow || !RediscoveredConfig.daytimeDreamPillow && !world.func_72935_r()) || player.field_70170_p.func_234923_W_() == RediscoveredDimensions.skylandsKey()) && player instanceof ServerPlayerEntity) {
            event.setCanceled(true);
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (player.field_70170_p.func_234923_W_() == World.field_234918_g_) {
                player.func_213369_d(event.getPos());
                serverPlayer.func_242111_a(World.field_234918_g_, event.getPos(), 0.0f, false, true);
                serverPlayer.func_200619_a(player.func_184102_h().func_71218_a(RediscoveredDimensions.skylandsKey()), 2.5, 80.0, 2.5, serverPlayer.field_70177_z, serverPlayer.field_70125_A);
            } else if (player.field_70170_p.func_234923_W_() == RediscoveredDimensions.skylandsKey()) {
                IChunk chunk = player.func_184102_h().func_71218_a(World.field_234918_g_).func_217349_x(player.func_233580_cy_());
                int transferY = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, player.func_233580_cy_().func_177958_n(), player.func_233580_cy_().func_177952_p()) + 1;
                Vector3d teleportationPos = new Vector3d((double)player.func_233580_cy_().func_177958_n() + 0.5, (double)transferY, (double)player.func_233580_cy_().func_177952_p() + 0.5);
                serverPlayer.func_200619_a(player.func_184102_h().func_71218_a(World.field_234918_g_), teleportationPos.func_82615_a(), teleportationPos.func_82617_b(), teleportationPos.func_82616_c(), serverPlayer.field_70177_z, serverPlayer.field_70125_A);
                BlockPos coordinates = serverPlayer.func_241140_K_();
                if (coordinates != null) {
                    coordinates = RediscoveredEvents.verifyRespawnCoordinates((World)player.func_184102_h().func_71218_a(World.field_234918_g_), coordinates, true, serverPlayer);
                }
                if (coordinates == null) {
                    coordinates = serverPlayer.func_71121_q().func_241135_u_();
                    serverPlayer.func_70634_a((double)coordinates.func_177958_n() + 0.5, (double)coordinates.func_177956_o() + 3.0, (double)coordinates.func_177952_p() + 0.5);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.missingbed"), true);
                } else if (coordinates != null) {
                    serverPlayer.func_70634_a((double)coordinates.func_177958_n() + 0.5, (double)coordinates.func_177956_o() + 3.0, (double)coordinates.func_177952_p() + 0.5);
                }
            }
        }
        if (world.func_180495_p(event.getPos()).func_177230_c() instanceof DoublePlantBlock && itemStack != null && itemStack.func_77973_b().equals(Items.field_151097_aZ) && player instanceof ServerPlayerEntity) {
            ItemEntity item;
            ItemStack itemStack2;
            event.setCanceled(true);
            if (world.func_180495_p(event.getPos()) == Blocks.field_196802_gf.func_176223_P() || world.func_180495_p(event.getPos().func_177977_b()) == Blocks.field_196802_gf.func_176223_P()) {
                if (world.func_180495_p(event.getPos()) == Blocks.field_196802_gf.func_176223_P()) {
                    world.func_175655_b(event.getPos(), false);
                    world.func_175655_b(event.getPos().func_177984_a(), false);
                    world.func_175656_a(event.getPos(), (BlockState)RediscoveredBlocks.empty_rose_bush.func_176223_P().func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
                    world.func_175656_a(event.getPos().func_177984_a(), (BlockState)RediscoveredBlocks.empty_rose_bush.func_176223_P().func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER));
                } else if (world.func_180495_p(event.getPos().func_177977_b()) == Blocks.field_196802_gf.func_176223_P()) {
                    world.func_175655_b(event.getPos().func_177977_b(), false);
                    world.func_175655_b(event.getPos(), false);
                    world.func_175656_a(event.getPos().func_177977_b(), (BlockState)RediscoveredBlocks.empty_rose_bush.func_176223_P().func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
                    world.func_175656_a(event.getPos(), (BlockState)RediscoveredBlocks.empty_rose_bush.func_176223_P().func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER));
                }
                itemStack2 = new ItemStack((IItemProvider)RediscoveredBlocks.rose, world.field_73012_v.nextInt(3) + 1);
                item = new ItemEntity(world, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), itemStack2);
                world.func_217376_c((Entity)item);
            }
            if (world.func_180495_p(event.getPos()) == Blocks.field_196803_gg.func_176223_P() || world.func_180495_p(event.getPos().func_177977_b()) == Blocks.field_196803_gg.func_176223_P()) {
                if (world.func_180495_p(event.getPos()) == Blocks.field_196803_gg.func_176223_P()) {
                    world.func_175655_b(event.getPos(), false);
                    world.func_175655_b(event.getPos().func_177984_a(), false);
                    world.func_175656_a(event.getPos(), (BlockState)RediscoveredBlocks.empty_peony_bush.func_176223_P().func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
                    world.func_175656_a(event.getPos().func_177984_a(), (BlockState)RediscoveredBlocks.empty_peony_bush.func_176223_P().func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER));
                    world.func_175656_a(event.getPos(), (BlockState)RediscoveredBlocks.empty_peony_bush.func_176223_P().func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
                } else if (world.func_180495_p(event.getPos().func_177977_b()) == Blocks.field_196803_gg.func_176223_P()) {
                    world.func_175655_b(event.getPos().func_177977_b(), false);
                    world.func_175655_b(event.getPos(), false);
                    world.func_175656_a(event.getPos().func_177977_b(), (BlockState)RediscoveredBlocks.empty_peony_bush.func_176223_P().func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
                    world.func_175656_a(event.getPos(), (BlockState)RediscoveredBlocks.empty_peony_bush.func_176223_P().func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER));
                }
                itemStack2 = new ItemStack((IItemProvider)RediscoveredBlocks.paeonia, world.field_73012_v.nextInt(3) + 1);
                item = new ItemEntity(world, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), itemStack2);
                world.func_217376_c((Entity)item);
            }
            event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
        }
    }

    @SubscribeEvent
    public void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (RediscoveredConfig.zombieHorsesInSiege && event.getEntityLiving().field_70170_p.func_226660_f_(event.getEntityLiving().func_233580_cy_()) && !event.getEntityLiving().field_70170_p.field_72995_K && event.getSpawnReason() == SpawnReason.EVENT && event.getResult() != Event.Result.DENY && event.getEntityLiving().func_200600_R() == EntityType.field_200725_aD && event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() < 0.2f) {
            World world = event.getEntityLiving().field_70170_p;
            ZombieHorseEntity horse = (ZombieHorseEntity)EntityType.field_200726_aE.func_200721_a(event.getEntityLiving().field_70170_p);
            horse.func_110234_j(true);
            horse.func_70107_b(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_());
            world.func_217376_c((Entity)horse);
            event.getEntityLiving().func_184205_a((Entity)horse, true);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof CreatureEntity) {
            CreatureEntity entity = (CreatureEntity)event.getEntity();
            if (event.getEntity() instanceof ZombieEntity) {
                if (RediscoveredConfig.mobsAttackScarecrow) {
                    entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, ScarecrowEntity.class, true));
                } else {
                    entity.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal(entity, ScarecrowEntity.class, 8.0f, 0.6, 0.6));
                }
            }
            if (event.getEntity() instanceof AnimalEntity) {
                entity.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal(entity, ScarecrowEntity.class, 8.0f, 1.0, 1.0));
            }
            if (event.getEntity() instanceof GiantEntity) {
                entity.func_110148_a(Attributes.field_233823_f_).func_111128_a(10.0);
                entity.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal(entity, 0.5, true){

                    protected double func_179512_a(LivingEntity attackTarget) {
                        return 19.0;
                    }
                });
                entity.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal(entity, 0.5));
                entity.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)entity, PlayerEntity.class, 8.0f));
                entity.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)entity));
                entity.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal(entity, new Class[0]));
                entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, true));
            }
        }
        if (!event.getEntity().field_70170_p.field_72995_K && RediscoveredConfig.chanceHostilesSpawnWithPlateArmor > 0 && (event.getEntity() instanceof ZombieEntity || event.getEntity() instanceof SkeletonEntity) && (RediscoveredConfig.chanceHostilesSpawnWithPlateArmor == 1 || RediscoveredConfig.chanceHostilesSpawnWithPlateArmor > 1 && event.getWorld().field_73012_v.nextInt(RediscoveredConfig.chanceHostilesSpawnWithPlateArmor) == 0)) {
            ((CreatureEntity)event.getEntity()).func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)RediscoveredItems.plate_helmet));
            ((CreatureEntity)event.getEntity()).func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)RediscoveredItems.plate_chestplate));
        }
    }

    @SubscribeEvent
    public void onPlayerRightClick(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().func_77973_b() instanceof BowItem) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack bow = event.getItemStack();
            ItemStack chestPlate = player.func_184582_a(EquipmentSlotType.CHEST);
            ItemStack ammo = player.func_213356_f(bow);
            if (chestPlate != null && !chestPlate.func_190926_b() && RediscoveredTags.Items.QUIVERS.func_230235_a_((Object)chestPlate.func_77973_b())) {
                player.field_70170_p.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
                ArrowEntity arrowEntity = new ArrowEntity(player.field_70170_p, (LivingEntity)player);
                boolean infiniteFlag = false;
                if (ammo.func_77973_b() instanceof ArrowItem) {
                    arrowEntity = ((ArrowItem)ammo.func_77973_b()).func_200887_a(event.getWorld(), ammo, (LivingEntity)player);
                    infiniteFlag = ((ArrowItem)ammo.func_77973_b()).isInfinite(ammo, bow, player);
                }
                arrowEntity.func_70243_d(true);
                arrowEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.3f, 1.0f);
                if (!player.field_70170_p.field_72995_K) {
                    if (player.func_184812_l_() || infiniteFlag) {
                        arrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                    } else {
                        ammo.func_190918_g(1);
                    }
                    bow.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(player.func_184600_cs()));
                    player.field_70170_p.func_217376_c((Entity)arrowEntity);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof ZombifiedPiglinEntity) {
            RediscoveredPiglinCapability.ifPresent((ZombifiedPiglinEntity)event.getEntityLiving(), piglin -> piglin.tick());
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickAxe(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().func_77973_b() instanceof AxeItem) {
            BlockRayTraceResult rayTraceResult;
            BlockPos pos;
            PlayerEntity player = event.getPlayer();
            World world = event.getWorld();
            BlockState blockState = world.func_180495_p(pos = (rayTraceResult = (BlockRayTraceResult)RediscoveredEvents.rayTrace(world, player)).func_216350_a());
            if (blockState.func_177230_c() == RediscoveredBlocks.cherry_log) {
                player.func_130014_f_().func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, (BlockState)RediscoveredBlocks.stripped_cherry_log.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, blockState.func_177229_b((Property)RotatedPillarBlock.field_176298_M)), 11);
                    if (player != null) {
                        event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
                    }
                }
            }
            if (blockState.func_177230_c() == RediscoveredBlocks.cherry_wood) {
                player.func_130014_f_().func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, (BlockState)RediscoveredBlocks.stripped_cherry_wood.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, blockState.func_177229_b((Property)RotatedPillarBlock.field_176298_M)), 11);
                    if (player != null) {
                        event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockRayTraceResult rayTraceResult;
        BlockPos pos;
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        BlockState blockState = world.func_180495_p(pos = (rayTraceResult = (BlockRayTraceResult)RediscoveredEvents.rayTrace(world, player)).func_216350_a());
        if (RediscoveredTags.Blocks.CHAIRS.func_230235_a_((Object)blockState.func_177230_c())) {
            event.getPlayer().func_184609_a(Hand.MAIN_HAND);
            List listEMB = world.func_217357_a(MountableBlockEntity.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 1.0).func_72321_a(1.0, 1.0, 1.0));
            for (MountableBlockEntity entitytocheck : listEMB) {
                if (entitytocheck.orgBlockPosX != pos.func_177958_n() || entitytocheck.orgBlockPosY != pos.func_177956_o() || entitytocheck.orgBlockPosZ != pos.func_177952_p()) continue;
                entitytocheck.interact(player);
                return;
            }
            float mountingX = (float)pos.func_177958_n() + 0.5f;
            float mountingY = pos.func_177956_o();
            float mountingZ = (float)pos.func_177952_p() + 0.5f;
            MountableBlockEntity nemb = new MountableBlockEntity(world, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), mountingX, mountingY, mountingZ);
            world.func_217376_c((Entity)nemb);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (RediscoveredConfig.allowPiglinConversion && event.getTarget().func_200600_R() == EntityType.field_233592_ba_ && ((ZombifiedPiglinEntity)event.getTarget()).func_70644_a(Effects.field_76437_t) && event.getPlayer().func_184614_ca().func_77973_b() == Items.field_151150_bK) {
            ZombifiedPiglinEntity zombiePigman = (ZombifiedPiglinEntity)event.getTarget();
            RediscoveredPiglinCapability.ifPresent(zombiePigman, piglinCap -> piglinCap.startConverting(event.getPlayer().func_110124_au(), zombiePigman.field_70170_p.field_73012_v.nextInt(2401) + 3600));
            if (!zombiePigman.func_174814_R()) {
                zombiePigman.func_184185_a(SoundEvents.field_187942_hp, 1.0f + zombiePigman.field_70170_p.field_73012_v.nextFloat(), zombiePigman.field_70170_p.field_73012_v.nextFloat() * 0.7f + 0.3f);
            }
            if (!event.getPlayer().field_71075_bZ.field_75098_d) {
                event.getPlayer().func_184614_ca().func_190918_g(1);
            }
            return;
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (!RediscoveredConfig.disableGiantAppleDrops && event.getEntityLiving() instanceof GiantEntity && event.getEntityLiving().field_70170_p.field_73012_v.nextInt(5) == 0 && event.getEntityLiving().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack apple = new ItemStack((IItemProvider)Items.field_151153_ao);
            apple.func_190920_e(event.getEntityLiving().field_70170_p.field_73012_v.nextInt(2) + 1);
            event.getEntityLiving().func_199701_a_(apple);
        }
    }

    public static BlockPos verifyRespawnCoordinates(World par0World, BlockPos par1ChunkCoordinates, boolean par2, ServerPlayerEntity player) {
        if (player.func_184102_h().func_71218_a(World.field_234918_g_).func_180495_p(par1ChunkCoordinates).func_177230_c() instanceof BedBlock) {
            return par1ChunkCoordinates;
        }
        return null;
    }

    protected static RayTraceResult rayTrace(World worldIn, PlayerEntity player) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get());
        Vector3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)player));
    }
}

