/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.item.ParentingArmorItem;
import com.legacy.rediscovered.item.ParentingItem;
import com.legacy.rediscovered.item.ParentingSpawnEggItem;
import com.legacy.rediscovered.item.PurpleArrowItem;
import com.legacy.rediscovered.item.QuiverChestplateItem;
import com.legacy.rediscovered.item.ScarecrowItem;
import com.legacy.rediscovered.item.util.ParentingBlockItem;
import com.legacy.rediscovered.item.util.RediscoveredArmorMaterials;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.FishBucketItem;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.item.Rarity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class RediscoveredItems {
    public static Item dream_pillow;
    public static Item ruby;
    public static Item purple_arrow;
    public static Item pigman_spawn_egg;
    public static Item melee_pigman_spawn_egg;
    public static Item ranged_pigman_spawn_egg;
    public static Item steve_spawn_egg;
    public static Item rana_spawn_egg;
    public static Item black_steve_spawn_egg;
    public static Item beast_boy_spawn_egg;
    public static Item fish_spawn_egg;
    public static Item studded_helmet;
    public static Item studded_chestplate;
    public static Item studded_leggings;
    public static Item studded_boots;
    public static Item plate_helmet;
    public static Item plate_chestplate;
    public static Item leather_quiver;
    public static Item chainmail_quiver;
    public static Item iron_quiver;
    public static Item golden_quiver;
    public static Item diamond_quiver;
    public static Item netherite_quiver;
    public static Item studded_quiver;
    public static Item plate_quiver;
    public static Item quiver;
    public static Item raw_fish;
    public static Item cooked_fish;
    public static Item fish_bucket;
    public static Item scarecrow;
    public static Item music_disc_calm4;
    private static IForgeRegistry<Item> iItemRegistry;

    public static void init(RegistryEvent.Register<Item> event) {
        iItemRegistry = event.getRegistry();
        RediscoveredItems.registerBlockItems();
        pigman_spawn_egg = RediscoveredItems.register("pigman_spawn_egg", (Item)new ParentingSpawnEggItem(RediscoveredEntityTypes.PIGMAN, 15771042, 0xA1A1A1, new Item.Properties().func_200916_a(ItemGroup.field_78026_f), Items.field_234772_oO_));
        melee_pigman_spawn_egg = RediscoveredItems.register("melee_pigman_spawn_egg", (Item)new ParentingSpawnEggItem(RediscoveredEntityTypes.MELEE_PIGMAN, 15771042, 0xA1A1A1, new Item.Properties().func_200916_a(ItemGroup.field_78026_f), pigman_spawn_egg));
        ranged_pigman_spawn_egg = RediscoveredItems.register("ranged_pigman_spawn_egg", (Item)new ParentingSpawnEggItem(RediscoveredEntityTypes.RANGED_PIGMAN, 15771042, 0xA1A1A1, new Item.Properties().func_200916_a(ItemGroup.field_78026_f), melee_pigman_spawn_egg));
        steve_spawn_egg = RediscoveredItems.register("steve_spawn_egg", (Item)new ParentingSpawnEggItem(RediscoveredEntityTypes.STEVE, 44975, 16167425, new Item.Properties().func_200916_a(ItemGroup.field_78026_f), ranged_pigman_spawn_egg));
        rana_spawn_egg = RediscoveredItems.register("rana_spawn_egg", (Item)new ParentingSpawnEggItem(RediscoveredEntityTypes.RANA, 5009705, 15771042, new Item.Properties().func_200916_a(ItemGroup.field_78026_f), steve_spawn_egg));
        black_steve_spawn_egg = RediscoveredItems.register("black_steve_spawn_egg", (Item)new ParentingSpawnEggItem(RediscoveredEntityTypes.BLACK_STEVE, 10489616, 894731, new Item.Properties().func_200916_a(ItemGroup.field_78026_f), rana_spawn_egg));
        beast_boy_spawn_egg = RediscoveredItems.register("beast_boy_spawn_egg", (Item)new ParentingSpawnEggItem(RediscoveredEntityTypes.BEAST_BOY, 10040012, 5349438, new Item.Properties().func_200916_a(ItemGroup.field_78026_f), black_steve_spawn_egg));
        fish_spawn_egg = RediscoveredItems.register("fish_spawn_egg", (Item)new ParentingSpawnEggItem(RediscoveredEntityTypes.FISH, 44975, 2243405, new Item.Properties().func_200916_a(ItemGroup.field_78026_f), beast_boy_spawn_egg));
        dream_pillow = RediscoveredItems.register("dream_pillow", new Item(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        ruby = RediscoveredItems.register("ruby", new ParentingItem(new Item.Properties().func_200916_a(ItemGroup.field_78035_l), Items.field_151166_bC));
        raw_fish = RediscoveredItems.register("raw_fish", new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221434_j)));
        cooked_fish = RediscoveredItems.register("cooked_fish", new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221437_m)));
        fish_bucket = RediscoveredItems.register("fish_bucket", (Item)new FishBucketItem(() -> RediscoveredEntityTypes.FISH, () -> Fluids.field_204546_a, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        studded_helmet = RediscoveredItems.register("studded_helmet", (Item)new ParentingArmorItem.Dyeable(RediscoveredArmorMaterials.LEATHER_CHAIN, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(ItemGroup.field_78037_j), Items.field_151021_T));
        studded_chestplate = RediscoveredItems.register("studded_chestplate", (Item)new ParentingArmorItem.Dyeable(RediscoveredArmorMaterials.LEATHER_CHAIN, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(ItemGroup.field_78037_j), studded_helmet));
        studded_leggings = RediscoveredItems.register("studded_leggings", (Item)new ParentingArmorItem.Dyeable(RediscoveredArmorMaterials.LEATHER_CHAIN, EquipmentSlotType.LEGS, new Item.Properties().func_200916_a(ItemGroup.field_78037_j), studded_chestplate));
        studded_boots = RediscoveredItems.register("studded_boots", (Item)new ParentingArmorItem.Dyeable(RediscoveredArmorMaterials.LEATHER_CHAIN, EquipmentSlotType.FEET, new Item.Properties().func_200916_a(ItemGroup.field_78037_j), studded_leggings));
        plate_helmet = RediscoveredItems.register("plate_helmet", (Item)new ParentingArmorItem(RediscoveredArmorMaterials.PLATE, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(ItemGroup.field_78037_j), Items.field_151167_ab));
        plate_chestplate = RediscoveredItems.register("plate_chestplate", (Item)new ParentingArmorItem(RediscoveredArmorMaterials.PLATE, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(ItemGroup.field_78037_j), plate_helmet));
        quiver = RediscoveredItems.register("quiver", (Item)new ParentingArmorItem(RediscoveredArmorMaterials.QUIVER, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(ItemGroup.field_78037_j), Items.field_151032_g));
        leather_quiver = RediscoveredItems.register("leather_quiver", (Item)new QuiverChestplateItem.Dyeable(() -> Items.field_151027_R));
        chainmail_quiver = RediscoveredItems.register("chainmail_quiver", (Item)new QuiverChestplateItem(() -> Items.field_151023_V));
        iron_quiver = RediscoveredItems.register("iron_quiver", (Item)new QuiverChestplateItem(() -> Items.field_151030_Z));
        golden_quiver = RediscoveredItems.register("golden_quiver", (Item)new QuiverChestplateItem(() -> Items.field_151171_ah));
        diamond_quiver = RediscoveredItems.register("diamond_quiver", (Item)new QuiverChestplateItem(() -> Items.field_151163_ad));
        netherite_quiver = RediscoveredItems.register("netherite_quiver", (Item)new QuiverChestplateItem(() -> Items.field_234764_lt_));
        studded_quiver = RediscoveredItems.register("studded_quiver", (Item)new QuiverChestplateItem.Dyeable(() -> studded_chestplate));
        plate_quiver = RediscoveredItems.register("plate_quiver", (Item)new QuiverChestplateItem(() -> plate_chestplate));
        music_disc_calm4 = RediscoveredItems.register("music_disc_calm4", (Item)new MusicDiscItem(3, () -> RediscoveredSounds.RECORDS_CALM_4, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(Rarity.RARE)));
        scarecrow = RediscoveredItems.register("scarecrow", new ScarecrowItem(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        purple_arrow = RediscoveredItems.register("purple_arrow", (Item)new PurpleArrowItem(new Item.Properties()));
    }

    private static void registerBlockItems() {
        for (Map.Entry<Block, Pair<ItemGroup, Item>> entry : RediscoveredBlocks.blockItemMap.entrySet()) {
            RediscoveredRegistry.register(iItemRegistry, entry.getKey().getRegistryName().func_110623_a(), new ParentingBlockItem(entry.getKey(), new Item.Properties().func_200916_a((ItemGroup)entry.getValue().getFirst()), (Item)entry.getValue().getSecond()));
        }
        RediscoveredBlocks.blockItemMap.clear();
        for (Map.Entry<Block, Pair<ItemGroup, Item>> entry : RediscoveredBlocks.blockItemPropertiesMap.entrySet()) {
            RediscoveredRegistry.register(iItemRegistry, entry.getKey().getRegistryName().func_110623_a(), new BlockItem(entry.getKey(), (Item.Properties)entry.getValue()));
        }
        RediscoveredBlocks.blockItemPropertiesMap.clear();
    }

    private static Item register(String name, Item item) {
        RediscoveredRegistry.register(iItemRegistry, name, item);
        return item;
    }
}

