/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.biome.feature.structure;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.entity.BeastBoyEntity;
import com.legacy.rediscovered.entity.BlackSteveEntity;
import com.legacy.rediscovered.entity.RanaEntity;
import com.legacy.rediscovered.entity.SteveEntity;
import com.legacy.rediscovered.entity.pigman.MeleePigmanEntity;
import com.legacy.rediscovered.entity.pigman.PigmanEntity;
import com.legacy.rediscovered.entity.pigman.RangedPigmanEntity;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.legacy.rediscovered.world.biome.feature.RediscoveredStructurePieceTypes;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SmallPigmanVillagePieces {
    private static final ResourceLocation north_west = SmallPigmanVillagePieces.locatePiece("north_west");
    private static final ResourceLocation north_west_bottom = SmallPigmanVillagePieces.locatePiece("north_west_bottom");
    private static final ResourceLocation north_east = SmallPigmanVillagePieces.locatePiece("north_east");
    private static final ResourceLocation north_east_bottom = SmallPigmanVillagePieces.locatePiece("north_east_bottom");
    private static final ResourceLocation south_west = SmallPigmanVillagePieces.locatePiece("south_west");
    private static final ResourceLocation south_west_bottom = SmallPigmanVillagePieces.locatePiece("south_west_bottom");
    private static final ResourceLocation south_east = SmallPigmanVillagePieces.locatePiece("south_east");
    private static final ResourceLocation south_east_bottom = SmallPigmanVillagePieces.locatePiece("south_east_bottom");

    public static void init(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> structurePieces, Random random) {
        structurePieces.add((StructurePiece)new Piece(templateManager, north_west_bottom, pos, rotation));
        structurePieces.add((StructurePiece)new Piece(templateManager, north_west, pos.func_177982_a(0, 32, 0), rotation));
        structurePieces.add((StructurePiece)new Piece(templateManager, north_east_bottom, pos.func_177982_a(25, 0, 0), rotation));
        structurePieces.add((StructurePiece)new Piece(templateManager, north_east, pos.func_177982_a(25, 32, 0), rotation));
        structurePieces.add((StructurePiece)new Piece(templateManager, south_west_bottom, pos.func_177982_a(0, 0, 26), rotation));
        structurePieces.add((StructurePiece)new Piece(templateManager, south_west, pos.func_177982_a(0, 32, 26), rotation));
        structurePieces.add((StructurePiece)new Piece(templateManager, south_east_bottom, pos.func_177982_a(25, 0, 26), rotation));
        structurePieces.add((StructurePiece)new Piece(templateManager, south_east, pos.func_177982_a(25, 32, 26), rotation));
    }

    static ResourceLocation locatePiece(String location) {
        return RediscoveredMod.locate("village/small/village_" + location);
    }

    private static ItemStack pickCheckTowerLootItem(Random random) {
        int i = random.nextInt(9);
        if (i == 0) {
            return new ItemStack((IItemProvider)Items.field_151043_k);
        }
        if (i == 1) {
            return new ItemStack((IItemProvider)Items.field_151042_j, random.nextInt(4) + 1);
        }
        if (i == 2) {
            return new ItemStack((IItemProvider)Items.field_151172_bF, random.nextInt(3) + 1);
        }
        if (i == 3 && random.nextInt(1) == 0) {
            return new ItemStack((IItemProvider)Items.field_151031_f);
        }
        if (i == 4 && random.nextInt(1) == 0) {
            return new ItemStack((IItemProvider)RediscoveredItems.quiver);
        }
        if (i == 5 && random.nextInt(2) == 0) {
            return new ItemStack((IItemProvider)Items.field_151150_bK, random.nextInt(4) + 1);
        }
        if (i == 6 && random.nextInt(1) == 0) {
            return new ItemStack((IItemProvider)RediscoveredItems.leather_quiver);
        }
        if (i == 7 && random.nextInt(40) == 0) {
            return new ItemStack((IItemProvider)Items.field_151045_i);
        }
        if (i == 8 && random.nextInt(2) == 0) {
            return new ItemStack((IItemProvider)Items.field_151074_bl, random.nextInt(4) + 1);
        }
        return new ItemStack((IItemProvider)Items.field_151055_y);
    }

    private static ItemStack pickCheckForgeLootItem(Random random) {
        int i = random.nextInt(10);
        if (i == 0) {
            return new ItemStack((IItemProvider)Items.field_151043_k);
        }
        if (i == 1) {
            return new ItemStack((IItemProvider)Items.field_151042_j, random.nextInt(4) + 1);
        }
        if (i == 2) {
            return new ItemStack((IItemProvider)Items.field_151172_bF, random.nextInt(3) + 1);
        }
        if (i == 3 && random.nextInt(1) == 0) {
            return new ItemStack((IItemProvider)RediscoveredBlocks.gear, random.nextInt(4) + 1);
        }
        if (i == 4) {
            return new ItemStack((IItemProvider)Items.field_151016_H, random.nextInt(4) + 1);
        }
        if (i == 5 && random.nextInt(2) == 0) {
            return new ItemStack((IItemProvider)Items.field_151150_bK, random.nextInt(4) + 1);
        }
        if (i == 6) {
            return new ItemStack((IItemProvider)Items.field_151133_ar);
        }
        if (i == 7 && random.nextInt(50) == 0) {
            return new ItemStack((IItemProvider)Items.field_151045_i);
        }
        if (i == 8 && random.nextInt(2) == 0) {
            return new ItemStack((IItemProvider)Items.field_151074_bl, random.nextInt(4) + 1);
        }
        if (i == 9 && random.nextInt(5) == 0) {
            return new ItemStack((IItemProvider)RediscoveredItems.music_disc_calm4);
        }
        return new ItemStack((IItemProvider)Items.field_151055_y);
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation location;
        private final Rotation rotation;

        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation) {
            super(RediscoveredStructurePieceTypes.SMALL_PIGMAN_VILLAGE, 0);
            this.location = location;
            this.field_186178_c = pos;
            this.rotation = rotation;
            this.setupTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbtCompound) {
            super(RediscoveredStructurePieceTypes.SMALL_PIGMAN_VILLAGE, nbtCompound);
            this.location = new ResourceLocation(nbtCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)nbtCompound.func_74779_i("Rot"));
            this.setupTemplate(templateManager);
        }

        private void setupTemplate(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.location);
            BlockPos sizePos = templateManager.func_200219_b(this.location).func_186259_a();
            BlockPos centerPos = new BlockPos(sizePos.func_177958_n() / 2, 0, sizePos.func_177952_p() / 2);
            PlacementSettings placementSettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a(centerPos).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementSettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.location.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            block5: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block4: {
                                                    if (!"pigman".equals(function)) break block4;
                                                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                                                    PigmanEntity entity = (PigmanEntity)RediscoveredEntityTypes.PIGMAN.func_200721_a((World)worldIn.func_201672_e());
                                                    entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                                                    worldIn.func_217376_c((Entity)entity);
                                                    break block5;
                                                }
                                                if (!"nitwit".equals(function)) break block6;
                                                if (rand.nextBoolean() && worldIn.func_175659_aa() != Difficulty.PEACEFUL) {
                                                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                                                    IllusionerEntity entity = (IllusionerEntity)EntityType.field_200764_D.func_200721_a((World)worldIn.func_201672_e());
                                                    entity.func_110163_bv();
                                                    entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                                                    worldIn.func_217376_c((Entity)entity);
                                                } else {
                                                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                                                    VillagerEntity entity = (VillagerEntity)EntityType.field_200756_av.func_200721_a((World)worldIn.func_201672_e());
                                                    entity.func_213753_a(entity.func_213700_eh().func_221134_a(VillagerType.field_221175_c).func_221126_a(VillagerProfession.field_221162_l));
                                                    entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                                                    worldIn.func_217376_c((Entity)entity);
                                                }
                                                break block5;
                                            }
                                            if (!"melee_pigman".equals(function)) break block7;
                                            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                                            MeleePigmanEntity entity = (MeleePigmanEntity)RediscoveredEntityTypes.MELEE_PIGMAN.func_200721_a((World)worldIn.func_201672_e());
                                            entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                                            entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                                            worldIn.func_217376_c((Entity)entity);
                                            break block5;
                                        }
                                        if (!"ranged_pigman".equals(function)) break block8;
                                        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                                        RangedPigmanEntity entity = (RangedPigmanEntity)RediscoveredEntityTypes.RANGED_PIGMAN.func_200721_a((World)worldIn.func_201672_e());
                                        entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                                        entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                                        worldIn.func_217376_c((Entity)entity);
                                        break block5;
                                    }
                                    if (!"steve".equals(function)) break block9;
                                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                                    SteveEntity entity = (SteveEntity)RediscoveredEntityTypes.STEVE.func_200721_a((World)worldIn.func_201672_e());
                                    entity.func_70107_b((double)pos.func_177958_n() + 1.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                                    worldIn.func_217376_c((Entity)entity);
                                    break block5;
                                }
                                if (!"rana".equals(function)) break block10;
                                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                                RanaEntity entity = (RanaEntity)RediscoveredEntityTypes.RANA.func_200721_a((World)worldIn.func_201672_e());
                                entity.func_70107_b((double)pos.func_177958_n() + 1.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                                worldIn.func_217376_c((Entity)entity);
                                break block5;
                            }
                            if (!"black_steve".equals(function)) break block11;
                            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                            BlackSteveEntity entity = (BlackSteveEntity)RediscoveredEntityTypes.BLACK_STEVE.func_200721_a((World)worldIn.func_201672_e());
                            entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                            worldIn.func_217376_c((Entity)entity);
                            break block5;
                        }
                        if (!"beast_boy".equals(function)) break block12;
                        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                        BeastBoyEntity entity = (BeastBoyEntity)RediscoveredEntityTypes.BEAST_BOY.func_200721_a((World)worldIn.func_201672_e());
                        entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                        worldIn.func_217376_c((Entity)entity);
                        break block5;
                    }
                    if (!"tower_chest".equals(function)) break block13;
                    worldIn.func_180501_a(pos, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.EAST), 3);
                    ChestTileEntity chest = (ChestTileEntity)worldIn.func_175625_s(pos);
                    for (int i = 0; i < 15; ++i) {
                        chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), SmallPigmanVillagePieces.pickCheckTowerLootItem(rand));
                    }
                    break block5;
                }
                if (!"smith_chest".equals(function)) break block5;
                worldIn.func_180501_a(pos, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.EAST), 3);
                ChestTileEntity chest = (ChestTileEntity)worldIn.func_175625_s(pos);
                for (int i = 0; i < 15; ++i) {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), SmallPigmanVillagePieces.pickCheckForgeLootItem(rand));
                }
            }
        }
    }
}

