/*
 * Decompiled with CFR 0.152.
 */
package baguchan.revampedwolf.network;

import baguchan.revampedwolf.api.IHasInventory;
import baguchan.revampedwolf.client.screen.WolfInventoryScreen;
import baguchan.revampedwolf.inventory.WolfInventoryMenu;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class ClientWolfScreenOpenPacket {
    private final int containerId;
    private final int size;
    private final int entityId;

    public ClientWolfScreenOpenPacket(int containerIdIn, int size, int entityIdIn) {
        this.containerId = containerIdIn;
        this.size = size;
        this.entityId = entityIdIn;
    }

    public static ClientWolfScreenOpenPacket read(FriendlyByteBuf buf) {
        short containerId = buf.readUnsignedByte();
        int size = buf.m_130242_();
        int entityId = buf.readInt();
        return new ClientWolfScreenOpenPacket(containerId, size, entityId);
    }

    public static void write(ClientWolfScreenOpenPacket packet, FriendlyByteBuf buf) {
        buf.writeByte(packet.containerId);
        buf.m_130130_(packet.size);
        buf.writeInt(packet.entityId);
    }

    public static void handle(ClientWolfScreenOpenPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Wolf wolf;
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer clientPlayer = minecraft.f_91074_;
            Entity entity = null;
            if (clientPlayer != null) {
                entity = clientPlayer.f_19853_.m_6815_(packet.entityId);
            }
            if (entity instanceof Wolf && (wolf = (Wolf)entity) instanceof IHasInventory) {
                WolfInventoryMenu wolfInventoryContainer = new WolfInventoryMenu(packet.containerId, clientPlayer.m_150109_(), (Container)((IHasInventory)wolf).getContainer(), wolf);
                clientPlayer.f_36096_ = wolfInventoryContainer;
                WolfInventoryScreen wolfInventoryScreen = new WolfInventoryScreen(wolfInventoryContainer, clientPlayer.m_150109_(), wolf);
                minecraft.m_91152_((Screen)wolfInventoryScreen);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

