/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.ModRsGauges;
import wile.rsgauges.blocks.GaugeBlock;
import wile.rsgauges.blocks.IndicatorBlock;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;
import wile.rsgauges.items.SwitchLinkPearlItem;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class AbstractGaugeBlock
extends RsDirectedBlock
implements SwitchLink.ISwitchLinkable {
    public static final long GAUGE_DATA_POWER_MASK = 15L;
    public static final int GAUGE_DATA_POWER_SHIFT = 0;
    public static final long GAUGE_DATA_BLINKING = 256L;
    public static final long GAUGE_DATA_INVERTED = 512L;
    public static final long GAUGE_DATA_COMPARATOR_MODE = 2048L;
    @Nullable
    public final ModResources.BlockSoundEvent power_on_sound;
    @Nullable
    public final ModResources.BlockSoundEvent power_off_sound;

    public AbstractGaugeBlock(long config, AbstractBlock.Properties props, AxisAlignedBB aabb, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, props, aabb, null);
        this.power_on_sound = powerOnSound;
        this.power_off_sound = powerOffSound;
    }

    public AbstractGaugeBlock(long config, AbstractBlock.Properties props, AxisAlignedBB aabb) {
        this(config, props, aabb, null, null);
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.func_201670_d() || !this.isAffectedByNeigbour(state, (IWorld)world, pos, fromPos)) {
            return;
        }
        GaugeTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te == null) {
            te.reset_timer();
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 1);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack_held = player.func_184586_b(hand);
        if (ModConfig.isWrench(stack_held)) {
            GaugeTileEntity te = this.getTe((IWorldReader)world, pos);
            if (te == null) {
                return ActionResultType.CONSUME;
            }
            te.on_wrench(state, world, pos, player, player.func_184586_b(hand));
        } else if (stack_held.func_77973_b() == Items.field_151079_bi || stack_held.func_77973_b() == ModContent.SWITCH_LINK_PEARL) {
            this.func_196270_a(state, world, pos, player);
        }
        return ActionResultType.CONSUME;
    }

    @Override
    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        ItemStack item_held = player.field_71071_by.func_70448_g();
        if (item_held.func_77973_b() == Items.field_151079_bi) {
            if (ModConfig.without_switch_linking) {
                return;
            }
            ItemStack link_stack = SwitchLinkPearlItem.createFromPearl(world, pos, player);
            if (link_stack.func_190926_b()) {
                Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.target_assign.error_notarget"));
                ModResources.BlockSoundEvents.SWITCHLINK_CANNOT_LINK_THAT.play(world, pos);
            } else {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, link_stack);
                Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.target_assign.ok"));
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_TARGET_SELECTED.play(world, pos);
            }
        } else if (item_held.func_77973_b() == ModContent.SWITCH_LINK_PEARL) {
            if (ModConfig.without_switch_linking) {
                return;
            }
            if (SwitchLinkPearlItem.cycleLinkMode(item_held, world, pos, true)) {
                Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.relayconfig.confval" + Integer.toString(SwitchLink.fromItemStack(item_held).mode().index())));
            } else {
                Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.source_assign.error_nosource"));
            }
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public boolean getWeakChanges(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return state.func_177230_c() instanceof GaugeBlock && side == ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return state == null ? null : (state.func_235901_b_((Property)GaugeBlock.POWER) ? (BlockState)state.func_206870_a((Property)GaugeBlock.POWER, (Comparable)Integer.valueOf(0)) : state);
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new GaugeTileEntity(ModContent.TET_GAUGE);
    }

    @Override
    public boolean isWallMount() {
        return true;
    }

    @Override
    public boolean isCube() {
        return false;
    }

    @Override
    public boolean isLateral() {
        return false;
    }

    @Override
    public boolean switchLinkHasTargetSupport(World world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean switchLinkHasSourceSupport(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean switchLinkHasAnalogSupport(World world, BlockPos pos) {
        return true;
    }

    @Override
    public ImmutableList<SwitchLink.LinkMode> switchLinkGetSupportedTargetModes() {
        return ImmutableList.of((Object)((Object)SwitchLink.LinkMode.AS_STATE), (Object)((Object)SwitchLink.LinkMode.INV_STATE));
    }

    @Override
    public Optional<Integer> switchLinkOutputPower(World world, BlockPos pos) {
        GaugeTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te == null) {
            return Optional.empty();
        }
        return Optional.of(te.power());
    }

    @Override
    public Optional<Integer> switchLinkInputPower(World world, BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public Optional<Integer> switchLinkComparatorInput(World world, BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public SwitchLink.RequestResult switchLinkTrigger(SwitchLink link) {
        GaugeTileEntity te = this.getTe((IWorldReader)link.world, link.target_position);
        if (te == null) {
            return SwitchLink.RequestResult.TARGET_GONE;
        }
        te.switchlink_input(link.source_power);
        return SwitchLink.RequestResult.OK;
    }

    @Override
    public void switchLinkInit(SwitchLink link) {
        GaugeTileEntity te = this.getTe((IWorldReader)link.world, link.target_position);
        if (te != null) {
            te.switchlink_input(link.source_power);
        }
    }

    @Override
    public void switchLinkUnlink(SwitchLink link) {
        GaugeTileEntity te = this.getTe((IWorldReader)link.world, link.target_position);
        if (te != null) {
            te.switchlink_input(0);
        }
    }

    public GaugeTileEntity getTe(IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof GaugeTileEntity ? (GaugeTileEntity)te : null;
    }

    public static class GaugeTileEntity
    extends RsBlock.RsTileEntity
    implements ITickableTileEntity {
        private boolean alternation_state_ = false;
        private long trigger_timer_ = 0L;
        private long scd_ = 0L;
        private long last_wrench_click_ = 0L;
        private int switchlink_input_ = 0;

        public GaugeTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public GaugeTileEntity() {
            super(ModContent.TET_GAUGE);
        }

        public int power() {
            return (int)((this.scd_ & 0xFL) >> 0);
        }

        public void power(int p) {
            this.scd_ = this.scd_ & 0xFFFFFFFFFFFFFFF0L | (long)((p <= 0 ? 0 : (p > 15 ? 15 : p)) << 0) & 0xFL;
        }

        public boolean inverted() {
            return (this.scd_ & 0x200L) != 0L;
        }

        public void inverted(boolean i) {
            this.scd_ = this.scd_ & 0xFFFFFFFFFFFFFDFFL | (i ? 512L : 0L);
        }

        public int switchlink_input() {
            return this.switchlink_input_;
        }

        public void switchlink_input(int power) {
            this.switchlink_input_ = power;
            this.trigger_timer_ = Math.min(this.trigger_timer_, 1L);
        }

        public boolean comparator_mode() {
            return (this.scd_ & 0x800L) != 0L;
        }

        public void comparator_mode(boolean i) {
            this.scd_ = this.scd_ & 0xFFFFFFFFFFFFF7FFL | (i ? 2048L : 0L);
        }

        public void reset_timer() {
            this.trigger_timer_ = 0L;
        }

        public void reset() {
            this.reset((IWorldReader)this.func_145831_w());
        }

        public void reset(IWorldReader world) {
            this.trigger_timer_ = 0L;
            if (world == null) {
                this.scd_ = 0L;
            } else {
                try {
                    long current_scd = this.scd_;
                    this.scd_ = (int)((GaugeBlock)world.func_180495_p((BlockPos)this.func_174877_v()).func_177230_c()).config;
                    if (current_scd != this.scd_) {
                        this.func_70296_d();
                    }
                }
                catch (Exception e) {
                    this.scd_ = 0L;
                }
            }
        }

        public void on_wrench(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack wrench) {
            long t = world.func_82737_E();
            if (Math.abs(t - this.last_wrench_click_) < 40L) {
                switch ((this.inverted() ? 1 : 0) | (this.comparator_mode() ? 2 : 0)) {
                    case 0: {
                        this.inverted(true);
                        this.comparator_mode(false);
                        break;
                    }
                    case 1: {
                        this.inverted(false);
                        this.comparator_mode(true);
                        break;
                    }
                    case 2: {
                        this.inverted(true);
                        this.comparator_mode(true);
                        break;
                    }
                    default: {
                        this.inverted(false);
                        this.comparator_mode(false);
                    }
                }
            }
            this.last_wrench_click_ = t;
            TranslationTextComponent tr = Auxiliaries.localizable("gaugeconfig.options." + (this.inverted() ? "inverted" : "notinverted"), TextFormatting.DARK_AQUA, new Object[0]);
            if (this.comparator_mode()) {
                tr.func_230529_a_((ITextComponent)new StringTextComponent(" | ")).func_230529_a_((ITextComponent)Auxiliaries.localizable("gaugeconfig.options.comparator", TextFormatting.DARK_AQUA, new Object[0]));
            }
            Overlay.show(player, (ITextComponent)tr);
        }

        @Override
        public void write(CompoundNBT nbt, boolean updatePacket) {
            nbt.func_74772_a("scd", this.scd_);
            nbt.func_74768_a("lnkinp", this.switchlink_input_);
        }

        @Override
        public void read(CompoundNBT nbt, boolean updatePacket) {
            this.scd_ = nbt.func_74763_f("scd");
            this.switchlink_input_ = nbt.func_74762_e("lnkinp");
        }

        public void func_73660_a() {
            if (--this.trigger_timer_ > 0L) {
                return;
            }
            this.trigger_timer_ = ModConfig.gauge_update_interval;
            try {
                BlockState state = this.func_195044_w();
                AbstractGaugeBlock block = (AbstractGaugeBlock)state.func_177230_c();
                if (this.field_145850_b.func_201670_d()) {
                    if ((block.config & 0x100L) != 0L && block instanceof IndicatorBlock && ((Boolean)state.func_177229_b((Property)IndicatorBlock.POWERED)).booleanValue() && (block.power_off_sound != null || block.power_on_sound != null)) {
                        boolean alternation;
                        boolean bl = alternation = (System.currentTimeMillis() & 0x400L) < 512L;
                        if (alternation != this.alternation_state_) {
                            this.alternation_state_ = alternation;
                            if (alternation && block.power_on_sound != null) {
                                block.power_on_sound.play(this.field_145850_b, this.field_174879_c);
                            } else if (!alternation && block.power_off_sound != null) {
                                block.power_off_sound.play(this.field_145850_b, this.field_174879_c);
                            }
                        }
                    }
                } else {
                    boolean sync;
                    BlockPos neighbourPos = this.field_174879_c.func_177967_a((Direction)state.func_177229_b((Property)GaugeBlock.FACING), -1);
                    if (!this.field_145850_b.func_175667_e(neighbourPos)) {
                        return;
                    }
                    BlockState neighborState = this.field_145850_b.func_180495_p(neighbourPos);
                    int p = 0;
                    if (this.comparator_mode()) {
                        if (neighborState.func_185912_n()) {
                            p = neighborState.func_185888_a(this.field_145850_b, neighbourPos);
                        }
                    } else if (block instanceof IndicatorBlock && this.field_145850_b.func_175640_z(this.func_174877_v())) {
                        p = 15;
                    } else if (neighborState.func_185897_m()) {
                        p = this.field_145850_b.func_175651_c(neighbourPos, ((Direction)state.func_177229_b((Property)RsDirectedBlock.FACING)).func_176734_d());
                    } else if (neighborState.func_185912_n()) {
                        p = neighborState.func_185888_a(this.field_145850_b, neighbourPos);
                    } else {
                        boolean is_indicator = block instanceof IndicatorBlock;
                        for (Direction nbf : Direction.values()) {
                            if (p >= 15 || is_indicator && p > 0) break;
                            BlockPos nbp = neighbourPos.func_177972_a(nbf);
                            if (!this.field_145850_b.func_175667_e(nbp)) continue;
                            BlockState nbs = this.field_145850_b.func_180495_p(nbp);
                            p = Math.max(p, this.field_145850_b.func_175651_c(nbp, nbf));
                        }
                    }
                    if (this.inverted()) {
                        p = MathHelper.func_76125_a((int)(15 - p), (int)0, (int)15);
                    }
                    boolean bl = sync = this.power() != p;
                    if ((block.config & 0x100L) == 0L) {
                        if (block.power_on_sound != null && this.power() == 0 && p > 0) {
                            block.power_on_sound.play(this.field_145850_b, this.field_174879_c);
                        } else if (block.power_off_sound != null && this.power() > 0 && p == 0) {
                            block.power_off_sound.play(this.field_145850_b, this.field_174879_c);
                        }
                    }
                    p = Math.max(p, this.switchlink_input_);
                    this.power(p);
                    if (block instanceof IndicatorBlock) {
                        boolean powered;
                        boolean bl2 = powered = p != 0;
                        if ((Boolean)state.func_177229_b((Property)IndicatorBlock.POWERED) != powered) {
                            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)IndicatorBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 19);
                        }
                    } else if (block instanceof GaugeBlock && (Integer)state.func_177229_b((Property)GaugeBlock.POWER) != p) {
                        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)GaugeBlock.POWER, (Comparable)Integer.valueOf(p)), 27);
                    }
                }
            }
            catch (Throwable e) {
                this.trigger_timer_ = 100L;
                ModRsGauges.logger().error("TE update() failed: " + e);
            }
        }
    }
}

