/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class ContactSwitchBlock
extends SwitchBlock {
    public ContactSwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config | 0x40000000L, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    @Override
    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return side == null || side == Direction.UP && !this.isWallMount() || side == ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        if ((this.config & 0x400000000000L) != 0L) {
            this.onEntityCollided(world, pos, world.func_180495_p(pos));
        }
        super.func_180658_a(world, pos, entity, distance);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (world.func_201670_d()) {
            return;
        }
        if ((this.config & 0xC00000000000L) == 0xC00000000000L && !entity.func_225608_bj_()) {
            this.onEntityCollided(world, pos, world.func_180495_p(pos));
        }
    }

    @Override
    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (world.func_201670_d()) {
            return;
        }
        if ((this.config & 0x400000000000L) != 0L && (double)entity.field_70143_R < 0.2) {
            return;
        }
        this.onEntityCollided(world, pos, state);
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if ((this.config & 0x400000000000L) != 0L || !this.onEntityCollided((World)world, pos, state)) {
            super.func_225534_a_(state, world, pos, random);
        }
    }

    protected boolean onEntityCollided(World world, BlockPos pos, BlockState state) {
        if (world.func_201670_d()) {
            return false;
        }
        ContactSwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te == null) {
            return false;
        }
        boolean active = false;
        boolean powered = (Boolean)state.func_177229_b((Property)POWERED);
        List hits = world.func_217357_a(te.filter_class(), this.detectionVolume(pos));
        if (hits.size() >= te.entity_count_threshold()) {
            if (te.high_sensitivity()) {
                active = true;
            } else {
                for (Entity e : hits) {
                    if (e.func_145773_az()) continue;
                    active = true;
                    break;
                }
            }
        }
        if (active) {
            int t = te.configured_on_time();
            te.on_timer_reset(t <= 0 ? 20 : (t < 4 ? 4 : t));
        }
        if (active && !powered) {
            state = (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true));
            world.func_180501_a(pos, state, 27);
            this.power_on_sound.play(world, pos);
            this.notifyNeighbours(world, pos, state, te, false);
            if ((this.config & 0x100000000000000L) != 0L && !te.activateSwitchLinks(te.on_power(), true)) {
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
            }
        }
        te.reschedule_block_tick();
        return active;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ContactSwitchTileEntity(ModContent.TET_CONTACT_SWITCH);
    }

    protected AxisAlignedBB detectionVolume(BlockPos pos) {
        return new AxisAlignedBB(Vector3d.func_237491_b_((Vector3i)pos), Vector3d.func_237491_b_((Vector3i)pos).func_72441_c(1.0, 2.0, 1.0));
    }

    @Override
    public ContactSwitchTileEntity getTe(IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof ContactSwitchTileEntity)) {
            return null;
        }
        return (ContactSwitchTileEntity)te;
    }

    public static class ContactSwitchTileEntity
    extends SwitchBlock.SwitchTileEntity {
        public static final Class<?>[] filter_classes = new Class[]{Entity.class, LivingEntity.class, PlayerEntity.class, MonsterEntity.class, AnimalEntity.class, VillagerEntity.class, ItemEntity.class};
        public static final String[] filter_class_names = new String[]{"everything", "creatures", "players", "mobs", "animals", "villagers", "objects"};
        private static final int max_entity_count = 64;
        private boolean high_sensitivity_ = false;
        private int count_threshold_ = 1;
        private int filter_ = 0;

        public ContactSwitchTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public ContactSwitchTileEntity() {
            super(ModContent.TET_CONTACT_SWITCH);
        }

        public int filter() {
            return this.filter_;
        }

        public void filter(int sel) {
            this.filter_ = sel < 0 ? 0 : (sel >= filter_classes.length ? filter_classes.length - 1 : sel);
        }

        public Class<?> filter_class() {
            return this.filter_ <= 0 ? filter_classes[0] : (this.filter_ >= filter_classes.length ? filter_classes[filter_classes.length - 1] : filter_classes[this.filter_]);
        }

        public boolean high_sensitivity() {
            return this.high_sensitivity_;
        }

        public void high_sensitivity(boolean sel) {
            this.high_sensitivity_ = sel;
        }

        public int entity_count_threshold() {
            return this.count_threshold_;
        }

        public void entity_count_threshold(int sel) {
            this.count_threshold_ = sel < 1 ? 1 : (sel >= 64 ? 64 : sel);
        }

        @Override
        public void write(CompoundNBT nbt, boolean updatePacket) {
            super.write(nbt, updatePacket);
            nbt.func_74768_a("filter", this.filter());
            nbt.func_74757_a("highsensitive", this.high_sensitivity());
            nbt.func_74768_a("entitythreshold", this.entity_count_threshold());
        }

        @Override
        public void read(CompoundNBT nbt, boolean updatePacket) {
            super.read(nbt, updatePacket);
            this.filter(nbt.func_74762_e("filter"));
            this.high_sensitivity(nbt.func_74767_n("highsensitive"));
            this.entity_count_threshold(nbt.func_74762_e("entitythreshold"));
        }

        @Override
        public void reset(@Nullable IWorldReader world) {
            super.reset(world);
            this.filter_ = 0;
            this.count_threshold_ = 1;
            this.high_sensitivity_ = false;
            this.configured_on_time(20);
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable PlayerEntity player, double x, double y, boolean show_only) {
            if (state == null) {
                return false;
            }
            SwitchBlock block = (SwitchBlock)state.func_177230_c();
            int direction = 0;
            int field = 0;
            if (block.isLateral()) {
                int n = y >= 13.0 && y <= 15.0 ? 1 : (direction = y >= 10.0 && y <= 12.0 ? -1 : 0);
                int n2 = x >= 9.5 && x <= 10.1 ? 1 : (x >= 10.9 && x <= 11.7 ? 2 : (x >= 12.2 && x <= 13.0 ? 3 : (field = x >= 13.5 && x <= 14.2 ? 4 : 0)));
            }
            if (direction == 0 || field == 0) {
                return false;
            }
            if (!show_only) {
                switch (field) {
                    case 1: {
                        this.high_sensitivity(direction > 0);
                        break;
                    }
                    case 2: {
                        this.entity_count_threshold(this.entity_count_threshold() + direction);
                        break;
                    }
                    case 3: {
                        this.filter(this.filter() + direction);
                        break;
                    }
                    case 4: {
                        this.on_power(MathHelper.func_76125_a((int)(this.on_power() + direction), (int)1, (int)15));
                    }
                }
                this.func_70296_d();
            }
            Overlay.show(player, (ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.touchcontactmat.sensitivity", TextFormatting.BLUE, new Object[]{Auxiliaries.localizable("switchconfig.touchcontactmat.sensitivity." + (this.high_sensitivity() ? "high" : "normal"))})).func_240702_b_(" | ").func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.touchcontactmat.entity_threshold", TextFormatting.YELLOW, new Object[]{this.entity_count_threshold()})).func_240702_b_(" | ").func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.touchcontactmat.entity_filter", TextFormatting.DARK_GREEN, new Object[]{new TranslationTextComponent("rsgauges.switchconfig.touchcontactmat.entity_filter." + filter_class_names[this.filter_])})).func_240702_b_(" | ").func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.touchcontactmat.output_power", TextFormatting.RED, new Object[]{this.on_power()})));
            return true;
        }
    }
}

