/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simpleores;

import javax.annotation.Nonnull;
import mod.alexndr.simplecorelib.config.FlagCondition;
import mod.alexndr.simplecorelib.config.ISimpleConfig;
import mod.alexndr.simpleores.config.ConfigHelper;
import mod.alexndr.simpleores.config.ConfigHolder;
import mod.alexndr.simpleores.config.SimpleOresConfig;
import mod.alexndr.simpleores.generation.OreGeneration;
import mod.alexndr.simpleores.init.ModBlocks;
import mod.alexndr.simpleores.init.ModTabGroups;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="simpleores", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger((String)"simpleores Mod Event Subscriber");

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            OreGeneration.initNetherFeatures();
            OreGeneration.initOverworldFeatures();
        });
        LOGGER.debug("Common setup done");
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ModBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties().func_200916_a(ModTabGroups.MOD_ITEM_GROUP);
            BlockItem blockItem = new BlockItem(block, properties);
            blockItem.setRegistryName(block.getRegistryName());
            registry.register((IForgeRegistryEntry)blockItem);
        });
        LOGGER.debug("Registered BlockItems");
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigHolder.SERVER_SPEC) {
            ConfigHelper.bakeServer(config);
        }
    }

    @SubscribeEvent
    public static void onRegisterRecipeSerializers(@Nonnull RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((IConditionSerializer)new FlagCondition.Serializer((ISimpleConfig)SimpleOresConfig.INSTANCE, new ResourceLocation("simpleores", "flag")));
    }
}

