/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.api.data;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.StorageNetwork;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;

public class DimPos
implements INBTSerializable<NBTTagCompound> {
    public int dimension;
    private BlockPos pos = new BlockPos(0, 0, 0);
    private World world;

    public DimPos() {
    }

    public DimPos(NBTTagCompound tag) {
        this.deserializeNBT(tag);
    }

    public DimPos(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public DimPos(int dimension, BlockPos pos) {
        this.dimension = dimension;
        this.pos = pos;
    }

    public DimPos(World world, BlockPos pos) {
        this.world = world;
        this.dimension = world == null ? 0 : world.field_73011_w.getDimension();
        this.pos = pos;
    }

    @Nullable
    public World getWorld() {
        if (this.world != null) {
            return this.world;
        }
        return DimensionManager.getWorld((int)this.dimension);
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public IBlockState getBlockState() {
        return this.getWorld().func_180495_p(this.getBlockPos());
    }

    @Nullable
    public <V> V getTileEntity(Class<V> tileEntityClassOrInterface) {
        World world = this.getWorld();
        if (world == null || this.getBlockPos() == null) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(this.getBlockPos());
        if (tileEntity == null) {
            return null;
        }
        if (!tileEntityClassOrInterface.isAssignableFrom(tileEntity.getClass())) {
            return null;
        }
        return (V)tileEntity;
    }

    @Nullable
    public <V> V getCapability(Capability<V> capability, EnumFacing side) {
        World world = this.getWorld();
        if (world == null || this.getBlockPos() == null) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(this.getBlockPos());
        if (tileEntity == null) {
            return null;
        }
        if (!tileEntity.hasCapability(capability, side)) {
            return null;
        }
        return (V)tileEntity.getCapability(capability, side);
    }

    public boolean isLoaded() {
        if (this.getWorld() == null) {
            return false;
        }
        return this.getWorld().func_175667_e(this.pos);
    }

    public boolean equals(World world, BlockPos pos) {
        return this.dimension == world.field_73011_w.getDimension() && pos.equals((Object)this.pos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimPos dimPos = (DimPos)o;
        return this.dimension == dimPos.dimension && Objects.equal((Object)this.pos, (Object)dimPos.pos);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dimension, this.pos});
    }

    public String toString() {
        return "[dimension=" + this.dimension + ", pos=" + this.pos + ']';
    }

    public void writeToByteBuf(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    public NBTTagCompound serializeNBT() {
        if (this.pos == null) {
            this.pos = new BlockPos(0, 0, 0);
        }
        NBTTagCompound result = NBTUtil.func_186859_a((BlockPos)this.pos);
        result.func_74768_a("Dim", this.dimension);
        return result;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.pos = NBTUtil.func_186861_c((NBTTagCompound)nbt);
        this.dimension = nbt.func_74762_e("Dim");
    }

    public DimPos offset(EnumFacing direction) {
        if (this.pos == null || direction == null) {
            StorageNetwork.log("Error: null offset in DimPos " + direction);
            return null;
        }
        return new DimPos(this.dimension, this.pos.func_177972_a(direction));
    }

    public Chunk getChunk() {
        return this.getWorld().func_175726_f(this.pos);
    }
}

