/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block;

import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.api.capability.IConnectable;
import mrriegel.storagenetwork.api.data.DimPos;
import mrriegel.storagenetwork.block.BaseBlock;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.capabilities.StorageNetworkCapabilities;
import mrriegel.storagenetwork.util.UtilTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class AbstractBlockConnectable
extends BaseBlock {
    public AbstractBlockConnectable(Material materialIn, String registryName) {
        super(materialIn, registryName);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        try {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile != null && tile.hasCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null)) {
                IConnectable conUnitNeedsMaster = (IConnectable)tile.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null);
                TileEntity tileLoop = null;
                for (BlockPos p : UtilTileEntity.getSides(pos)) {
                    tileLoop = worldIn.func_175625_s(p);
                    if (tileLoop != null && tileLoop.hasCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null)) {
                        IConnectable conUnit = (IConnectable)tileLoop.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null);
                        if (conUnit.getMasterPos() == null) continue;
                        conUnitNeedsMaster.setMasterPos(conUnit.getMasterPos());
                        continue;
                    }
                    if (!(tileLoop instanceof TileMaster)) continue;
                    conUnitNeedsMaster.setMasterPos(new DimPos(worldIn, p));
                }
            }
            this.setConnections(worldIn, pos, state, true);
        }
        catch (Exception e) {
            StorageNetwork.instance.logger.error("StorageNetwork: exception thrown while updating neighbours:", (Throwable)e);
        }
    }

    public void setConnections(World worldIn, BlockPos pos, IBlockState state, boolean refresh) {
        TileEntity myselfTile = worldIn.func_175625_s(pos);
        if (myselfTile == null || !myselfTile.hasCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null)) {
            return;
        }
        IConnectable myselfConnect = (IConnectable)myselfTile.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null);
        if (myselfConnect.getMasterPos() == null) {
            for (BlockPos p : UtilTileEntity.getSides(pos)) {
                if (!(worldIn.func_175625_s(p) instanceof TileMaster)) continue;
                myselfConnect.setMasterPos(new DimPos(worldIn, p));
                break;
            }
        }
        if (worldIn.field_72995_K) {
            return;
        }
        if (myselfConnect.getMasterPos() != null) {
            TileMaster tileMaster;
            block9: {
                tileMaster = StorageNetwork.helpers.getTileMasterForConnectable(myselfConnect);
                myselfConnect.setMasterPos(null);
                worldIn.func_175646_b(myselfTile.func_174877_v(), myselfTile);
                try {
                    this.setAllMastersNull(worldIn, pos, myselfConnect);
                }
                catch (Error e) {
                    e.printStackTrace();
                    if (tileMaster == null) break block9;
                    for (DimPos p : tileMaster.getConnectablePositions()) {
                        TileEntity tileCurrent = p.getTileEntity(TileEntity.class);
                        if (!p.isLoaded() || tileCurrent == null || !tileCurrent.hasCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null)) continue;
                        ((IConnectable)tileCurrent.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null)).setMasterPos(null);
                        p.getWorld().func_175646_b(p.getBlockPos(), tileCurrent);
                    }
                }
            }
            if (refresh && tileMaster != null) {
                tileMaster.refreshNetwork();
            }
        }
        worldIn.func_175646_b(myselfTile.func_174877_v(), myselfTile);
    }

    private void setAllMastersNull(World world, BlockPos pos, IConnectable myself) {
        myself.setMasterPos(null);
        for (BlockPos posBeside : UtilTileEntity.getSides(pos)) {
            IConnectable nbrConn;
            TileEntity nhbr;
            if (!world.func_175726_f(posBeside).func_177410_o() || (nhbr = world.func_175625_s(posBeside)) == null || !nhbr.hasCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null) || (nbrConn = (IConnectable)nhbr.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null)).getMasterPos() == null) continue;
            nbrConn.setMasterPos(null);
            world.func_175646_b(posBeside, world.func_175625_s(posBeside));
            this.setAllMastersNull(world, posBeside, myself);
        }
    }
}

