/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import io.netty.buffer.ByteBuf;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.cable.io.ContainerCableIO;
import mrriegel.storagenetwork.block.cable.link.ContainerCableLink;
import mrriegel.storagenetwork.block.cable.processing.ContainerCableProcessing;
import mrriegel.storagenetwork.block.cable.processing.ProcessRequestModel;
import mrriegel.storagenetwork.block.cable.processing.TileCableProcess;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.network.RefreshFilterClientMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.util.UtilTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CableDataMessage
implements IMessage,
IMessageHandler<CableDataMessage, IMessage> {
    private int id;
    private int value = 0;

    public CableDataMessage() {
    }

    public CableDataMessage(int id) {
        this.id = id;
    }

    public CableDataMessage(int id, int value) {
        this(id);
        this.value = value;
    }

    public IMessage onMessage(final CableDataMessage message, MessageContext ctx) {
        final EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        WorldServer mainThread = (WorldServer)player.field_70170_p;
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                CableMessageType type = CableMessageType.values()[message.id];
                if (player.field_71070_bA instanceof ContainerCableIO) {
                    this.updateCableIO(player, type);
                }
                if (player.field_71070_bA instanceof ContainerCableLink) {
                    this.updateCableLink(player, type);
                }
                if (player.field_71070_bA instanceof ContainerCableProcessing) {
                    this.updateProcessing(message, player, type);
                }
            }

            private void updateProcessing(CableDataMessage message2, EntityPlayerMP player2, CableMessageType type) {
                ContainerCableProcessing con = (ContainerCableProcessing)player2.field_71070_bA;
                if (!(con.tile instanceof TileCableProcess)) {
                    return;
                }
                TileCableProcess tileCable = (TileCableProcess)con.tile;
                switch (type) {
                    case TOGGLE_P_RESTARTTRIGGER: {
                        tileCable.getRequest().setStatus(ProcessRequestModel.ProcessStatus.EXPORTING);
                        break;
                    }
                    case P_FACE_BOTTOM: {
                        tileCable.processingBottom = EnumFacing.values()[message2.value];
                        break;
                    }
                    case P_FACE_TOP: {
                        tileCable.processingTop = EnumFacing.values()[message2.value];
                        break;
                    }
                }
                tileCable.func_70296_d();
                UtilTileEntity.updateTile(tileCable.func_145831_w(), tileCable.func_174877_v());
            }

            private void updateCableLink(EntityPlayerMP player2, CableMessageType type) {
                ContainerCableLink con = (ContainerCableLink)player2.field_71070_bA;
                if (con == null || con.link == null) {
                    return;
                }
                TileMaster master = StorageNetwork.helpers.getTileMasterForConnectable(con.link.connectable);
                switch (type) {
                    case TOGGLE_WAY: {
                        con.link.filterDirection = con.link.filterDirection.next();
                        break;
                    }
                    case TOGGLE_WHITELIST: {
                        con.link.filters.isWhitelist = !con.link.filters.isWhitelist;
                        break;
                    }
                    case PRIORITY_UP: {
                        ++con.link.priority;
                        if (master == null) break;
                        master.clearCache();
                        break;
                    }
                    case PRIORITY_DOWN: {
                        --con.link.priority;
                        if (master == null) break;
                        master.clearCache();
                        break;
                    }
                    case IMPORT_FILTER: {
                        int targetSlot = 0;
                        for (ItemStack filterSuggestion : con.link.getStoredStacks()) {
                            if (con.link.filters.exactStackAlreadyInList(filterSuggestion)) continue;
                            con.link.filters.setStackInSlot(targetSlot, filterSuggestion.func_77946_l());
                            if (++targetSlot < con.link.filters.getSlots()) continue;
                        }
                        PacketRegistry.INSTANCE.sendTo((IMessage)new RefreshFilterClientMessage(con.link.filters.getStacks()), player2);
                        con.tile.func_70296_d();
                        break;
                    }
                }
            }

            private void updateCableIO(EntityPlayerMP player2, CableMessageType type) {
                ContainerCableIO con = (ContainerCableIO)player2.field_71070_bA;
                if (con == null || con.cap == null) {
                    return;
                }
                TileMaster master = StorageNetwork.helpers.getTileMasterForConnectable(con.cap.connectable);
                switch (type) {
                    case TOGGLE_MODE: {
                        con.cap.operationMustBeSmaller = !con.cap.operationMustBeSmaller;
                        break;
                    }
                    case TOGGLE_WHITELIST: {
                        con.cap.filters.isWhitelist = !con.cap.filters.isWhitelist;
                        break;
                    }
                    case PRIORITY_UP: {
                        ++con.cap.priority;
                        if (master == null) break;
                        master.clearCache();
                        break;
                    }
                    case PRIORITY_DOWN: {
                        --con.cap.priority;
                        if (master == null) break;
                        master.clearCache();
                        break;
                    }
                    case IMPORT_FILTER: {
                        int targetSlot = 0;
                        for (ItemStack filterSuggestion : con.cap.getStacksForFilter()) {
                            if (con.cap.filters.exactStackAlreadyInList(filterSuggestion)) continue;
                            con.cap.filters.setStackInSlot(targetSlot, filterSuggestion.func_77946_l());
                            if (++targetSlot < con.cap.filters.getSlots()) continue;
                        }
                        break;
                    }
                }
                StorageNetwork.log("Send new refresh client msg");
                PacketRegistry.INSTANCE.sendTo((IMessage)new RefreshFilterClientMessage(con.cap.filters.getStacks()), player2);
                con.tile.func_70296_d();
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.value = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.value);
    }

    public static enum CableMessageType {
        PRIORITY_DOWN,
        PRIORITY_UP,
        P_ONOFF,
        TOGGLE_WHITELIST,
        TOGGLE_MODE,
        IMPORT_FILTER,
        TOGGLE_WAY,
        P_FACE_TOP,
        P_FACE_BOTTOM,
        TOGGLE_P_RESTARTTRIGGER,
        P_CTRL_MORE,
        P_CTRL_LESS;

    }
}

