/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable;

import com.google.common.collect.Maps;
import com.lothrazar.storagenetwork.block.BaseBlock;
import com.lothrazar.storagenetwork.block.cable.TileCable;
import com.lothrazar.storagenetwork.block.master.TileMaster;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockCable
extends BaseBlock {
    private static final EnumProperty<EnumConnectType> DOWN = EnumProperty.func_177709_a((String)"down", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> UP = EnumProperty.func_177709_a((String)"up", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> NORTH = EnumProperty.func_177709_a((String)"north", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> SOUTH = EnumProperty.func_177709_a((String)"south", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> WEST = EnumProperty.func_177709_a((String)"west", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> EAST = EnumProperty.func_177709_a((String)"east", EnumConnectType.class);
    public static final Map<Direction, EnumProperty<EnumConnectType>> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), p -> {
        p.put(Direction.NORTH, NORTH);
        p.put(Direction.EAST, EAST);
        p.put(Direction.SOUTH, SOUTH);
        p.put(Direction.WEST, WEST);
        p.put(Direction.UP, UP);
        p.put(Direction.DOWN, DOWN);
    });
    private static final double top = 16.0;
    private static final double bot = 0.0;
    private static final double C = 8.0;
    private static final double w = 2.0;
    private static final double sm = 6.0;
    private static final double lg = 10.0;
    private static final VoxelShape AABB = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_UP = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape AABB_DOWN = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_NORTH = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_SOUTH = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape AABB_WEST = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_EAST = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);

    public BlockCable(String registryName) {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(0.2f), registryName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(NORTH, (Comparable)((Object)EnumConnectType.NONE))).func_206870_a(EAST, (Comparable)((Object)EnumConnectType.NONE))).func_206870_a(SOUTH, (Comparable)((Object)EnumConnectType.NONE))).func_206870_a(WEST, (Comparable)((Object)EnumConnectType.NONE))).func_206870_a(UP, (Comparable)((Object)EnumConnectType.NONE))).func_206870_a(DOWN, (Comparable)((Object)EnumConnectType.NONE)));
    }

    public static BlockState cleanBlockState(BlockState state) {
        for (Direction d : Direction.values()) {
            EnumProperty<EnumConnectType> prop = FACING_TO_PROPERTY_MAP.get(d);
            if (state.func_177229_b(prop) != EnumConnectType.INVENTORY) continue;
            state = (BlockState)state.func_206870_a(prop, (Comparable)((Object)EnumConnectType.NONE));
        }
        return state;
    }

    private boolean shapeConnects(BlockState state, EnumProperty<EnumConnectType> dirctionProperty) {
        return ((EnumConnectType)((Object)state.func_177229_b(dirctionProperty))).equals((Object)EnumConnectType.CABLE) || ((EnumConnectType)((Object)state.func_177229_b(dirctionProperty))).equals((Object)EnumConnectType.INVENTORY);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = AABB;
        if (this.shapeConnects(state, UP)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_UP, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (this.shapeConnects(state, DOWN)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_DOWN, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b(WEST))).equals((Object)EnumConnectType.CABLE)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_WEST, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b(EAST))).equals((Object)EnumConnectType.CABLE)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_EAST, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b(NORTH))).equals((Object)EnumConnectType.CABLE)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_NORTH, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b(SOUTH))).equals((Object)EnumConnectType.CABLE)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_SOUTH, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCable();
    }

    public BlockState getExtendedState(BlockState state, IBlockReader world, BlockPos pos) {
        return super.getExtendedState(state, world, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState stateIn, @Nullable LivingEntity placer, ItemStack stack) {
        for (Direction d : Direction.values()) {
            BlockState facingState = worldIn.func_180495_p(pos.func_177972_a(d));
            if (facingState.func_177230_c() != SsnRegistry.inventory && facingState.func_177230_c() != SsnRegistry.master && facingState.func_177230_c() != SsnRegistry.request) continue;
            stateIn = (BlockState)stateIn.func_206870_a((IProperty)FACING_TO_PROPERTY_MAP.get(d), (Comparable)((Object)EnumConnectType.CABLE));
            worldIn.func_175656_a(pos, stateIn);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        EnumProperty<EnumConnectType> property = FACING_TO_PROPERTY_MAP.get(facing);
        if (facingState.func_177230_c() instanceof BlockCable || facingState.func_177230_c() == SsnRegistry.inventory || facingState.func_177230_c() == SsnRegistry.master || facingState.func_177230_c() == SsnRegistry.request) {
            return (BlockState)stateIn.func_206870_a(property, (Comparable)((Object)EnumConnectType.CABLE));
        }
        if (BlockCable.isInventory(stateIn, facing, facingState, world, currentPos, facingPos)) {
            return (BlockState)stateIn.func_206870_a(property, (Comparable)((Object)EnumConnectType.INVENTORY));
        }
        return (BlockState)stateIn.func_206870_a(property, (Comparable)((Object)EnumConnectType.NONE));
    }

    private static boolean isInventory(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing == null) {
            return false;
        }
        if (!TileMaster.isTargetAllowed(facingState)) {
            return false;
        }
        TileEntity neighbor = world.func_175625_s(facingPos);
        return neighbor != null && neighbor.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()).orElse(null) != null;
    }

    public static enum EnumConnectType implements IStringSerializable
    {
        NONE,
        CABLE,
        INVENTORY,
        BLOCKED;


        public boolean isHollow() {
            return this == NONE || this == BLOCKED;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

