/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.inventory;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.IGuiNetwork;
import com.lothrazar.storagenetwork.api.data.EnumSortType;
import com.lothrazar.storagenetwork.block.inventory.ContainerNetworkInventory;
import com.lothrazar.storagenetwork.block.inventory.TileInventory;
import com.lothrazar.storagenetwork.gui.NetworkWidget;
import com.lothrazar.storagenetwork.jei.JeiHooks;
import com.lothrazar.storagenetwork.jei.JeiSettings;
import com.lothrazar.storagenetwork.network.ClearRecipeMessage;
import com.lothrazar.storagenetwork.network.RequestMessage;
import com.lothrazar.storagenetwork.network.SortMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class GuiNetworkInventory
extends ContainerScreen<ContainerNetworkInventory>
implements IGuiNetwork {
    private static final int HEIGHT = 256;
    public static final int WIDTH = 176;
    private final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/inventory.png");
    final NetworkWidget network;
    private TileInventory tile;

    public GuiNetworkInventory(ContainerNetworkInventory container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tile = container.tile;
        this.network = new NetworkWidget(this);
        this.network.setLines(8);
        this.field_146999_f = 176;
        this.field_147000_g = 256;
        this.network.fieldHeight = 180;
    }

    @Override
    public void setStacks(List<ItemStack> stacks) {
        this.network.stacks = stacks;
    }

    public void init() {
        super.init();
        int searchLeft = this.field_147003_i + 81;
        int searchTop = this.field_147009_r + 160;
        int width = 85;
        this.font.getClass();
        this.network.searchBar = new TextFieldWidget(this.font, searchLeft, searchTop, width, 9, "search");
        this.network.searchBar.func_146203_f(30);
        this.network.initSearchbar();
        this.network.initButtons();
        this.addButton((Widget)this.network.directionBtn);
        this.addButton((Widget)this.network.sortBtn);
        if (JeiSettings.isJeiLoaded()) {
            this.addButton((Widget)this.network.jeiBtn);
        }
        this.addButton((Widget)this.network.clearTextBtn);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.network.searchBar.render(mouseX, mouseY, partialTicks);
    }

    @Override
    public void syncDataToServer() {
        PacketRegistry.INSTANCE.sendToServer((Object)new SortMessage(this.getPos(), this.getDownwards(), this.getSort()));
    }

    @Override
    public boolean getDownwards() {
        return this.tile.isDownwards();
    }

    @Override
    public void setDownwards(boolean d) {
        this.tile.setDownwards(d);
    }

    @Override
    public EnumSortType getSort() {
        return this.tile.getSort();
    }

    @Override
    public void setSort(EnumSortType s) {
        this.tile.setSort(s);
    }

    public BlockPos getPos() {
        return this.tile.func_174877_v();
    }

    private static int getDim() {
        return 0;
    }

    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.texture);
        int xCenter = (this.width - this.field_146999_f) / 2;
        int yCenter = (this.height - this.field_147000_g) / 2;
        this.blit(xCenter, yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
        this.network.applySearchTextToSlots();
        this.network.renderItemSlots(mouseX, mouseY, this.font);
    }

    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.network.drawGuiContainerForegroundLayer(mouseX, mouseY);
    }

    boolean isScrollable(double x, double y) {
        int scrollHeight = 135;
        return this.func_195359_a(0, 0, this.width - 8, scrollHeight, x, y);
    }

    public boolean mouseScrolled(double x, double y, double mouseButton) {
        super.mouseScrolled(x, y, mouseButton);
        if (this.isScrollable(x, y) && mouseButton != 0.0) {
            this.network.mouseScrolled(mouseButton);
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.network.mouseClicked(mouseX, mouseY, mouseButton);
        int rectX = 63;
        int rectY = 110;
        if (this.func_195359_a(rectX, rectY, 7, 7, mouseX, mouseY)) {
            PacketRegistry.INSTANCE.sendToServer((Object)new ClearRecipeMessage());
            PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage(0, ItemStack.field_190927_a, false, false));
            return true;
        }
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int b) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode == 256) {
            this.minecraft.field_71439_g.func_71053_j();
            return true;
        }
        if (this.network.searchBar.isFocused()) {
            this.network.searchBar.keyPressed(keyCode, scanCode, b);
            return true;
        }
        if (this.network.stackUnderMouse.func_190926_b()) {
            try {
                JeiHooks.testJeiKeybind(mouseKey, this.network.stackUnderMouse);
            }
            catch (Throwable e) {
                StorageNetwork.log("JEI compat issue " + e);
            }
        }
        if (this.minecraft.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.minecraft.field_71439_g.func_71053_j();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, b);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        return this.network.charTyped(typedChar, keyCode);
    }

    @Override
    public void renderStackToolTip(ItemStack stack, int x, int y) {
        super.renderTooltip(stack, x, y);
    }

    @Override
    public void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.fillGradient(left, top, right, bottom, startColor, endColor);
    }

    @Override
    public boolean isInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.func_195359_a(x, y, width, height, mouseX, mouseY);
    }
}

