/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.gui;

import com.lothrazar.storagenetwork.block.master.TileMaster;
import com.lothrazar.storagenetwork.gui.inventory.InventoryCraftingNetwork;
import com.lothrazar.storagenetwork.network.StackRefreshClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ContainerNetwork
extends Container {
    protected final CraftResultInventory resultInventory = new CraftResultInventory();
    protected PlayerInventory playerInv;
    protected CraftingResultSlot result;
    protected boolean recipeLocked = false;
    protected PlayerEntity player;
    protected World world;
    protected ICraftingRecipe recipeCurrent;
    public InventoryCraftingNetwork matrix;

    public abstract TileMaster getTileMaster();

    public abstract void slotChanged();

    protected ContainerNetwork(@Nullable ContainerType<?> type, int id) {
        super(type, id);
    }

    @Nullable
    public CraftingInventory getCraftMatrix() {
        return this.matrix;
    }

    protected void bindPlayerInvo(PlayerInventory playerInv) {
        this.player = playerInv.field_70458_d;
        this.world = this.player.field_70170_p;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 174 + i * 18));
            }
        }
    }

    public void bindHotbar() {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInv, i, 8 + i * 18, 232));
        }
    }

    protected void bindGrid() {
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.matrix, index++, 8 + j * 18, 110 + i * 18));
            }
        }
    }

    public void func_75134_a(PlayerEntity playerIn) {
        this.slotChanged();
        super.func_75134_a(playerIn);
    }

    public void func_75130_a(IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
        this.recipeCurrent = null;
        this.findMatchingRecipe(this.field_75152_c, this.world, this.player, this.matrix, this.resultInventory);
    }

    protected void findMatchingRecipeClient(World world, CraftingInventory inventory, CraftResultInventory result) {
        Optional optional = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)inventory, world);
        if (optional.isPresent()) {
            ICraftingRecipe icraftingrecipe;
            this.recipeCurrent = icraftingrecipe = (ICraftingRecipe)optional.get();
        }
    }

    private void findMatchingRecipe(int number, World world, PlayerEntity player, CraftingInventory inventory, CraftResultInventory result) {
        if (!world.field_72995_K) {
            ICraftingRecipe icraftingrecipe;
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)inventory, world);
            if (optional.isPresent() && result.func_201561_a(world, serverplayerentity, (IRecipe)(icraftingrecipe = (ICraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.func_77572_b((IInventory)inventory);
                this.recipeCurrent = icraftingrecipe;
            }
            result.func_70299_a(0, itemstack);
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(number, 0, itemstack));
        }
    }

    protected void craftShift(PlayerEntity player, TileMaster tile) {
    }

    public abstract boolean isCrafting();

    public ItemStack func_82846_b(PlayerEntity playerIn, int slotIndex) {
        if (playerIn.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            TileMaster tileMaster = this.getTileMaster();
            if (this.isCrafting() && slotIndex == 0) {
                this.craftShift(playerIn, tileMaster);
                return ItemStack.field_190927_a;
            }
            if (tileMaster != null) {
                int rest = tileMaster.insertStack(itemstack1, false);
                ItemStack stack = rest == 0 ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack1, (int)rest);
                slot.func_75215_d(stack);
                this.func_75142_b();
                List<ItemStack> list = tileMaster.getStacks();
                if (playerIn instanceof ServerPlayerEntity) {
                    ServerPlayerEntity sp = (ServerPlayerEntity)playerIn;
                    PacketRegistry.INSTANCE.sendTo((Object)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), sp.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
                if (stack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                slot.func_190901_a(playerIn, itemstack1);
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }
}

