/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item.remote;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.data.DimPos;
import com.lothrazar.storagenetwork.api.data.EnumSortType;
import com.lothrazar.storagenetwork.block.master.TileMaster;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkRemote;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemRemote
extends Item
implements INamedContainerProvider {
    public ItemRemote(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public static boolean getDownwards(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("down")) {
            return tag.func_74767_n("down");
        }
        return false;
    }

    public static void setDownwards(ItemStack stack, boolean val) {
        stack.func_196082_o().func_74757_a("down", val);
    }

    public static EnumSortType getSort(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("sort")) {
            int sort = tag.func_74762_e("sort");
            return EnumSortType.values()[sort];
        }
        return EnumSortType.NAME;
    }

    public static void setSort(ItemStack stack, EnumSortType val) {
        stack.func_196082_o().func_74768_a("sort", val.ordinal());
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (world.func_175625_s(pos) instanceof TileMaster) {
            ItemStack stack = player.func_184586_b(hand);
            CompoundNBT tag = stack.func_196082_o();
            tag.func_74768_a("x", pos.func_177958_n());
            tag.func_74768_a("y", pos.func_177956_o());
            tag.func_74768_a("z", pos.func_177952_p());
            tag.func_74757_a("bound", true);
            tag.func_74768_a("dim", 0);
            stack.func_77982_d(tag);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t;
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_196082_o();
            int x = tag.func_74762_e("x");
            int y = tag.func_74762_e("y");
            int z = tag.func_74762_e("z");
            int dim = tag.func_74762_e("dim");
            t = new TranslationTextComponent("[ x: " + x + ", y: " + y + ", z: " + z + " ]", new Object[0]);
        } else {
            t = new TranslationTextComponent(this.func_77658_a() + ".tooltip", new Object[0]);
        }
        t.func_211708_a(TextFormatting.GRAY);
        tooltip.add((ITextComponent)t);
    }

    public static DimPos getPosStored(ItemStack itemStackIn) {
        if (!itemStackIn.func_196082_o().func_74767_n("bound")) {
            return null;
        }
        CompoundNBT tag = itemStackIn.func_196082_o();
        int x = tag.func_74762_e("x");
        int y = tag.func_74762_e("y");
        int z = tag.func_74762_e("z");
        int dim = tag.func_74762_e("dim");
        BlockPos posTarget = new BlockPos(x, y, z);
        return new DimPos(dim, posTarget);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStackIn = player.func_184586_b(hand);
        if (world.field_72995_K || hand != Hand.MAIN_HAND) {
            return super.func_77659_a(world, player, hand);
        }
        if (!itemStackIn.func_196082_o().func_74767_n("bound")) {
            StorageNetwork.chatMessage(player, "item.remote.notbound");
            return super.func_77659_a(world, player, hand);
        }
        CompoundNBT tag = itemStackIn.func_196082_o();
        int x = tag.func_74762_e("x");
        int y = tag.func_74762_e("y");
        int z = tag.func_74762_e("z");
        int dim = tag.func_74762_e("dim");
        World serverTargetWorld = world;
        BlockPos posTarget = new BlockPos(x, y, z);
        if (!serverTargetWorld.isAreaLoaded(posTarget, 1)) {
            StorageNetwork.chatMessage(player, "item.remote.notloaded");
            return super.func_77659_a(world, player, hand);
        }
        TileEntity tile = serverTargetWorld.func_175625_s(posTarget);
        if (tile instanceof TileMaster) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ITextComponent func_145748_c_() {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a(), new Object[0]);
        return t;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerNetworkRemote(id, inv);
    }
}

