/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.capability.handler;

import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackHandlerEx;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class MasterItemStackHandler
extends ItemStackHandlerEx {
    private TileMain tileMain;

    public MasterItemStackHandler(TileMain tileMain) {
        this(tileMain, Integer.MAX_VALUE);
    }

    public MasterItemStackHandler(TileMain tileMain, int size) {
        super(size);
        this.tileMain = tileMain;
        this.update();
    }

    public void update() {
        this.stacks.clear();
        int i = 0;
        for (ItemStack stack : this.tileMain.getStacks()) {
            this.stacks.set(i, (Object)stack);
            ++i;
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        int remaining = this.tileMain.insertStack(stack, simulate);
        if (remaining > 0) {
            this.update();
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remaining);
        }
        super.insertItem(slot, stack, simulate);
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        ItemStackMatcher matcher = new ItemStackMatcher(this.getStackInSlot(slot));
        ItemStack stack = this.tileMain.request(matcher, amount, simulate);
        if (stack.func_190926_b()) {
            this.update();
        } else {
            super.extractItem(slot, amount, simulate);
        }
        return stack;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    protected void onLoad() {
        this.update();
    }
}

