/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.util;

import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class UtilInventory {
    public static String formatLargeNumber(int size) {
        if ((double)size < Math.pow(10.0, 3.0)) {
            return size + "";
        }
        if ((double)size < Math.pow(10.0, 6.0)) {
            int rounded = Math.round((float)size / 1000.0f);
            return rounded + "K";
        }
        if ((double)size < Math.pow(10.0, 9.0)) {
            int rounded = Math.round((float)size / (float)Math.pow(10.0, 6.0));
            return rounded + "M";
        }
        if ((double)size < Math.pow(10.0, 12.0)) {
            int rounded = Math.round((float)size / (float)Math.pow(10.0, 9.0));
            return rounded + "B";
        }
        return size + "";
    }

    public static int containsAtLeastHowManyNeeded(IItemHandler inv, ItemStack stack, int minimumCount) {
        int found = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)stack)) continue;
            found += inv.getStackInSlot(i).func_190916_E();
        }
        if (found >= minimumCount) {
            return 0;
        }
        return minimumCount - found;
    }

    public static ItemStack extractItem(IItemHandler inv, ItemStackMatcher fil, int num, boolean simulate) {
        if (inv == null || fil == null) {
            return ItemStack.field_190927_a;
        }
        int extracted = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack ex;
            ItemStack slot = inv.getStackInSlot(i);
            if (!fil.match(slot) || (ex = inv.extractItem(i, 1, simulate)).func_190926_b()) continue;
            if (++extracted == num) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)slot, (int)num);
            }
            --i;
        }
        return ItemStack.field_190927_a;
    }
}

