/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.client.util.RenderUtils;
import tonius.simplyjetpacks.config.ConfigWrapper;
import tonius.simplyjetpacks.config.Defaults;
import tonius.simplyjetpacks.config.Section;
import tonius.simplyjetpacks.item.Fluxpack;
import tonius.simplyjetpacks.item.Jetpack;

public class Config {
    public static final List<Section> configSections = new ArrayList<Section>();
    private static final Section sectionItems = new Section(false, "items");
    private static final Section sectionIntegration = new Section(false, "integration");
    private static final Section sectionTuning = new Section(false, "tuning");
    private static final Section sectionControls = new Section(true, "controls");
    private static final Section sectionAesthetics = new Section(true, "aesthetics");
    private static final Section sectionSounds = new Section(true, "sounds");
    private static final Section sectionGui = new Section(true, "gui");
    private static final Section sectionMisc = new Section(true, "misc");
    public static ConfigWrapper configCommon;
    public static ConfigWrapper configClient;
    public static boolean enableFuelEfficiencyEnchantment;
    public static boolean addRAItemsIfNotInstalled;
    public static boolean enableIntegrationVanilla;
    public static boolean enableIntegrationEIO;
    public static boolean enableIntegrationTE;
    public static boolean enableIntegrationTD;
    public static boolean enableIntegrationRA;
    public static boolean enableIntegrationMek;
    public static boolean enableIntegrationIE;
    public static boolean enableIntegrationRR;
    public static float gelidEnderiumEnergyUsageBonus;
    public static boolean customControls;
    public static String flyKey;
    public static String descendKey;
    public static boolean invertHoverSneakingBehavior;
    public static boolean doubleTapSprintInAir;
    public static boolean enableArmor3DModels;
    public static boolean jetpackSounds;
    public static boolean holdShiftForDetails;
    public static RenderUtils.HUDPositions HUDPosition;
    public static int HUDTextColor;
    public static int HUDOffsetX;
    public static int HUDOffsetY;
    public static double HUDScale;
    public static boolean showHUDWhileChatting;
    public static boolean enableEnergyHUD;
    public static boolean minimalEnergyHUD;
    public static boolean showExactEnergyInHUD;
    public static boolean enableStateHUD;
    public static boolean enableStateMessages;
    public static boolean joinAdvancements;

    public static void preInit(FMLPreInitializationEvent event) {
        configCommon = new ConfigWrapper(new File(event.getModConfigurationDirectory(), "simplyjetpacks/common.cfg"), "1.12.2-2.2.17.0", true);
        configClient = new ConfigWrapper(new File(event.getModConfigurationDirectory(), "simplyjetpacks/client.cfg"), "1.12.2-2.2.17.0", true);
        Config.syncConfig();
        SimplyJetpacks.proxy.updateCustomKeybinds(flyKey, descendKey);
    }

    public static void processConfig() {
        enableFuelEfficiencyEnchantment = configCommon.getBooleanS(Config.sectionItems.category, "enableFuelEfficiencyEnchantment", null, true, true, "Enable the Fuel Efficiency enchantment.");
        addRAItemsIfNotInstalled = configCommon.getBooleanS(Config.sectionItems.category, "addRAItemsIfNotInstalled", null, true, true, "hen enabled, Simply Jetpacks will register some crafting components from Redstone Arsenal to make the Flux-Infused JetPlate craftable if Redstone Arsenal is not installed.");
        enableIntegrationVanilla = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationVanilla", null, true, true, "When enabled, Simply Jetpacks will register its Vanilla Jetpacks.");
        enableIntegrationEIO = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationEIO", null, Defaults.enableIntegrationEIO, true, "When enabled, Simply Jetpacks will register its EnderIO Jetpacks and Fluxpacks.");
        enableIntegrationTE = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationTE", null, Defaults.enableIntegrationTE, true, "When enabled, Simply Jetpacks will register its Thermal Expansion Jetpacks and Fluxpacks.");
        enableIntegrationTD = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationTD", null, Defaults.enableIntegrationTD, true, "When enabled, Simply Jetpacks will register Thermal Dynamics items for thruster recipes.");
        enableIntegrationRA = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationRA", null, Defaults.enableIntegrationRA, true, "When enabled, Simply Jetpacks will register its Redstone Arsenal Tier5 Jetpack recipes.");
        enableIntegrationMek = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationMek", null, Defaults.enableIntegrationMek, true, "When enabled, Simply Jetpacks will register its Mekanism Jetpacks.");
        enableIntegrationIE = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationIE", null, Defaults.enableIntegrationIE, true, "When enabled, Simply Jetpacks will register its Immersive Engineering Jetpacks.");
        enableIntegrationRR = configCommon.getBooleanS(Config.sectionIntegration.category, "enableIntegrationRR", null, Defaults.enableIntegrationRR, true, "When enabled, Simply Jetpacks will register its Redstone Repository Tier5 JetPlate recipes.");
        gelidEnderiumEnergyUsageBonus = configCommon.getIntS(Config.sectionIntegration.category, "gelidEnderiumEnergyUsageBonus", null, 80, 0, 100, true, "When set to a value between 0-100, changes the energy efficiency bonus of the Enderium Armored Jetplate (Example: 80 uses energy at 80% rate).");
        customControls = configClient.getBooleanS(Config.sectionControls.category, "customControls", null, false, false, "When enabled, the key codes specified here will be used for the fly and descend keys. Otherwise, the vanilla jump and sneak keys will be used.");
        flyKey = configClient.getStringS(Config.sectionControls.category, "flyKey", null, "SPACE", false, "The name of the Fly key when Custom Controls are enabled.");
        descendKey = configClient.getStringS(Config.sectionControls.category, "descendKey", null, "LSHIFT", false, "The name of the Descend key when Custom Controls are enabled.");
        invertHoverSneakingBehavior = configClient.getBooleanS(Config.sectionControls.category, "invertHoverSneakingBehavior", null, false, false, "Invert Hover Mode sneaking behavior.");
        doubleTapSprintInAir = configClient.getBooleanS(Config.sectionControls.category, "doubleTapSprintInAir", null, true, false, "When enabled, sprinting by double-tapping the forward key will work while flying with a Jetpack. Can be used as an easier way to activate a Jetpack's boost while airborne (the sprint key also works).");
        enableArmor3DModels = configClient.getBooleanS(Config.sectionAesthetics.category, "enableArmor3DModels", null, true, false, "When enabled, worn Jetpacks and Fluxpacks will have a 3D armor model. Otherwise, flat textures will be used.");
        jetpackSounds = configClient.getBooleanS(Config.sectionSounds.category, "jetpackSounds", null, true, false, "When enabled, jetpacks will make sounds when used.");
        holdShiftForDetails = configClient.getBooleanS(Config.sectionGui.category, "holdShiftForDetails", null, true, false, "When enabled, item details are only shown in the tooltip when holding Shift.");
        HUDPosition = RenderUtils.HUDPositions.valueOf(configClient.getStringListS(Config.sectionGui.category, "hudPosition", null, Defaults.HUDPosition.name(), new String[]{"TOP_LEFT", "TOP_CENTER", "TOP_RIGHT", "LEFT", "RIGHT", "BOTTOM_LEFT", "BOTTOM_RIGHT"}, false, "Change the position of the HUD."));
        HUDOffsetX = configClient.getIntS(Config.sectionGui.category, "HUDOffsetX", null, 0, null, null, false, "The HUD display will be shifted horizontally by this value. This value may be negative.");
        HUDOffsetY = configClient.getIntS(Config.sectionGui.category, "HUDOffsetY", null, 0, null, null, false, "The HUD display will be shifted vertically by this value. This value may be negative.");
        HUDScale = configClient.getDoubleS(Config.sectionGui.category, "HUDScale", null, 1.0, 0.001, null, false, "How large the HUD will be rendered.");
        showHUDWhileChatting = configClient.getBooleanS(Config.sectionGui.category, "showHUDWhileChatting", null, true, false, "When enabled, the HUD will display even when the chat window is opened.");
        enableEnergyHUD = configClient.getBooleanS(Config.sectionGui.category, "enableEnergyHUD", null, true, false, "When enabled, a HUD that displays the energy level of the currently worn Jetpack or Fluxpack will show.");
        minimalEnergyHUD = configClient.getBooleanS(Config.sectionGui.category, "minimalEnergyHUD", null, false, false, "When enabled, only the energy amounts themselves will be rendered on the energy HUD.");
        showExactEnergyInHUD = configClient.getBooleanS(Config.sectionGui.category, "showExactEnergyInHUD", null, false, false, "When enabled, the energy HUD will display the exact amount of RF rather than just a percentage.");
        enableStateHUD = configClient.getBooleanS(Config.sectionGui.category, "enableStateHUD", null, true, false, "When enabled, the HUD that displays the states (engine/hover/charger) of the currently worn Jetpack or Fluxpack will show.");
        enableStateMessages = configClient.getBooleanS(Config.sectionGui.category, "enableStateMessages", null, true, false, "When enabled, switching Jetpacks or Fluxpacks on or off, or changing their modes will display a status message above the inventory bar.");
        HUDTextColor = configClient.getIntS(Config.sectionGui.category, "HUDTextColor", null, 0xEEEEEE, Integer.MIN_VALUE, Integer.MAX_VALUE, false, "Change the text color in the HUD. (Note: Color is in Integer form)");
        joinAdvancements = configClient.getBooleanS(Config.sectionMisc.category, "joinAdvancements", null, true, false, "When enabled, you will get several advancements when joining a world for the first time.");
        Jetpack.loadAllConfigs(configCommon);
        Fluxpack.loadAllConfigs(configCommon);
    }

    private static void syncConfig() {
        SimplyJetpacks.logger.info("Loading Configuration Files...");
        try {
            Config.processConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (configCommon.hasChanged()) {
                configCommon.save();
            }
            if (configClient.hasChanged()) {
                configClient.save();
            }
        }
    }

    public static void onConfigChanged() {
        SimplyJetpacks.logger.info("Simply Jetpacks Config Changed!");
        Config.syncConfig();
        SimplyJetpacks.proxy.updateCustomKeybinds(flyKey, descendKey);
    }

    static {
        enableFuelEfficiencyEnchantment = true;
        addRAItemsIfNotInstalled = true;
        enableIntegrationVanilla = true;
        enableIntegrationEIO = Defaults.enableIntegrationEIO;
        enableIntegrationTE = Defaults.enableIntegrationTE;
        enableIntegrationTD = Defaults.enableIntegrationTD;
        enableIntegrationRA = Defaults.enableIntegrationRA;
        enableIntegrationMek = Defaults.enableIntegrationMek;
        enableIntegrationIE = Defaults.enableIntegrationIE;
        enableIntegrationRR = Defaults.enableIntegrationRR;
        gelidEnderiumEnergyUsageBonus = 80.0f;
        customControls = false;
        flyKey = "SPACE";
        descendKey = "LSHIFT";
        invertHoverSneakingBehavior = false;
        doubleTapSprintInAir = true;
        enableArmor3DModels = true;
        jetpackSounds = true;
        holdShiftForDetails = true;
        HUDPosition = Defaults.HUDPosition;
        HUDTextColor = 0xEEEEEE;
        HUDOffsetX = 0;
        HUDOffsetY = 0;
        HUDScale = 1.0;
        showHUDWhileChatting = true;
        enableEnergyHUD = true;
        minimalEnergyHUD = false;
        showExactEnergyInHUD = false;
        enableStateHUD = true;
        enableStateMessages = true;
        joinAdvancements = true;
    }
}

