/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks;

import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import stormedpanda.simplyjetpacks.CreativeTabSimplyJetpacks;
import stormedpanda.simplyjetpacks.client.ClientJetpackHandler;
import stormedpanda.simplyjetpacks.client.hud.HUDHandler;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;
import stormedpanda.simplyjetpacks.crafting.EnergyTransferHandler;
import stormedpanda.simplyjetpacks.crafting.ModIntegrationCondition;
import stormedpanda.simplyjetpacks.crafting.PlatingReturnHandler;
import stormedpanda.simplyjetpacks.handlers.KeybindHandler;
import stormedpanda.simplyjetpacks.handlers.RegistryHandler;
import stormedpanda.simplyjetpacks.handlers.SyncHandler;
import stormedpanda.simplyjetpacks.integration.IntegrationList;
import stormedpanda.simplyjetpacks.items.JetpackType;
import stormedpanda.simplyjetpacks.network.NetworkHandler;
import stormedpanda.simplyjetpacks.sound.ModSounds;

@Mod(value="simplyjetpacks")
public class SimplyJetpacks {
    public static SimplyJetpacks INSTANCE;
    public static final String MODID = "simplyjetpacks";
    public static final String MODNAME = "Simply Jetpacks 2";
    public static final String VERSION = "${version}";
    public static final Logger LOGGER;
    public static final CreativeTabSimplyJetpacks tabSimplyJetpacks;

    public SimplyJetpacks() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::CommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::ClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new SyncHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlatingReturnHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EnergyTransferHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModSounds());
        MinecraftForge.EVENT_BUS.register(SimplyJetpacksConfig.class);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, SimplyJetpacksConfig.CLIENT_SPEC, "simplyjetpacks-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, SimplyJetpacksConfig.COMMON_SPEC, "simplyjetpacks-common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SimplyJetpacksConfig.SERVER_SPEC, "simplyjetpacks-server.toml");
        CraftingHelper.register((IConditionSerializer)ModIntegrationCondition.Serializer.INSTANCE);
        IntegrationList.init();
        JetpackType.loadAllConfigs();
        RegistryHandler.init();
    }

    private void CommonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup Method registered.");
        NetworkHandler.registerMessages();
    }

    private void ClientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Client Setup Method registered.");
        MinecraftForge.EVENT_BUS.register((Object)new KeybindHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientJetpackHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HUDHandler());
        KeybindHandler.setup();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MODID, (String)"helloworld", () -> {
            LOGGER.info("Hello from Simply Jetpacks 2");
            return "Hello!";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("Server starting...");
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        LOGGER.info("Server stopping...");
        SyncHandler.clear();
    }

    @SubscribeEvent
    public void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        LOGGER.info("Recipe Serializers Registered.");
        CraftingHelper.register((IConditionSerializer)ModIntegrationCondition.Serializer.INSTANCE);
    }

    static {
        LOGGER = LogManager.getLogger();
        tabSimplyJetpacks = new CreativeTabSimplyJetpacks();
    }
}

