/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import stormedpanda.simplyjetpacks.config.ConfigDefaults;
import stormedpanda.simplyjetpacks.integration.IntegrationList;

@Mod.EventBusSubscriber(modid="simplyjetpacks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimplyJetpacksConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        IntegrationList.init();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading event) {
        IntegrationList.init();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Simply Jetpacks 2 - Server Configurations").push("simplyjetpacks-server");
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enableIntegrationVanilla;
        public final ForgeConfigSpec.BooleanValue enableIntegrationImmersiveEngineering;
        public final ForgeConfigSpec.BooleanValue enableIntegrationMekanism;
        public final ForgeConfigSpec.BooleanValue enableIntegrationEnderIO;
        public final ForgeConfigSpec.BooleanValue enableIntegrationThermalExpansion;
        public final ForgeConfigSpec.BooleanValue enableIntegrationThermalDynamics;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Simply Jetpacks 2 - Common Configurations").push("simplyjetpacks-common");
            builder.comment("Integration Configurations").push("integration");
            this.enableIntegrationVanilla = builder.comment("Enable Vanilla Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationVanilla").worldRestart().define("enableIntegrationVanilla", true);
            this.enableIntegrationImmersiveEngineering = builder.comment("Enable Immersive Engineering Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationImmersiveEngineering").worldRestart().define("enableIntegrationImmersiveEngineering", true);
            this.enableIntegrationMekanism = builder.comment("Enable Mekanism Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationMekanism").worldRestart().define("enableIntegrationMekanism", true);
            this.enableIntegrationEnderIO = builder.comment("Enable EnderIO Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationEnderIO").worldRestart().define("enableIntegrationEnderIO", true);
            this.enableIntegrationThermalExpansion = builder.comment("Enable Thermal Expansion Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationThermalExpansion").worldRestart().define("enableIntegrationThermalExpansion", true);
            this.enableIntegrationThermalDynamics = builder.comment("Enable Thermal Dynamics Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationThermalDynamics").worldRestart().define("enableIntegrationThermalDynamics", true);
            builder.pop();
            builder.comment("Jetpack Tuning Configurations").push("tuning");
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue invertHoverSneakingBehavior;
        public final ForgeConfigSpec.BooleanValue enableJetpackSounds;
        public final ForgeConfigSpec.BooleanValue showExactEnergy;
        public final ForgeConfigSpec.BooleanValue enableStateMessages;
        public final ForgeConfigSpec.BooleanValue enableJetpackHud;
        public final ForgeConfigSpec.IntValue hudTextColor;
        public final ForgeConfigSpec.EnumValue<ConfigDefaults.HUDPosition> hudTextPosition;
        public final ForgeConfigSpec.IntValue hudXOffset;
        public final ForgeConfigSpec.IntValue hudYOffset;
        public final ForgeConfigSpec.LongValue hudScale;
        public final ForgeConfigSpec.BooleanValue hudTextShadow;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Simply Jetpacks 2 - Client Configurations").push("simplyjetpacks-client");
            builder.comment("Controls Configurations").push("controls");
            this.invertHoverSneakingBehavior = builder.comment("This sets whether you must hold sneak to hover.").translation("config.simplyjetpacks.invertHoverSneakingBehavior").define("invertHoverSneakingBehavior", false);
            builder.pop();
            builder.comment("Audio Configurations").push("audio");
            this.enableJetpackSounds = builder.comment("This sets whether jetpack sounds will play.").translation("config.simplyjetpacks.enableJetpackSounds").define("enableJetpackSounds", true);
            builder.pop();
            builder.comment("GUI Configurations").push("gui");
            this.showExactEnergy = builder.comment("Show exact Energy of Jetpack in HUD").translation("config.simplyjetpacks.showExactEnergy").define("showExactEnergy", false);
            this.enableStateMessages = builder.comment("This sets whether or not jetpack state messages will show.").translation("config.simplyjetpacks.enableStateMessages").define("enableStateMessages", true);
            this.enableJetpackHud = builder.comment("This sets whether or not the jetpack HUD will be visible.").translation("config.simplyjetpacks.enableJetpackHud").define("enableJetpackHud", true);
            this.hudTextColor = builder.comment("This sets the color of the Jetpack HUD.").translation("config.simplyjetpacks.hudTextColor").defineInRange("hudTextColor", 0xFFFFFF, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudTextPosition = builder.comment("HUD Position").translation("config.simplyjetpacks.hudTextPosition").defineEnum("hudTextPosition", (Enum)ConfigDefaults.hudTextPosition);
            this.hudXOffset = builder.comment("HUD Position X Offset").translation("config.simplyjetpacks.hudXOffset").defineInRange("hudXOffset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudYOffset = builder.comment("HUD Position Y Offset").translation("config.simplyjetpacks.hudYOffset").defineInRange("hudYOffset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudScale = builder.comment("HUD Scale").translation("config.simplyjetpacks.hudScale").defineInRange("hudScale", 1L, 1L, 100L);
            this.hudTextShadow = builder.comment("HUD Text Shadow").translation("config.simplyjetpacks.hudTextShadow").define("hudTextShadow", true);
            builder.pop();
        }
    }
}

