/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.crafting;

import com.google.gson.JsonObject;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ModList;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;

public class ModIntegrationCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("simplyjetpacks", "mod_integration");
    private final String modid;

    public ModIntegrationCondition(String modid) {
        this.modid = modid;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        if (this.modid.equals("vanilla")) {
            return (Boolean)SimplyJetpacksConfig.COMMON.enableIntegrationVanilla.get();
        }
        if (this.modid.equals("immersiveengineering")) {
            return ModList.get().isLoaded(this.modid) && (Boolean)SimplyJetpacksConfig.COMMON.enableIntegrationImmersiveEngineering.get() != false;
        }
        if (this.modid.equals("mekanism")) {
            return ModList.get().isLoaded(this.modid) && (Boolean)SimplyJetpacksConfig.COMMON.enableIntegrationMekanism.get() != false;
        }
        return false;
    }

    public String toString() {
        return "mod_integration(\"" + this.modid + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<ModIntegrationCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ModIntegrationCondition value) {
            json.addProperty("modid", value.modid);
        }

        public ModIntegrationCondition read(JsonObject json) {
            return new ModIntegrationCondition(JSONUtils.func_151200_h((JsonObject)json, (String)"modid"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

