/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import stormedpanda.simplyjetpacks.capability.CapabilityProviderEnergy;
import stormedpanda.simplyjetpacks.capability.EnergyConversionStorage;
import stormedpanda.simplyjetpacks.capability.IEnergyContainerItem;
import stormedpanda.simplyjetpacks.client.hud.IHUDInfoProvider;
import stormedpanda.simplyjetpacks.client.model.JetpackModel;
import stormedpanda.simplyjetpacks.client.particle.JetpackParticleType;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;
import stormedpanda.simplyjetpacks.handlers.RegistryHandler;
import stormedpanda.simplyjetpacks.handlers.SyncHandler;
import stormedpanda.simplyjetpacks.integration.IntegrationList;
import stormedpanda.simplyjetpacks.items.JetpackType;
import stormedpanda.simplyjetpacks.util.KeyboardUtil;
import stormedpanda.simplyjetpacks.util.NBTHelper;
import stormedpanda.simplyjetpacks.util.SJTextUtil;

public class JetpackItem
extends ArmorItem
implements IHUDInfoProvider,
IEnergyContainerItem {
    public static final String TAG_ENERGY = "Energy";
    public static final String TAG_ENGINE = "Engine";
    public static final String TAG_HOVER = "Hover";
    public static final String TAG_E_HOVER = "EmergencyHover";
    public static final String TAG_CHARGER = "Charger";
    public static final String TAG_PARTICLE = "ParticleType";
    private final int capacity;
    private final int maxReceive;
    private final int maxExtract;
    private final JetpackType type;
    public String name;
    private final String armorTexture;
    public final int tier;

    public JetpackItem(JetpackType type) {
        super(type.getArmorMaterial(), EquipmentSlotType.CHEST, type.getProperties());
        this.name = type.getName();
        this.tier = type.getTier();
        this.armorTexture = type.getArmorTexture();
        this.type = type;
        this.capacity = type.getCapacity();
        this.maxReceive = type.getMaxReceive();
        this.maxExtract = type.getMaxExtract();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return this.armorTexture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel _default) {
        return new JetpackModel().applyData(_default);
    }

    public String getBaseName() {
        return this.name;
    }

    public JetpackType getType() {
        return this.type;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isCreative() {
        return this.getBaseName().contains("creative");
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return this.isCreative() || stack.func_77948_v();
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        this.flyUser(player, stack, this);
        if (this.type.canCharge() && this.isChargerOn(stack)) {
            this.chargeInventory(player, stack);
        }
    }

    public int getEnergyUsage(ItemStack stack) {
        int baseUsage = this.type.getEnergyUsage();
        int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)RegistryHandler.FUEL_EFFICIENCY.get()), (ItemStack)stack);
        return level != 0 ? (int)Math.round((double)(baseUsage * (5 - level)) / 5.0) : baseUsage;
    }

    public void useEnergy(ItemStack container, int amount) {
        if (container.func_77978_p() != null || container.func_77978_p().func_74764_b(TAG_ENERGY)) {
            int stored = Math.min(container.func_77978_p().func_74762_e(TAG_ENERGY), this.getMaxEnergyStored(container));
            if ((stored -= amount) < 0) {
                stored = 0;
            }
            container.func_77978_p().func_74768_a(TAG_ENERGY, stored);
        }
    }

    public void setParticleType(ItemStack stack, JetpackParticleType particle) {
        NBTHelper.setInt(stack, TAG_PARTICLE, particle.ordinal());
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new CompoundNBT());
        }
        int stored = Math.min(container.func_77978_p().func_74762_e(TAG_ENERGY), this.getMaxEnergyStored(container));
        int energyReceived = Math.min(this.capacity - stored, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74768_a(TAG_ENERGY, stored += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b(TAG_ENERGY)) {
            return 0;
        }
        int stored = Math.min(container.func_77978_p().func_74762_e(TAG_ENERGY), this.getMaxEnergyStored(container));
        int energyExtracted = Math.min(stored, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.func_77978_p().func_74768_a(TAG_ENERGY, stored -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b(TAG_ENERGY)) {
            return 0;
        }
        return Math.min(container.func_77978_p().func_74762_e(TAG_ENERGY), this.getMaxEnergyStored(container));
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new CapabilityProviderEnergy(new EnergyConversionStorage(this, stack));
    }

    private static float getChargeRatio(ItemStack stack) {
        LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            return (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        if (CapabilityEnergy.ENERGY == null) {
            return;
        }
        SJTextUtil.addBaseInfo(stack, tooltip);
        if (KeyboardUtil.isHoldingShift()) {
            SJTextUtil.addShiftInfo(stack, tooltip);
        } else {
            tooltip.add(SJTextUtil.getShiftText());
        }
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack full;
            if (this.isCreative()) {
                items.add((Object)new ItemStack((IItemProvider)this));
            }
            if (IntegrationList.integrateVanilla && this.getBaseName().contains("vanilla")) {
                items.add((Object)new ItemStack((IItemProvider)this));
                full = new ItemStack((IItemProvider)this);
                full.func_196082_o().func_74768_a(TAG_ENERGY, this.capacity);
                items.add((Object)full);
            }
            if (IntegrationList.integrateImmersiveEngineering && this.getBaseName().contains("ie")) {
                items.add((Object)new ItemStack((IItemProvider)this));
                full = new ItemStack((IItemProvider)this);
                full.func_196082_o().func_74768_a(TAG_ENERGY, this.capacity);
                items.add((Object)full);
            }
            if (IntegrationList.integrateMekanism && this.getBaseName().contains("mek")) {
                items.add((Object)new ItemStack((IItemProvider)this));
                full = new ItemStack((IItemProvider)this);
                full.func_196082_o().func_74768_a(TAG_ENERGY, this.capacity);
                items.add((Object)full);
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isCreative();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - JetpackItem.getChargeRatio(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 261193;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHUDInfo(ItemStack stack, List<ITextComponent> list) {
        SJTextUtil.addHUDInfoText(stack, list);
    }

    public boolean isEngineOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_ENGINE);
    }

    public void toggleEngine(ItemStack stack, PlayerEntity player) {
        boolean current = NBTHelper.getBoolean(stack, TAG_ENGINE);
        NBTHelper.flipBoolean(stack, TAG_ENGINE);
        ITextComponent msg = SJTextUtil.getStateToggle("engineMode", !current);
        player.func_146105_b(msg, true);
    }

    public boolean isHoverOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_HOVER);
    }

    public void toggleHover(ItemStack stack, PlayerEntity player) {
        boolean current = NBTHelper.getBoolean(stack, TAG_HOVER);
        NBTHelper.flipBoolean(stack, TAG_HOVER);
        ITextComponent msg = SJTextUtil.getStateToggle("hoverMode", !current);
        player.func_146105_b(msg, true);
    }

    public boolean isEHoverOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_E_HOVER);
    }

    public void toggleEHover(ItemStack stack, PlayerEntity player) {
        if (this.type.canEHover()) {
            boolean current = NBTHelper.getBoolean(stack, TAG_E_HOVER);
            NBTHelper.flipBoolean(stack, TAG_E_HOVER);
            ITextComponent msg = SJTextUtil.getStateToggle("emergencyHoverMode", !current);
            player.func_146105_b(msg, true);
        }
    }

    private void doEHover(ItemStack stack, PlayerEntity player) {
        NBTHelper.setBoolean(stack, TAG_ENGINE, true);
        NBTHelper.setBoolean(stack, TAG_HOVER, true);
        ITextComponent msg = SJTextUtil.getEmergencyText();
        player.func_146105_b(msg, true);
    }

    public boolean isChargerOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_CHARGER);
    }

    public void toggleCharger(ItemStack stack, PlayerEntity player) {
        if (this.type.canCharge()) {
            boolean current = NBTHelper.getBoolean(stack, TAG_CHARGER);
            NBTHelper.flipBoolean(stack, TAG_CHARGER);
            ITextComponent msg = SJTextUtil.getStateToggle("chargerMode", !current);
            player.func_146105_b(msg, true);
        }
    }

    private void chargeInventory(PlayerEntity player, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K && (this.getEnergyStored(stack) > 0 || this.isCreative())) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                LazyOptional optional;
                ItemStack itemStack = player.field_71071_by.func_70301_a(i);
                if (itemStack.equals(stack) || !itemStack.getCapability(CapabilityEnergy.ENERGY).isPresent() || !(optional = itemStack.getCapability(CapabilityEnergy.ENERGY)).isPresent()) continue;
                IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
                if (this.isCreative()) {
                    energyStorage.receiveEnergy(1000, false);
                    continue;
                }
                this.useEnergy(stack, energyStorage.receiveEnergy(this.getEnergyUsage(stack), false));
            }
        }
    }

    @Nonnull
    public Rarity func_77613_e(@Nonnull ItemStack stack) {
        return this.type.getRarity();
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return true;
    }

    private void fly(PlayerEntity player, double y) {
        Vector3d motion = player.func_213322_ci();
        player.func_213293_j(motion.func_82615_a(), y, motion.func_82616_c());
    }

    private void flyUser(PlayerEntity player, ItemStack stack, JetpackItem item) {
        if (this.isEngineOn(stack)) {
            boolean hoverMode = this.isHoverOn(stack);
            double hoverSpeed = (Boolean)SimplyJetpacksConfig.CLIENT.invertHoverSneakingBehavior.get() == SyncHandler.isHoldingDown(player) ? this.type.getSpeedVerticalHoverSlow() : this.type.getSpeedVerticalHover();
            boolean flyKeyDown = SyncHandler.isHoldingUp(player);
            boolean descendKeyDown = SyncHandler.isHoldingDown(player);
            double currentAccel = this.type.getAccelVertical() * (player.func_213322_ci().func_82617_b() < 0.3 ? 2.5 : 1.0);
            double currentSpeedVertical = this.type.getSpeedVertical() * (player.func_70090_H() ? 0.4 : 1.0);
            double speedVerticalHover = this.type.getSpeedVerticalHover();
            double speedVerticalHoverSlow = this.type.getSpeedVerticalHoverSlow();
            if (flyKeyDown || hoverMode && !player.func_233570_aj_()) {
                if (!this.isCreative()) {
                    int amount = (int)(player.func_70051_ag() ? Math.round((double)this.getEnergyUsage(stack) * this.type.getSprintEnergyModifier()) : (long)this.getEnergyUsage(stack));
                    this.useEnergy(stack, amount);
                }
                if (this.getEnergyStored(stack) > 0 || this.isCreative()) {
                    if (flyKeyDown) {
                        if (!hoverMode) {
                            this.fly(player, Math.min(player.func_213322_ci().func_82617_b() + currentAccel, currentSpeedVertical));
                        } else if (descendKeyDown) {
                            this.fly(player, Math.min(player.func_213322_ci().func_82617_b() + currentAccel, -speedVerticalHoverSlow));
                        } else {
                            this.fly(player, Math.min(player.func_213322_ci().func_82617_b() + currentAccel, speedVerticalHover));
                        }
                    } else {
                        this.fly(player, Math.min(player.func_213322_ci().func_82617_b() + currentAccel, -hoverSpeed));
                    }
                    double baseSpeedSideways = this.type.getSpeedSideways();
                    double baseSpeedForward = this.type.getSprintSpeedModifier();
                    float speedSideways = (float)(player.func_225608_bj_() ? baseSpeedSideways * 0.5 : baseSpeedSideways);
                    float speedForward = (float)(player.func_70051_ag() ? (double)speedSideways * baseSpeedForward : (double)speedSideways);
                    if (SyncHandler.isHoldingForwards(player)) {
                        player.func_213309_a(1.0f, new Vector3d(0.0, 0.0, (double)speedForward));
                    }
                    if (SyncHandler.isHoldingBackwards(player)) {
                        player.func_213309_a(1.0f, new Vector3d(0.0, 0.0, (double)(-speedSideways * 0.8f)));
                    }
                    if (SyncHandler.isHoldingLeft(player)) {
                        player.func_213309_a(1.0f, new Vector3d((double)speedSideways, 0.0, 0.0));
                    }
                    if (SyncHandler.isHoldingRight(player)) {
                        player.func_213309_a(1.0f, new Vector3d((double)(-speedSideways), 0.0, 0.0));
                    }
                    if (!player.field_70170_p.func_201670_d()) {
                        player.field_70143_R = 0.0f;
                        if (player instanceof ServerPlayerEntity) {
                            ((ServerPlayerEntity)player).field_71135_a.field_147365_f = 0;
                        }
                    }
                }
            }
        }
        if (!(player.field_70170_p.field_72995_K || !this.isEHoverOn(stack) || item.getEnergyStored(stack) <= 0 || this.isHoverOn(stack) && this.isEngineOn(stack))) {
            if (player.func_213303_ch().func_82617_b() < -5.0) {
                this.doEHover(stack, player);
            } else if (!player.func_184812_l_() && player.field_70143_R - 1.2f >= player.func_110143_aJ()) {
                for (int j = 0; j <= 16; ++j) {
                    int z;
                    int y;
                    int x = Math.round((float)player.func_213303_ch().func_82615_a() - 0.5f);
                    if (player.field_70170_p.func_175623_d(new BlockPos(x, y = Math.round((float)player.func_213303_ch().func_82617_b()) - j, z = Math.round((float)player.func_213303_ch().func_82616_c() - 0.5f)))) continue;
                    this.doEHover(stack, player);
                    break;
                }
            }
        }
    }
}

