/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.client;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import stormedpanda.simplyjetpacks.client.particle.JetpackParticleType;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;
import stormedpanda.simplyjetpacks.handlers.SyncHandler;
import stormedpanda.simplyjetpacks.items.JetpackItem;
import stormedpanda.simplyjetpacks.sound.JetpackSound;
import stormedpanda.simplyjetpacks.util.Pos3D;

public class ClientJetpackHandler {
    Minecraft minecraft = Minecraft.m_91087_();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.minecraft.f_91074_ != null && this.minecraft.f_91073_ != null && !this.minecraft.m_91104_()) {
            ItemStack chest = this.minecraft.f_91074_.m_6844_(EquipmentSlot.CHEST);
            Item item = chest.m_41720_();
            if (!chest.m_41619_() && item instanceof JetpackItem && !this.minecraft.f_91074_.m_5833_() && ClientJetpackHandler.isFlying((Player)this.minecraft.f_91074_)) {
                JetpackParticleType particleType = this.minecraft.f_91074_.m_20071_() ? JetpackParticleType.BUBBLES : ((JetpackItem)item).getType().getParticleType(chest);
                this.showJetpackParticles((Level)this.minecraft.f_91073_, (Player)this.minecraft.f_91074_, particleType);
                if (((Boolean)SimplyJetpacksConfig.CLIENT.enableJetpackSounds.get()).booleanValue() && !JetpackSound.playing(this.minecraft.f_91074_.m_142049_())) {
                    this.minecraft.m_91106_().m_120367_((SoundInstance)new JetpackSound((Player)this.minecraft.f_91074_));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showJetpackParticles(Level world, Player player, JetpackParticleType particleType) {
        ParticleOptions particle = particleType.getParticleData();
        if (this.minecraft.f_91066_.f_92073_ != ParticleStatus.MINIMAL && particle != null) {
            Random rand = new Random();
            Pos3D playerPos = new Pos3D((Entity)player).translate(0.0, 1.5, 0.0);
            float random = (rand.nextFloat() - 0.5f) * 0.1f;
            Pos3D vLeft = new Pos3D(-0.28, -0.95, -0.35).rotate(player.f_20883_, 0.0f);
            Pos3D vRight = new Pos3D(0.28, -0.95, -0.35).rotate(player.f_20883_, 0.0f);
            Pos3D vCenter = new Pos3D((rand.nextFloat() - 0.5f) * 0.25f, -0.95, -0.38).rotate(player.f_20883_, 0.0f);
            Pos3D v = playerPos.translate((Vec3)vLeft).translate((Vec3)new Pos3D(player.m_20184_()));
            world.m_7106_(particle, v.f_82479_, v.f_82480_, v.f_82481_, (double)random, -0.2, (double)random);
            v = playerPos.translate((Vec3)vRight).translate((Vec3)new Pos3D(player.m_20184_()));
            world.m_7106_(particle, v.f_82479_, v.f_82480_, v.f_82481_, (double)random, -0.2, (double)random);
            v = playerPos.translate((Vec3)vCenter).translate((Vec3)new Pos3D(player.m_20184_()));
            world.m_7106_(particle, v.f_82479_, v.f_82480_, v.f_82481_, (double)random, -0.2, (double)random);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isFlying(Player player) {
        JetpackItem jetpack;
        Item item;
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof JetpackItem && (jetpack = (JetpackItem)item).isEngineOn(stack) && (jetpack.getEnergyStored(stack) > 0 || jetpack.isCreative())) {
            if (jetpack.isHoverOn(stack)) {
                return !player.m_20096_();
            }
            return SyncHandler.isHoldingUp(player);
        }
        return false;
    }
}

