/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import stormedpanda.simplyjetpacks.SimplyJetpacks;
import stormedpanda.simplyjetpacks.handlers.KeybindHandler;
import stormedpanda.simplyjetpacks.items.JetpackItem;
import stormedpanda.simplyjetpacks.network.NetworkHandler;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleCharger;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleEHover;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleEngine;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleHover;

@OnlyIn(value=Dist.CLIENT)
public class JetpackGuiScreen
extends Screen {
    private static final int WIDTH = 176;
    private static final int HEIGHT = 100;
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private final ResourceLocation GUI_BASE = new ResourceLocation("simplyjetpacks", "textures/gui/gui_base.png");
    private final ResourceLocation ENERGY_BAR = new ResourceLocation("simplyjetpacks", "textures/gui/energy_bar.png");
    private static final Component energyStorageTooltip = new TranslatableComponent("tooltips.simplyjetpacks.jetpack_gui.energyStorage");

    public JetpackGuiScreen() {
        super((Component)new TranslatableComponent("screen.simplyjetpacks.jetpack_gui.title"));
        this.f_96543_ = 176;
        this.f_96544_ = 100;
    }

    protected void m_7856_() {
        Item item;
        int relX = (this.f_96543_ - 176) / 2;
        int relY = (this.f_96544_ - 100) / 2;
        this.m_142416_((GuiEventListener)new ImageButton(relX + 120, relY + 16, 20, 20, 176, 0, 20, this.GUI_BASE, button -> NetworkHandler.sendToServer(new PacketToggleEngine())));
        this.m_142416_((GuiEventListener)new ImageButton(relX + 120, relY + 38, 20, 20, 216, 0, 20, this.GUI_BASE, button -> NetworkHandler.sendToServer(new PacketToggleHover())));
        ItemStack stack = JetpackGuiScreen.minecraft.f_91074_.m_6844_(EquipmentSlot.CHEST);
        Item item2 = item = stack.m_41720_();
        if (item2 instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item2;
            if (jetpack.getType().canCharge()) {
                this.m_142416_((GuiEventListener)new ImageButton(relX + 142, relY + 16, 20, 20, 196, 0, 20, this.GUI_BASE, button -> NetworkHandler.sendToServer(new PacketToggleCharger())));
            } else {
                this.m_142416_((GuiEventListener)new ImageButton(relX + 142, relY + 16, 20, 20, 196, 40, 0, this.GUI_BASE, button -> this.buttonClicked("CHARGER NOT AVAILABLE")));
            }
            if (jetpack.getType().canEHover()) {
                this.m_142416_((GuiEventListener)new ImageButton(relX + 142, relY + 38, 20, 20, 236, 0, 20, this.GUI_BASE, button -> NetworkHandler.sendToServer(new PacketToggleEHover())));
            } else {
                this.m_142416_((GuiEventListener)new ImageButton(relX + 142, relY + 38, 20, 20, 236, 40, 0, this.GUI_BASE, button -> this.buttonClicked("E HOVER NOT AVAILABLE")));
            }
        }
    }

    private void buttonClicked(String name) {
        SimplyJetpacks.LOGGER.info(name);
    }

    public void m_6305_(@Nonnull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        Font fontRenderer = JetpackGuiScreen.minecraft.f_91062_;
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI_BASE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int relX = (this.f_96543_ - 176) / 2;
        int relY = (this.f_96544_ - 100) / 2;
        float mousePosX = mouseX;
        float mousePosY = mouseY;
        this.m_93228_(stack, relX, relY, 0, 0, 176, 100);
        JetpackGuiScreen.m_93215_((PoseStack)stack, (Font)fontRenderer, (Component)new TranslatableComponent(JetpackGuiScreen.minecraft.f_91074_.m_6844_(EquipmentSlot.CHEST).m_41778_()), (int)(relX + 88), (int)(relY + 5), (int)0xFFFFFF);
        InventoryScreen.m_98850_((int)(relX + 80), (int)(relY + 90), (int)40, (float)((float)(relX + 51) - mousePosX), (float)((float)(relY + 75 - 50) - mousePosY), (LivingEntity)JetpackGuiScreen.minecraft.f_91074_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.ENERGY_BAR);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        JetpackGuiScreen.m_93133_((PoseStack)stack, (int)(relX + 10), (int)(relY + 16), (float)0.0f, (float)0.0f, (int)14, (int)78, (int)128, (int)128);
        int amount = this.getEnergyBarAmount();
        int barOffset = 78 - amount;
        JetpackGuiScreen.m_93133_((PoseStack)stack, (int)(relX + 10), (int)(relY + 16 + barOffset), (float)14.0f, (float)0.0f, (int)14, (int)amount, (int)128, (int)128);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    private int getEnergyBarAmount() {
        ItemStack stack = JetpackGuiScreen.minecraft.f_91074_.m_6844_(EquipmentSlot.CHEST);
        Item item = stack.m_41720_();
        Item item2 = item;
        if (item2 instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item2;
            if (jetpack.isCreative()) {
                return 78;
            }
            int i = jetpack.getEnergyStored(stack);
            int j = jetpack.getCapacity();
            return (int)(j != 0 && i != 0 ? (long)i * 78L / (long)j : 0L);
        }
        return 0;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (KeybindHandler.JETPACK_GUI_KEY.m_90832_(keyCode, scanCode)) {
            minecraft.m_91152_(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

