/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.handlers;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fmlclient.registry.ClientRegistry;
import stormedpanda.simplyjetpacks.gui.JetpackGuiScreen;
import stormedpanda.simplyjetpacks.handlers.SyncHandler;
import stormedpanda.simplyjetpacks.items.JetpackItem;
import stormedpanda.simplyjetpacks.network.NetworkHandler;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleCharger;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleEHover;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleEngine;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleHover;
import stormedpanda.simplyjetpacks.network.packets.PacketUpdateInput;

public class KeybindHandler {
    private static boolean lastFlyState = false;
    private static boolean lastDescendState = false;
    private static boolean lastForwardState = false;
    private static boolean lastBackwardState = false;
    private static boolean lastLeftState = false;
    private static boolean lastRightState = false;
    public static KeyMapping JETPACK_GUI_KEY;
    public static KeyMapping JETPACK_ENGINE_KEY;
    public static KeyMapping JETPACK_HOVER_KEY;
    public static KeyMapping JETPACK_EHOVER_KEY;
    public static KeyMapping JETPACK_CHARGER_KEY;

    public static void setup() {
        JETPACK_GUI_KEY = new KeyMapping("keybind.simplyjetpacks.jetpack_gui", 75, "keybind.categories.simplyjetpacks");
        ClientRegistry.registerKeyBinding((KeyMapping)JETPACK_GUI_KEY);
        JETPACK_ENGINE_KEY = new KeyMapping("keybind.simplyjetpacks.jetpack_engine", 74, "keybind.categories.simplyjetpacks");
        ClientRegistry.registerKeyBinding((KeyMapping)JETPACK_ENGINE_KEY);
        JETPACK_HOVER_KEY = new KeyMapping("keybind.simplyjetpacks.jetpack_hover", 72, "keybind.categories.simplyjetpacks");
        ClientRegistry.registerKeyBinding((KeyMapping)JETPACK_HOVER_KEY);
        JETPACK_EHOVER_KEY = new KeyMapping("keybind.simplyjetpacks.jetpack_ehover", -1, "keybind.categories.simplyjetpacks");
        ClientRegistry.registerKeyBinding((KeyMapping)JETPACK_EHOVER_KEY);
        JETPACK_CHARGER_KEY = new KeyMapping("keybind.simplyjetpacks.jetpack_charger", -1, "keybind.categories.simplyjetpacks");
        ClientRegistry.registerKeyBinding((KeyMapping)JETPACK_CHARGER_KEY);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
        Item chestItem = null;
        if (!chestStack.m_41619_()) {
            chestItem = chestStack.m_41720_();
        }
        if (chestItem instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)chestItem;
            if (JETPACK_GUI_KEY.m_90857_()) {
                Minecraft.m_91087_().m_91152_((Screen)new JetpackGuiScreen());
            }
            if (JETPACK_ENGINE_KEY.m_90857_()) {
                NetworkHandler.sendToServer(new PacketToggleEngine());
            }
            if (JETPACK_HOVER_KEY.m_90857_()) {
                NetworkHandler.sendToServer(new PacketToggleHover());
            }
            if (JETPACK_EHOVER_KEY.m_90857_()) {
                NetworkHandler.sendToServer(new PacketToggleEHover());
            }
            if (JETPACK_CHARGER_KEY.m_90857_()) {
                NetworkHandler.sendToServer(new PacketToggleCharger());
            }
        }
    }

    private static void tickEnd() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            boolean flyState = mc.f_91074_.f_108618_.f_108572_;
            boolean descendState = mc.f_91074_.f_108618_.f_108573_;
            boolean forwardState = mc.f_91074_.f_108618_.f_108568_;
            boolean backwardState = mc.f_91074_.f_108618_.f_108569_;
            boolean leftState = mc.f_91074_.f_108618_.f_108570_;
            boolean rightState = mc.f_91074_.f_108618_.f_108571_;
            if (flyState != lastFlyState || descendState != lastDescendState || forwardState != lastForwardState || backwardState != lastBackwardState || leftState != lastLeftState || rightState != lastRightState) {
                lastFlyState = flyState;
                lastDescendState = descendState;
                lastForwardState = forwardState;
                lastBackwardState = backwardState;
                lastLeftState = leftState;
                lastRightState = rightState;
                NetworkHandler.sendToServer(new PacketUpdateInput(flyState, descendState, forwardState, backwardState, leftState, rightState));
                SyncHandler.update((Player)mc.f_91074_, flyState, descendState, forwardState, backwardState, leftState, rightState);
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            KeybindHandler.tickEnd();
        }
    }
}

