/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.items;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import stormedpanda.simplyjetpacks.capability.CapabilityProviderEnergy;
import stormedpanda.simplyjetpacks.capability.EnergyConversionStorage;
import stormedpanda.simplyjetpacks.capability.IEnergyContainerItem;
import stormedpanda.simplyjetpacks.client.hud.IHUDInfoProvider;
import stormedpanda.simplyjetpacks.client.model.JetpackModelLayers;
import stormedpanda.simplyjetpacks.client.particle.JetpackParticleType;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;
import stormedpanda.simplyjetpacks.handlers.RegistryHandler;
import stormedpanda.simplyjetpacks.handlers.SyncHandler;
import stormedpanda.simplyjetpacks.integration.IntegrationList;
import stormedpanda.simplyjetpacks.items.JetpackType;
import stormedpanda.simplyjetpacks.util.KeyboardUtil;
import stormedpanda.simplyjetpacks.util.NBTHelper;
import stormedpanda.simplyjetpacks.util.SJTextUtil;

public class JetpackItem
extends ArmorItem
implements IHUDInfoProvider,
IEnergyContainerItem {
    public static final String TAG_ENERGY = "Energy";
    public static final String TAG_ENGINE = "Engine";
    public static final String TAG_HOVER = "Hover";
    public static final String TAG_E_HOVER = "EmergencyHover";
    public static final String TAG_CHARGER = "Charger";
    public static final String TAG_PARTICLE = "ParticleType";
    private final int capacity;
    private final int maxReceive;
    private final int maxExtract;
    private final JetpackType type;
    public String name;
    private final String armorTexture;
    public final int tier;

    public JetpackItem(JetpackType type) {
        super(type.getArmorMaterial(), EquipmentSlot.CHEST, type.getProperties());
        this.name = type.getName();
        this.tier = type.getTier();
        this.armorTexture = type.getArmorTexture();
        this.type = type;
        this.capacity = type.getCapacity();
        this.maxReceive = type.getMaxReceive();
        this.maxExtract = type.getMaxExtract();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(Rendering.INSTANCE);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return this.armorTexture;
    }

    public String getBaseName() {
        return this.name;
    }

    public JetpackType getType() {
        return this.type;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isCreative() {
        return this.getBaseName().contains("creative");
    }

    public boolean m_5812_(@Nonnull ItemStack stack) {
        return this.isCreative() || stack.m_41793_();
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        if (!player.m_5833_()) {
            this.flyUser(player, stack, this);
            if (this.type.canCharge() && this.isChargerOn(stack)) {
                this.chargeInventory(player, stack);
            }
        }
    }

    public int getEnergyUsage(ItemStack stack) {
        int baseUsage = this.type.getEnergyUsage();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)RegistryHandler.FUEL_EFFICIENCY.get()), (ItemStack)stack);
        return level != 0 ? (int)Math.round((double)(baseUsage * (5 - level)) / 5.0) : baseUsage;
    }

    public void useEnergy(ItemStack container, int amount) {
        if (container.m_41783_() != null || container.m_41783_().m_128441_(TAG_ENERGY)) {
            int stored = Math.min(container.m_41783_().m_128451_(TAG_ENERGY), this.getMaxEnergyStored(container));
            if ((stored -= amount) < 0) {
                stored = 0;
            }
            container.m_41783_().m_128405_(TAG_ENERGY, stored);
        }
    }

    public void setParticleType(ItemStack stack, JetpackParticleType particle) {
        NBTHelper.setInt(stack, TAG_PARTICLE, particle.ordinal());
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!container.m_41782_()) {
            container.m_41751_(new CompoundTag());
        }
        int stored = Math.min(container.m_41783_().m_128451_(TAG_ENERGY), this.getMaxEnergyStored(container));
        int energyReceived = Math.min(this.capacity - stored, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.m_41783_().m_128405_(TAG_ENERGY, stored += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_(TAG_ENERGY)) {
            return 0;
        }
        int stored = Math.min(container.m_41783_().m_128451_(TAG_ENERGY), this.getMaxEnergyStored(container));
        int energyExtracted = Math.min(stored, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.m_41783_().m_128405_(TAG_ENERGY, stored -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_(TAG_ENERGY)) {
            return 0;
        }
        return Math.min(container.m_41783_().m_128451_(TAG_ENERGY), this.getMaxEnergyStored(container));
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)container);
        for (Map.Entry entry : enchants.entrySet()) {
            if (!((Enchantment)entry.getKey()).m_44704_().equals("enchantment.cofh_core.holding")) continue;
            return this.capacity + this.capacity * (Integer)entry.getValue() / 2;
        }
        return this.capacity;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new CapabilityProviderEnergy(new EnergyConversionStorage(this, stack));
    }

    private static float getChargeRatio(ItemStack stack) {
        LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            return (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        if (CapabilityEnergy.ENERGY == null) {
            return;
        }
        SJTextUtil.addBaseInfo(stack, tooltip);
        if (KeyboardUtil.isHoldingShift()) {
            SJTextUtil.addShiftInfo(stack, tooltip);
        } else {
            tooltip.add(SJTextUtil.getShiftText());
        }
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            ItemStack full;
            if (this.isCreative()) {
                items.add((Object)new ItemStack((ItemLike)this));
            }
            if (IntegrationList.integrateVanilla && this.getBaseName().contains("vanilla")) {
                items.add((Object)new ItemStack((ItemLike)this));
                full = new ItemStack((ItemLike)this);
                full.m_41784_().m_128405_(TAG_ENERGY, this.capacity);
                items.add((Object)full);
            }
            if (IntegrationList.integrateImmersiveEngineering && this.getBaseName().contains("ie")) {
                items.add((Object)new ItemStack((ItemLike)this));
                full = new ItemStack((ItemLike)this);
                full.m_41784_().m_128405_(TAG_ENERGY, this.capacity);
                items.add((Object)full);
            }
            if (IntegrationList.integrateMekanism && this.getBaseName().contains("mek")) {
                items.add((Object)new ItemStack((ItemLike)this));
                full = new ItemStack((ItemLike)this);
                full.m_41784_().m_128405_(TAG_ENERGY, this.capacity);
                items.add((Object)full);
            }
            if (IntegrationList.integrateThermalExpansion && this.getBaseName().contains("te")) {
                items.add((Object)new ItemStack((ItemLike)this));
                full = new ItemStack((ItemLike)this);
                full.m_41784_().m_128405_(TAG_ENERGY, this.capacity);
                items.add((Object)full);
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isCreative();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - JetpackItem.getChargeRatio(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 261193;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHUDInfo(ItemStack stack, List<Component> list) {
        SJTextUtil.addHUDInfoText(stack, list);
    }

    public boolean isEngineOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_ENGINE);
    }

    public void toggleEngine(ItemStack stack, Player player) {
        boolean current = NBTHelper.getBoolean(stack, TAG_ENGINE);
        NBTHelper.flipBoolean(stack, TAG_ENGINE);
        Component msg = SJTextUtil.getStateToggle("engineMode", !current);
        player.m_5661_(msg, true);
    }

    public boolean isHoverOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_HOVER);
    }

    public void toggleHover(ItemStack stack, Player player) {
        boolean current = NBTHelper.getBoolean(stack, TAG_HOVER);
        NBTHelper.flipBoolean(stack, TAG_HOVER);
        Component msg = SJTextUtil.getStateToggle("hoverMode", !current);
        player.m_5661_(msg, true);
    }

    public boolean isEHoverOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_E_HOVER);
    }

    public void toggleEHover(ItemStack stack, Player player) {
        if (this.type.canEHover()) {
            boolean current = NBTHelper.getBoolean(stack, TAG_E_HOVER);
            NBTHelper.flipBoolean(stack, TAG_E_HOVER);
            Component msg = SJTextUtil.getStateToggle("emergencyHoverMode", !current);
            player.m_5661_(msg, true);
        }
    }

    private void doEHover(ItemStack stack, Player player) {
        NBTHelper.setBoolean(stack, TAG_ENGINE, true);
        NBTHelper.setBoolean(stack, TAG_HOVER, true);
        Component msg = SJTextUtil.getEmergencyText();
        player.m_5661_(msg, true);
    }

    public boolean isChargerOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_CHARGER);
    }

    public void toggleCharger(ItemStack stack, Player player) {
        if (this.type.canCharge()) {
            boolean current = NBTHelper.getBoolean(stack, TAG_CHARGER);
            NBTHelper.flipBoolean(stack, TAG_CHARGER);
            Component msg = SJTextUtil.getStateToggle("chargerMode", !current);
            player.m_5661_(msg, true);
        }
    }

    private void chargeInventory(Player player, ItemStack stack) {
        if (!player.f_19853_.f_46443_ && (this.getEnergyStored(stack) > 0 || this.isCreative())) {
            for (int i = 0; i < player.f_36095_.m_6653_(); ++i) {
                LazyOptional optional;
                ItemStack itemStack = player.f_36095_.m_38853_(i).m_7993_();
                if (itemStack.equals(stack) || !itemStack.getCapability(CapabilityEnergy.ENERGY).isPresent() || !(optional = itemStack.getCapability(CapabilityEnergy.ENERGY)).isPresent()) continue;
                IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
                if (this.isCreative()) {
                    energyStorage.receiveEnergy(1000, false);
                    continue;
                }
                this.useEnergy(stack, energyStorage.receiveEnergy(this.getEnergyUsage(stack), false));
            }
        }
    }

    @Nonnull
    public Rarity m_41460_(@Nonnull ItemStack stack) {
        return this.type.getRarity();
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return true;
    }

    private void fly(Player player, double y) {
        Vec3 motion = player.m_20184_();
        player.m_20334_(motion.m_82507_(Direction.Axis.X), y, motion.m_82507_(Direction.Axis.Z));
    }

    private void flyUser(Player player, ItemStack stack, JetpackItem item) {
        if (this.isEngineOn(stack)) {
            boolean hoverMode = this.isHoverOn(stack);
            double hoverSpeed = (Boolean)SimplyJetpacksConfig.CLIENT.invertHoverSneakingBehavior.get() == SyncHandler.isHoldingDown(player) ? this.type.getSpeedVerticalHoverSlow() : this.type.getSpeedVerticalHover();
            boolean flyKeyDown = SyncHandler.isHoldingUp(player);
            boolean descendKeyDown = SyncHandler.isHoldingDown(player);
            double currentAccel = this.type.getAccelVertical() * (player.m_20184_().m_82507_(Direction.Axis.Y) < 0.3 ? 2.5 : 1.0);
            double currentSpeedVertical = this.type.getSpeedVertical() * (player.m_20069_() ? 0.4 : 1.0);
            double speedVerticalHover = this.type.getSpeedVerticalHover();
            double speedVerticalHoverSlow = this.type.getSpeedVerticalHoverSlow();
            if (flyKeyDown || hoverMode && !player.m_20096_()) {
                if (!this.isCreative()) {
                    int amount = (int)(player.m_20142_() ? Math.round((double)this.getEnergyUsage(stack) * this.type.getSprintEnergyModifier()) : (long)this.getEnergyUsage(stack));
                    this.useEnergy(stack, amount);
                }
                if (this.getEnergyStored(stack) > 0 || this.isCreative()) {
                    if (flyKeyDown) {
                        if (!hoverMode) {
                            this.fly(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + currentAccel, currentSpeedVertical));
                        } else if (descendKeyDown) {
                            this.fly(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + currentAccel, -speedVerticalHoverSlow));
                        } else {
                            this.fly(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + currentAccel, speedVerticalHover));
                        }
                    } else {
                        this.fly(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + currentAccel, -hoverSpeed));
                    }
                    double baseSpeedSideways = this.type.getSpeedSideways();
                    double baseSpeedForward = this.type.getSprintSpeedModifier();
                    float speedSideways = (float)(player.m_6047_() ? baseSpeedSideways * 0.5 : baseSpeedSideways);
                    float speedForward = (float)(player.m_20142_() ? (double)speedSideways * baseSpeedForward : (double)speedSideways);
                    if (SyncHandler.isHoldingForwards(player)) {
                        player.m_19920_(1.0f, new Vec3(0.0, 0.0, (double)speedForward));
                    }
                    if (SyncHandler.isHoldingBackwards(player)) {
                        player.m_19920_(1.0f, new Vec3(0.0, 0.0, (double)(-speedSideways * 0.8f)));
                    }
                    if (SyncHandler.isHoldingLeft(player)) {
                        player.m_19920_(1.0f, new Vec3((double)speedSideways, 0.0, 0.0));
                    }
                    if (SyncHandler.isHoldingRight(player)) {
                        player.m_19920_(1.0f, new Vec3((double)(-speedSideways), 0.0, 0.0));
                    }
                    if (!player.f_19853_.m_5776_()) {
                        player.f_19789_ = 0.0f;
                        if (player instanceof ServerPlayer) {
                            ((ServerPlayer)player).f_8906_.f_9737_ = 0;
                        }
                    }
                }
            }
        }
        if (!(player.f_19853_.m_5776_() || !this.isEHoverOn(stack) || item.getEnergyStored(stack) <= 0 && !this.isCreative() || this.isHoverOn(stack) && this.isEngineOn(stack))) {
            if (player.m_20182_().m_82507_(Direction.Axis.Y) < -5.0) {
                this.doEHover(stack, player);
            } else if (!player.m_7500_() && player.f_19789_ - 1.2f >= player.m_21223_()) {
                for (int j = 0; j <= 16; ++j) {
                    int z;
                    int y;
                    int x = Math.round((float)player.m_20182_().m_82507_(Direction.Axis.X) - 0.5f);
                    if (player.f_19853_.m_8055_(new BlockPos(x, y = Math.round((float)player.m_20182_().m_82507_(Direction.Axis.Y)) - j, z = Math.round((float)player.m_20182_().m_82507_(Direction.Axis.Z) - 0.5f))).m_60795_()) continue;
                    this.doEHover(stack, player);
                    break;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class Rendering
    implements IItemRenderProperties {
        private static final Rendering INSTANCE = new Rendering();

        private Rendering() {
        }

        public <A extends HumanoidModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, A _default) {
            return (A)((Object)JetpackModelLayers.JETPACK_MODEL);
        }
    }
}

