/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.items;

import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import stormedpanda.simplyjetpacks.SimplyJetpacks;
import stormedpanda.simplyjetpacks.client.particle.JetpackParticleType;
import stormedpanda.simplyjetpacks.config.JetpackConfigDefaults;
import stormedpanda.simplyjetpacks.integration.IntegrationList;
import stormedpanda.simplyjetpacks.lists.ArmorMaterialList;
import stormedpanda.simplyjetpacks.util.NBTHelper;

public enum JetpackType {
    CREATIVE("jetpack_creative", 6, "jetpackCreative", JetpackParticleType.RAINBOW),
    CREATIVE_ARMORED("jetpack_creative_armored", 6, "jetpackCreative", JetpackParticleType.RAINBOW, true),
    VANILLA1("jetpack_vanilla1", 1, "jetpack1"),
    VANILLA1_ARMORED("jetpack_vanilla1_armored", 1, "jetpack1", true, 0),
    VANILLA2("jetpack_vanilla2", 2, "jetpack2"),
    VANILLA2_ARMORED("jetpack_vanilla2_armored", 2, "jetpack2", true, 1),
    VANILLA3("jetpack_vanilla3", 3, "jetpack3"),
    VANILLA3_ARMORED("jetpack_vanilla3_armored", 3, "jetpack3", true, 2),
    VANILLA4("jetpack_vanilla4", 4, "jetpack4"),
    VANILLA4_ARMORED("jetpack_vanilla4_armored", 4, "jetpack4", true, 3),
    IE1("jetpack_ie1", 1, "jetpack1"),
    IE1_ARMORED("jetpack_ie1_armored", 1, "jetpack1", true, 4),
    IE2("jetpack_ie2", 2, "jetpack2"),
    IE2_ARMORED("jetpack_ie2_armored", 2, "jetpack2", true, 5),
    IE3("jetpack_ie3", 3, "jetpack3"),
    IE3_ARMORED("jetpack_ie3_armored", 3, "jetpack3", true, 6),
    MEK1("jetpack_mek1", 1, "jetpack1"),
    MEK1_ARMORED("jetpack_mek1_armored", 1, "jetpack1", true, 7),
    MEK2("jetpack_mek2", 2, "jetpack2"),
    MEK2_ARMORED("jetpack_mek2_armored", 2, "jetpack2", true, 8),
    MEK3("jetpack_mek3", 3, "jetpack3"),
    MEK3_ARMORED("jetpack_mek3_armored", 3, "jetpack3", true, 9),
    MEK4("jetpack_mek4", 4, "jetpack4"),
    MEK4_ARMORED("jetpack_mek4_armored", 4, "jetpack4", true, 10),
    TE1("jetpack_te1", 1, "jetpack1"),
    TE1_ARMORED("jetpack_te1_armored", 1, "jetpack1", true, 11),
    TE2("jetpack_te2", 2, "jetpack2"),
    TE2_ARMORED("jetpack_te2_armored", 2, "jetpack2", true, 12),
    TE3("jetpack_te3", 3, "jetpack3"),
    TE3_ARMORED("jetpack_te3_armored", 3, "jetpack3", true, 13),
    TE4("jetpack_te4", 4, "jetpack4"),
    TE4_ARMORED("jetpack_te4_armored", 4, "jetpack4", true, 14),
    TE5("jetpack_te5", 5, "jetpack5", true);

    protected static final EnumSet<JetpackType> JETPACK_ALL;
    public static final EnumSet<JetpackType> JETPACK_SJ;
    public static final EnumSet<JetpackType> JETPACK_VANILLA;
    public static final EnumSet<JetpackType> JETPACK_IE;
    public static final EnumSet<JetpackType> JETPACK_MEK;
    public static final EnumSet<JetpackType> JETPACK_TE;
    private final String name;
    private final int tier;
    private final ResourceLocation armorTexture;
    private boolean isArmored;
    private int platingID;
    private final Item.Properties properties;
    public final JetpackConfigDefaults defaults;
    private int capacity;
    private int maxReceive;
    private int maxExtract;
    private int enchantability;
    public int armorEnergyPerHit;
    public int armorReduction;
    public int energyUsage;
    public double speedVertical;
    public double accelVertical;
    public double speedVerticalHover;
    public double speedVerticalHoverSlow;
    public double speedSideways;
    public double sprintSpeedModifier;
    public double sprintEnergyModifier;
    public boolean emergencyHoverMode;
    public boolean chargerMode;
    public JetpackParticleType particleType;

    private JetpackType(String name, int tier, String defaultConfigKey, JetpackParticleType particleType, boolean isArmored) {
        this(name, tier, defaultConfigKey);
        this.particleType = particleType;
        this.isArmored = isArmored;
    }

    private JetpackType(String name, int tier, String defaultConfigKey, JetpackParticleType particleType) {
        this(name, tier, defaultConfigKey);
        this.particleType = particleType;
    }

    private JetpackType(String name, int tier, String defaultConfigKey, boolean isArmored) {
        this(name, tier, defaultConfigKey);
        this.isArmored = isArmored;
    }

    private JetpackType(String name, int tier, String defaultConfigKey, boolean isArmored, int platingID) {
        this(name, tier, defaultConfigKey);
        this.isArmored = isArmored;
        this.platingID = platingID;
    }

    private JetpackType(String name, int tier, String defaultConfigKey) {
        this.name = name;
        this.tier = tier;
        this.armorTexture = new ResourceLocation("simplyjetpacks:textures/models/armor/" + name + ".png");
        this.isArmored = false;
        this.properties = new Item.Properties().m_41491_((CreativeModeTab)SimplyJetpacks.tabSimplyJetpacks).m_41487_(1);
        this.defaults = JetpackConfigDefaults.get(defaultConfigKey);
        this.particleType = JetpackParticleType.DEFAULT;
    }

    public String getName() {
        return this.name;
    }

    public int getTier() {
        return this.tier;
    }

    public Rarity getRarity() {
        return switch (this.tier) {
            case 2 -> Rarity.UNCOMMON;
            case 3 -> Rarity.RARE;
            case 4 -> Rarity.EPIC;
            default -> Rarity.COMMON;
        };
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public int getEnergyUsage() {
        return this.energyUsage;
    }

    public double getSpeedVertical() {
        return this.speedVertical;
    }

    public double getAccelVertical() {
        return this.accelVertical;
    }

    public double getSpeedVerticalHoverSlow() {
        return this.speedVerticalHoverSlow;
    }

    public double getSpeedVerticalHover() {
        return this.speedVerticalHover;
    }

    public double getSpeedSideways() {
        return this.speedSideways;
    }

    public double getSprintSpeedModifier() {
        return this.sprintSpeedModifier;
    }

    public double getSprintEnergyModifier() {
        return this.sprintEnergyModifier;
    }

    public boolean canEHover() {
        return this.emergencyHoverMode;
    }

    public boolean canCharge() {
        return this.chargerMode;
    }

    public String getArmorTexture() {
        return this.armorTexture.toString();
    }

    public ArmorMaterial getArmorMaterial() {
        ArmorMaterialList armorMaterial = this.isArmored ? ArmorMaterialList.JETPACK_ARMORED : ArmorMaterialList.JETPACK;
        ArmorMaterialList.setStats(armorMaterial, this.isArmored, this.getEnchantability(), this.getArmorReduction());
        return armorMaterial;
    }

    public boolean getIsArmored() {
        return this.isArmored;
    }

    public int getArmorReduction() {
        return this.armorReduction;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public Item.Properties getProperties() {
        return this.properties;
    }

    public int getPlatingID() {
        return this.platingID;
    }

    public JetpackParticleType getParticleType(ItemStack stack) {
        if (stack.m_41783_() != null && NBTHelper.hasKey(stack, "ParticleType")) {
            int particle = NBTHelper.getInt(stack, "ParticleType");
            JetpackParticleType particleType = JetpackParticleType.values()[particle];
            if (particleType != null) {
                return particleType;
            }
        }
        NBTHelper.setInt(stack, "ParticleType", this.particleType.ordinal());
        return this.particleType;
    }

    public static void loadAllConfigs() {
        for (JetpackType jetpackType : JETPACK_SJ) {
            jetpackType.loadJetpackConfigurations();
        }
        if (IntegrationList.integrateVanilla) {
            for (JetpackType jetpackType : JETPACK_VANILLA) {
                jetpackType.loadJetpackConfigurations();
            }
        }
        if (IntegrationList.integrateImmersiveEngineering) {
            for (JetpackType jetpackType : JETPACK_IE) {
                jetpackType.loadJetpackConfigurations();
            }
        }
        if (IntegrationList.integrateMekanism) {
            for (JetpackType jetpackType : JETPACK_MEK) {
                jetpackType.loadJetpackConfigurations();
            }
        }
        if (IntegrationList.integrateThermalExpansion) {
            for (JetpackType jetpackType : JETPACK_TE) {
                jetpackType.loadJetpackConfigurations();
            }
        }
    }

    protected void loadJetpackConfigurations() {
        this.capacity = this.defaults.energyCapacity;
        this.maxReceive = this.defaults.energyPerTickIn;
        this.maxExtract = this.defaults.energyPerTickOut;
        this.enchantability = this.defaults.enchantability;
        this.armorEnergyPerHit = this.defaults.armorEnergyPerHit;
        this.armorReduction = this.defaults.armorReduction;
        this.energyUsage = this.defaults.energyUsage;
        this.speedVertical = this.defaults.speedVertical;
        this.accelVertical = this.defaults.accelVertical;
        this.speedVerticalHover = this.defaults.speedVerticalHover;
        this.speedVerticalHoverSlow = this.defaults.speedVerticalHoverSlow;
        this.speedSideways = this.defaults.speedSideways;
        this.sprintSpeedModifier = this.defaults.sprintSpeedModifier;
        this.sprintEnergyModifier = this.defaults.sprintEnergyModifier;
        this.emergencyHoverMode = this.defaults.emergencyHoverMode;
        this.chargerMode = this.defaults.chargerMode;
    }

    static {
        JETPACK_ALL = EnumSet.allOf(JetpackType.class);
        JETPACK_SJ = EnumSet.range(CREATIVE, CREATIVE_ARMORED);
        JETPACK_VANILLA = EnumSet.range(VANILLA1, VANILLA4_ARMORED);
        JETPACK_IE = EnumSet.range(IE1, IE3_ARMORED);
        JETPACK_MEK = EnumSet.range(MEK1, MEK4_ARMORED);
        JETPACK_TE = EnumSet.range(TE1, TE5);
    }
}

