/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.util;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import stormedpanda.simplyjetpacks.SimplyJetpacks;
import stormedpanda.simplyjetpacks.config.ConfigDefaults;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;

public class HUDRenderHelper {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final Font font = HUDRenderHelper.minecraft.f_91062_;

    public static void drawStringAtPosition(Window window, PoseStack matrix, Component text, int lineOffset) {
        int windowScaleHeight = window.m_85442_();
        int windowScaleWidth = window.m_85441_();
        ConfigDefaults.HUDPosition position = (ConfigDefaults.HUDPosition)((Object)SimplyJetpacksConfig.CLIENT.hudTextPosition.get());
        int color = (Integer)SimplyJetpacksConfig.CLIENT.hudTextColor.get();
        int xOffset = (Integer)SimplyJetpacksConfig.CLIENT.hudXOffset.get();
        int yOffset = (Integer)SimplyJetpacksConfig.CLIENT.hudYOffset.get();
        long hudScale = (Long)SimplyJetpacksConfig.CLIENT.hudScale.get();
        boolean hudTextShadow = (Boolean)SimplyJetpacksConfig.CLIENT.hudTextShadow.get();
        int screenHeight = (int)((long)windowScaleHeight / hudScale);
        int screenWidth = (int)((long)windowScaleWidth / hudScale);
        switch (position) {
            case TOP_LEFT: {
                HUDRenderHelper.drawStringLeft(matrix, text, 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case TOP_CENTER: {
                HUDRenderHelper.drawStringCenter(matrix, text, screenWidth / 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case TOP_RIGHT: {
                HUDRenderHelper.drawStringRight(matrix, text, screenWidth - 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case LEFT: {
                HUDRenderHelper.drawStringLeft(matrix, text, 2 + xOffset, screenHeight / 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case RIGHT: {
                HUDRenderHelper.drawStringRight(matrix, text, screenWidth - 2 + xOffset, screenHeight / 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case BOTTOM_LEFT: {
                HUDRenderHelper.drawStringLeft(matrix, text, 2 + xOffset, screenHeight - 9 + (yOffset -= lineOffset * 9), color, hudTextShadow);
                break;
            }
            case BOTTOM_RIGHT: {
                HUDRenderHelper.drawStringRight(matrix, text, screenWidth - 2 + xOffset, screenHeight - 9 + (yOffset -= lineOffset * 9), color, hudTextShadow);
                break;
            }
            default: {
                SimplyJetpacks.LOGGER.info("Invalid HUD Position passed to renderer.");
            }
        }
    }

    public static void drawStringLeft(PoseStack matrix, Component text, int x, int y, int color, boolean shadow) {
        if (shadow) {
            font.m_92763_(matrix, text, (float)x, (float)y, color);
        } else {
            font.m_92889_(matrix, text, (float)x, (float)y, color);
        }
    }

    public static void drawStringCenter(PoseStack matrix, Component text, int x, int y, int color, boolean shadow) {
        float textWidth = font.m_92852_((FormattedText)text);
        if (shadow) {
            font.m_92763_(matrix, text, (float)x - textWidth / 2.0f, (float)y, color);
        } else {
            font.m_92889_(matrix, text, (float)x - textWidth / 2.0f, (float)y, color);
        }
    }

    public static void drawStringRight(PoseStack matrix, Component text, int x, int y, int color, boolean shadow) {
        float textWidth = font.m_92852_((FormattedText)text);
        if (shadow) {
            font.m_92763_(matrix, text, (float)x - textWidth, (float)y, color);
        } else {
            font.m_92889_(matrix, text, (float)x - textWidth, (float)y, color);
        }
    }
}

