/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.util;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;
import stormedpanda.simplyjetpacks.items.JetpackItem;

public class SJTextUtil {
    private static final Component on = SJTextUtil.translate("misc", "enabled", ChatFormatting.GREEN, new Object[0]);
    private static final Component off = SJTextUtil.translate("misc", "disabled", ChatFormatting.RED, new Object[0]);
    private static final Component notAvailable = SJTextUtil.translate("misc", "notAvailable", ChatFormatting.DARK_GRAY, new Object[0]);
    private static final String ENERGY_FORMAT = "%,d";

    public static Component translate(String prefix, String suffix, ChatFormatting style, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "simplyjetpacks", suffix);
        return new TranslatableComponent(key, params).m_130940_(style);
    }

    public static Component translate(String prefix, String suffix, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "simplyjetpacks", suffix);
        return new TranslatableComponent(key, params);
    }

    public static Component energy(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return SJTextUtil.translate("misc", "energy", s1);
    }

    public static Component energyPerTick(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return SJTextUtil.translate("misc", "energyPerTick", s1);
    }

    public static Component energyWithMax(int amount, int max) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        String s2 = String.format(ENERGY_FORMAT, max);
        return SJTextUtil.translate("misc", "energyWithMax", s1, s2);
    }

    public static Component getShiftText() {
        return SJTextUtil.translate("tooltip", "showDetails", new TextComponent("Shift").m_130940_(ChatFormatting.GOLD));
    }

    public static void addBaseInfo(ItemStack stack, List<Component> list) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        list.add(SJTextUtil.translate("tooltip", "tier", jetpack.tier));
        if (jetpack.isCreative()) {
            list.add(SJTextUtil.translate("tooltip", "infiniteEnergy", new Object[0]));
        } else {
            list.add(SJTextUtil.energyWithMax(jetpack.getEnergyStored(stack), jetpack.getMaxEnergyStored(stack)));
        }
    }

    public static void addShiftInfo(ItemStack stack, List<Component> list) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.engine", ChatFormatting.GOLD, new Object[]{jetpack.isEngineOn(stack) ? on : off}));
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.hover", ChatFormatting.GOLD, new Object[]{jetpack.isHoverOn(stack) ? on : off}));
        if (jetpack.getType().canCharge()) {
            list.add(SJTextUtil.translate("tooltip", "itemJetpack.charger", ChatFormatting.GOLD, new Object[]{jetpack.isChargerOn(stack) ? on : off}));
        }
        if (!jetpack.isCreative()) {
            list.add(SJTextUtil.translate("tooltip", "itemJetpack.energyUsage", ChatFormatting.GOLD, new Object[]{SJTextUtil.energyPerTick(jetpack.getEnergyUsage(stack))}));
        }
        Component particle = SJTextUtil.translate("tooltip", "particle." + jetpack.getType().getParticleType(stack).ordinal(), ChatFormatting.WHITE, new Object[0]);
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.particleType", ChatFormatting.GOLD, new Object[]{particle}));
    }

    public static void addHUDInfoText(ItemStack stack, List<Component> list) {
        list.add(SJTextUtil.getEnergyText(stack));
        list.add(SJTextUtil.getHUDStates(stack));
    }

    public static Component getEnergyText(ItemStack stack) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        if (jetpack.isCreative()) {
            return SJTextUtil.translate("hud", "energyDisplay", SJTextUtil.translate("hud", "infiniteEnergy", ChatFormatting.WHITE, new Object[0]));
        }
        int percent = (int)Math.ceil((double)jetpack.getEnergyStored(stack) / (double)jetpack.getCapacity() * 100.0);
        Component percentageText = SJTextUtil.getColoredPercent(percent);
        Component exactText = SJTextUtil.energy(jetpack.getEnergyStored(stack));
        if (((Boolean)SimplyJetpacksConfig.CLIENT.showExactEnergy.get()).booleanValue()) {
            return SJTextUtil.translate("hud", "energyDisplayExtra", percentageText, exactText);
        }
        return SJTextUtil.translate("hud", "energyDisplay", percentageText);
    }

    public static Component getColoredPercent(int percent) {
        if (percent > 70) {
            return new TextComponent(String.format("%s%%", percent)).m_130940_(ChatFormatting.GREEN);
        }
        if (percent > 40) {
            return new TextComponent(String.format("%s%%", percent)).m_130940_(ChatFormatting.YELLOW);
        }
        if (percent > 10) {
            return new TextComponent(String.format("%s%%", percent)).m_130940_(ChatFormatting.GOLD);
        }
        if (percent > 0) {
            return new TextComponent(String.format("%s%%", percent)).m_130940_(ChatFormatting.RED);
        }
        return SJTextUtil.translate("hud", "energyDepleted", ChatFormatting.RED, new Object[0]);
    }

    public static Component getHUDStates(ItemStack stack) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        ChatFormatting on = ChatFormatting.GREEN;
        ChatFormatting off = ChatFormatting.RED;
        ChatFormatting notAvailable = ChatFormatting.DARK_GRAY;
        Component engineState = SJTextUtil.translate("hud", "engine", jetpack.isEngineOn(stack) ? on : off, new Object[0]);
        Component hoverState = SJTextUtil.translate("hud", "hover", jetpack.isHoverOn(stack) ? on : off, new Object[0]);
        Component eHoverState = SJTextUtil.translate("hud", "eHover", jetpack.getType().canEHover() ? (jetpack.isEHoverOn(stack) ? on : off) : notAvailable, new Object[0]);
        Component chargerState = SJTextUtil.translate("hud", "charger", jetpack.getType().canCharge() ? (jetpack.isChargerOn(stack) ? on : off) : notAvailable, new Object[0]);
        return SJTextUtil.translate("hud", "jetpackStates", engineState, hoverState, eHoverState, chargerState);
    }

    public static Component getStateToggle(String state, boolean value) {
        return SJTextUtil.translate("chat", "itemJetpack." + state, value ? on : off);
    }

    public static Component getEmergencyText() {
        return SJTextUtil.translate("chat", "itemJetpack.emergencyHoverModeActivated", ChatFormatting.RED, new Object[0]);
    }
}

