/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.client;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import stormedpanda.simplyjetpacks.client.particle.JetpackParticleType;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;
import stormedpanda.simplyjetpacks.handlers.SyncHandler;
import stormedpanda.simplyjetpacks.items.JetpackItem;
import stormedpanda.simplyjetpacks.sound.JetpackSound;
import stormedpanda.simplyjetpacks.util.Pos3D;

public class ClientJetpackHandler {
    Minecraft minecraft = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.minecraft.field_71439_g != null && this.minecraft.field_71441_e != null && !this.minecraft.func_147113_T()) {
            ItemStack chest = this.minecraft.field_71439_g.func_184582_a(EquipmentSlotType.CHEST);
            Item item = chest.func_77973_b();
            if (!chest.func_190926_b() && item instanceof JetpackItem && !this.minecraft.field_71439_g.func_175149_v() && ClientJetpackHandler.isFlying((PlayerEntity)this.minecraft.field_71439_g)) {
                JetpackParticleType particleType = this.minecraft.field_71439_g.func_203005_aq() ? JetpackParticleType.BUBBLES : ((JetpackItem)item).getType().getParticleType(chest);
                this.showJetpackParticles((World)this.minecraft.field_71441_e, (PlayerEntity)this.minecraft.field_71439_g, particleType);
                if (((Boolean)SimplyJetpacksConfig.CLIENT.enableJetpackSounds.get()).booleanValue() && !JetpackSound.playing(this.minecraft.field_71439_g.func_145782_y())) {
                    this.minecraft.func_147118_V().func_147682_a((ISound)new JetpackSound((PlayerEntity)this.minecraft.field_71439_g));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showJetpackParticles(World world, PlayerEntity player, JetpackParticleType particleType) {
        IParticleData particle = particleType.getParticleData();
        if (this.minecraft.field_71474_y.field_74362_aa != ParticleStatus.MINIMAL && particle != null) {
            Random rand = new Random();
            Pos3D playerPos = new Pos3D((Entity)player).translate(0.0, 1.5, 0.0);
            float random = (rand.nextFloat() - 0.5f) * 0.1f;
            Pos3D vLeft = new Pos3D(-0.28, -0.95, -0.35).rotatePitch(0.0f).rotateYaw(player.field_70761_aq);
            Pos3D vRight = new Pos3D(0.28, -0.95, -0.35).rotatePitch(0.0f).rotateYaw(player.field_70761_aq);
            Pos3D vCenter = new Pos3D((rand.nextFloat() - 0.5f) * 0.25f, -0.95, -0.38).rotatePitch(0.0f).rotateYaw(player.field_70761_aq);
            Pos3D v = playerPos.translate((Vector3d)vLeft).translate((Vector3d)new Pos3D(player.func_213322_ci()));
            world.func_195594_a(particle, v.field_72450_a, v.field_72448_b, v.field_72449_c, (double)random, -0.2, (double)random);
            v = playerPos.translate((Vector3d)vRight).translate((Vector3d)new Pos3D(player.func_213322_ci()));
            world.func_195594_a(particle, v.field_72450_a, v.field_72448_b, v.field_72449_c, (double)random, -0.2, (double)random);
            v = playerPos.translate((Vector3d)vCenter).translate((Vector3d)new Pos3D(player.func_213322_ci()));
            world.func_195594_a(particle, v.field_72450_a, v.field_72448_b, v.field_72449_c, (double)random, -0.2, (double)random);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isFlying(PlayerEntity player) {
        JetpackItem jetpack;
        Item item;
        ItemStack stack = player.func_184582_a(EquipmentSlotType.CHEST);
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof JetpackItem && (jetpack = (JetpackItem)item).isEngineOn(stack) && (jetpack.getEnergyStored(stack) > 0 || player.func_184812_l_() || jetpack.isCreative())) {
            if (jetpack.isHoverOn(stack)) {
                return !player.func_233570_aj_();
            }
            return SyncHandler.isHoldingUp(player);
        }
        return false;
    }
}

