/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import stormedpanda.simplyjetpacks.SimplyJetpacks;
import stormedpanda.simplyjetpacks.handlers.KeybindHandler;
import stormedpanda.simplyjetpacks.items.JetpackItem;
import stormedpanda.simplyjetpacks.network.NetworkHandler;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleCharger;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleEHover;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleEngine;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleHover;

@OnlyIn(value=Dist.CLIENT)
public class JetpackGuiScreen
extends Screen {
    private static final int WIDTH = 176;
    private static final int HEIGHT = 100;
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private final ResourceLocation GUI_BASE = new ResourceLocation("simplyjetpacks", "textures/gui/gui_base.png");
    private final ResourceLocation ENERGY_BAR = new ResourceLocation("simplyjetpacks", "textures/gui/energy_bar.png");
    private static final ITextComponent energyStorageTooltip = new TranslationTextComponent("tooltips.simplyjetpacks.jetpack_gui.energyStorage");

    public JetpackGuiScreen() {
        super((ITextComponent)new TranslationTextComponent("screen.simplyjetpacks.jetpack_gui.title"));
        this.field_230708_k_ = 176;
        this.field_230709_l_ = 100;
    }

    protected void func_231160_c_() {
        int relX = (this.field_230708_k_ - 176) / 2;
        int relY = (this.field_230709_l_ - 100) / 2;
        this.func_230480_a_((Widget)new ImageButton(relX + 120, relY + 16, 20, 20, 176, 0, 20, this.GUI_BASE, button -> NetworkHandler.sendToServer(new PacketToggleEngine())));
        this.func_230480_a_((Widget)new ImageButton(relX + 120, relY + 38, 20, 20, 216, 0, 20, this.GUI_BASE, button -> NetworkHandler.sendToServer(new PacketToggleHover())));
        ItemStack stack = JetpackGuiScreen.minecraft.field_71439_g.func_184582_a(EquipmentSlotType.CHEST);
        Item item = stack.func_77973_b();
        if (item instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item;
            if (jetpack.getType().canCharge()) {
                this.func_230480_a_((Widget)new ImageButton(relX + 142, relY + 16, 20, 20, 196, 0, 20, this.GUI_BASE, button -> NetworkHandler.sendToServer(new PacketToggleCharger())));
            } else {
                this.func_230480_a_((Widget)new ImageButton(relX + 142, relY + 16, 20, 20, 196, 40, 0, this.GUI_BASE, button -> this.buttonClicked("CHARGER NOT AVAILABLE")));
            }
            if (jetpack.getType().canEHover()) {
                this.func_230480_a_((Widget)new ImageButton(relX + 142, relY + 38, 20, 20, 236, 0, 20, this.GUI_BASE, button -> NetworkHandler.sendToServer(new PacketToggleEHover())));
            } else {
                this.func_230480_a_((Widget)new ImageButton(relX + 142, relY + 38, 20, 20, 236, 40, 0, this.GUI_BASE, button -> this.buttonClicked("E HOVER NOT AVAILABLE")));
            }
        }
    }

    private void buttonClicked(String name) {
        SimplyJetpacks.LOGGER.info(name);
    }

    public void func_230430_a_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        FontRenderer fontRenderer = JetpackGuiScreen.minecraft.field_71466_p;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int relX = (this.field_230708_k_ - 176) / 2;
        int relY = (this.field_230709_l_ - 100) / 2;
        float mousePosX = mouseX;
        float mousePosY = mouseY;
        minecraft.func_110434_K().func_110577_a(this.GUI_BASE);
        this.func_238474_b_(stack, relX, relY, 0, 0, 176, 100);
        JetpackGuiScreen.func_238472_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (ITextComponent)new TranslationTextComponent(JetpackGuiScreen.minecraft.field_71439_g.func_184582_a(EquipmentSlotType.CHEST).func_77977_a()), (int)(relX + 88), (int)(relY + 5), (int)0xFFFFFF);
        InventoryScreen.func_228187_a_((int)(relX + 80), (int)(relY + 90), (int)40, (float)((float)(relX + 51) - mousePosX), (float)((float)(relY + 75 - 50) - mousePosY), (LivingEntity)JetpackGuiScreen.minecraft.field_71439_g);
        minecraft.func_110434_K().func_110577_a(this.ENERGY_BAR);
        JetpackGuiScreen.func_238463_a_((MatrixStack)stack, (int)(relX + 10), (int)(relY + 16), (float)0.0f, (float)0.0f, (int)14, (int)78, (int)128, (int)128);
        int amount = this.getEnergyBarAmount();
        int barOffset = 78 - amount;
        JetpackGuiScreen.func_238463_a_((MatrixStack)stack, (int)(relX + 10), (int)(relY + 16 + barOffset), (float)14.0f, (float)0.0f, (int)14, (int)amount, (int)128, (int)128);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    private int getEnergyBarAmount() {
        ItemStack stack = JetpackGuiScreen.minecraft.field_71439_g.func_184582_a(EquipmentSlotType.CHEST);
        Item item = stack.func_77973_b();
        if (item instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item;
            if (jetpack.isCreative()) {
                return 78;
            }
            int i = jetpack.getEnergyStored(stack);
            int j = jetpack.getCapacity();
            return (int)(j != 0 && i != 0 ? (long)i * 78L / (long)j : 0L);
        }
        return 0;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (KeybindHandler.JETPACK_GUI_KEY.func_197976_a(keyCode, scanCode)) {
            minecraft.func_147108_a(null);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }
}

