/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.sleeping_bags.corelib.energy;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyUtils {
    public static int pushEnergy(IEnergyStorage provider, IEnergyStorage receiver, int maxAmount) {
        int energySim = provider.extractEnergy(maxAmount, true);
        int receivedSim = receiver.receiveEnergy(energySim, true);
        int energy = provider.extractEnergy(receivedSim, false);
        receiver.receiveEnergy(energy, false);
        return energy;
    }

    @Nullable
    public static IEnergyStorage getEnergyStorage(IWorldReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        return (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d()).orElse(null);
    }

    @Nullable
    public static IEnergyStorage getEnergyStorageOffset(IWorldReader world, BlockPos pos, Direction side) {
        return EnergyUtils.getEnergyStorage(world, pos.func_177972_a(side), side.func_176734_d());
    }
}

