/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.sleepingbags.items;

import com.mojang.datafixers.util.Either;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BedBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ItemSleepingBag
extends Item {
    public ItemSleepingBag(DyeColor dyeColor) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
        this.setRegistryName(new ResourceLocation("sleeping_bags", dyeColor.func_176762_d() + "_sleeping_bag"));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K) {
            return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
        }
        if (!BedBlock.func_235330_a_((World)worldIn)) {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("message.sleeping_bags.cant_sleep_here"), true);
            return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
        }
        if (!playerIn.func_233570_aj_()) {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("message.sleeping_bags.cant_sleep_in_air"), true);
            return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
        }
        this.trySleep((ServerPlayerEntity)playerIn).ifLeft(sleepResult -> {
            if (sleepResult != null && sleepResult.func_221259_a() != null) {
                playerIn.func_146105_b(sleepResult.func_221259_a(), true);
            }
        });
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }

    public Either<PlayerEntity.SleepResult, Unit> trySleep(ServerPlayerEntity player) {
        Vector3d vector3d;
        List list;
        PlayerEntity.SleepResult ret = ForgeEventFactory.onPlayerSleepInBed((PlayerEntity)player, Optional.empty());
        if (ret != null) {
            return Either.left((Object)ret);
        }
        if (player.func_70608_bn() || !player.func_70089_S()) {
            return Either.left((Object)PlayerEntity.SleepResult.OTHER_PROBLEM);
        }
        if (!player.field_70170_p.func_230315_m_().func_236043_f_()) {
            return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_HERE);
        }
        if (player.field_70170_p.func_72935_r()) {
            return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
        }
        if (!ForgeEventFactory.fireSleepingTimeCheck((PlayerEntity)player, Optional.empty())) {
            return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
        }
        if (!player.func_184812_l_() && !(list = player.field_70170_p.func_175647_a(MonsterEntity.class, new AxisAlignedBB((vector3d = player.func_213303_ch()).func_82615_a() - 8.0, vector3d.func_82617_b() - 5.0, vector3d.func_82616_c() - 8.0, vector3d.func_82615_a() + 8.0, vector3d.func_82617_b() + 5.0, vector3d.func_82616_c() + 8.0), entity -> entity.func_230292_f_((PlayerEntity)player))).isEmpty()) {
            return Either.left((Object)PlayerEntity.SleepResult.NOT_SAFE);
        }
        player.func_175145_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n));
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        try {
            Method setPose = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"func_213301_b", (Class[])new Class[]{Pose.class});
            setPose.invoke((Object)player, Pose.SLEEPING);
        }
        catch (Exception exception) {
            // empty catch block
        }
        player.func_213369_d(player.func_233580_cy_());
        player.func_213317_d(Vector3d.field_186680_a);
        player.field_70160_al = true;
        try {
            ObfuscationReflectionHelper.setPrivateValue(PlayerEntity.class, (Object)player, (Object)0, (String)"field_71076_b");
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException unableToFindFieldException) {
            // empty catch block
        }
        if (player.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)player.field_70170_p).func_72854_c();
        }
        player.func_195066_a(Stats.field_188064_ad);
        CriteriaTriggers.field_192136_p.func_192215_a(player);
        ((ServerWorld)player.field_70170_p).func_72854_c();
        return Either.right((Object)Unit.INSTANCE);
    }
}

