/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StairsBlock;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootPoolEntryType;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.Name;
import snownee.kiwi.NoItem;
import snownee.kiwi.Skip;
import snownee.kiwi.client.model.TextureModel;
import snownee.kiwi.crafting.FullBlockIngredient;
import snownee.kiwi.item.ModBlockItem;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.Util;
import snownee.snow.SnowClientConfig;
import snownee.snow.block.ISnowVariant;
import snownee.snow.block.ModSnowBlock;
import snownee.snow.block.ModSnowTileBlock;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowFenceGateBlock;
import snownee.snow.block.SnowSlabBlock;
import snownee.snow.block.SnowStairsBlock;
import snownee.snow.block.SnowTextureTile;
import snownee.snow.block.SnowTile;
import snownee.snow.block.SnowWallBlock;
import snownee.snow.client.FallingSnowRenderer;
import snownee.snow.client.SnowRenderer;
import snownee.snow.entity.FallingSnowEntity;
import snownee.snow.item.SnowBlockItem;
import snownee.snow.loot.NormalLootEntry;

@KiwiModule(modid="snowrealmagic")
@KiwiModule.Subscriber(value=KiwiModule.Subscriber.Bus.MOD)
@KiwiModule.Group
public class MainModule
extends AbstractModule {
    public static final ItemGroup GROUP = new ItemGroup("snowrealmagic"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Items.field_151126_ay);
        }
    };
    public static final ITag.INamedTag<Block> BOTTOM_SNOW = MainModule.blockTag((String)"snowrealmagic", (String)"bottom_snow");
    public static final ITag.INamedTag<Block> INVALID_SUPPORTERS = MainModule.blockTag((String)"snowrealmagic", (String)"invalid_supporters");
    public static final ITag.INamedTag<Block> CONTAINABLES = MainModule.blockTag((String)"snowrealmagic", (String)"containables");
    public static final ITag.INamedTag<Block> NOT_CONTAINABLES = MainModule.blockTag((String)"snowrealmagic", (String)"not_containables");
    @NoItem
    @Name(value="minecraft:snow")
    public static final ModSnowBlock BLOCK = new ModSnowBlock(MainModule.blockProp((AbstractBlock)Blocks.field_150433_aE));
    @NoItem
    @Name(value="snow")
    public static final ModSnowTileBlock TILE_BLOCK = new ModSnowTileBlock(MainModule.blockProp((AbstractBlock)BLOCK));
    @Name(value="minecraft:snow")
    public static final SnowBlockItem ITEM = new SnowBlockItem((Block)BLOCK);
    public static final SnowFenceBlock FENCE = new SnowFenceBlock(MainModule.blockProp((AbstractBlock)Blocks.field_180407_aO).func_200944_c());
    public static final SnowFenceBlock FENCE2 = new SnowFenceBlock(MainModule.blockProp((AbstractBlock)Blocks.field_150386_bk).func_200944_c());
    public static final SnowStairsBlock STAIRS = new SnowStairsBlock(MainModule.blockProp((AbstractBlock)Blocks.field_150476_ad).func_200944_c());
    public static final SnowSlabBlock SLAB = new SnowSlabBlock(MainModule.blockProp((AbstractBlock)Blocks.field_196622_bq).func_200944_c());
    public static final SnowFenceGateBlock FENCE_GATE = new SnowFenceGateBlock(MainModule.blockProp((AbstractBlock)Blocks.field_180390_bo).func_200944_c());
    public static final SnowWallBlock WALL = new SnowWallBlock(MainModule.blockProp((AbstractBlock)Blocks.field_150463_bK).func_200944_c());
    @Name(value="snow")
    public static final TileEntityType<SnowTile> TILE = TileEntityType.Builder.func_223042_a(() -> new SnowTile(), (Block[])new Block[]{TILE_BLOCK}).func_206865_a(null);
    public static final TileEntityType<SnowTextureTile> TEXTURE_TILE = TileEntityType.Builder.func_223042_a(() -> new SnowTextureTile(), (Block[])new Block[]{FENCE, FENCE2, STAIRS, SLAB, FENCE_GATE, WALL}).func_206865_a(null);
    @Name(value="snow")
    public static final EntityType<FallingSnowEntity> ENTITY = EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MISC).setCustomClientFactory((spawnEntity, world) -> new FallingSnowEntity((World)world)).func_220321_a(0.98f, 0.001f).func_206830_a("snowrealmagic.snow");
    @Skip
    public static final LootPoolEntryType NORMAL = (LootPoolEntryType)Registry.func_218325_a((Registry)Registry.field_239693_aY_, (String)"snowrealmagic:normal", (Object)new LootPoolEntryType((ILootSerializer)new NormalLootEntry.Serializer()));

    @OnlyIn(value=Dist.CLIENT)
    protected void clientInit(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(ENTITY, FallingSnowRenderer::new);
        ClientRegistry.bindTileEntityRenderer(TILE, dispatcher -> new SnowRenderer((TileEntityRendererDispatcher)dispatcher));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        ISnowVariant block = FENCE;
        TextureModel.register((ModelBakeEvent)event, (Block)block, null, (String)"0");
        TextureModel.registerInventory((ModelBakeEvent)event, (IItemProvider)block, (String)"0");
        block = FENCE2;
        TextureModel.register((ModelBakeEvent)event, (Block)block, null, (String)"0");
        TextureModel.registerInventory((ModelBakeEvent)event, (IItemProvider)block, (String)"0");
        block = STAIRS;
        BlockState state = (BlockState)block.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
        TextureModel.register((ModelBakeEvent)event, (Block)block, (BlockState)state, (String)"0");
        block = SLAB;
        state = block.func_176223_P();
        TextureModel.register((ModelBakeEvent)event, (Block)block, (BlockState)state, (String)"0");
        block = FENCE_GATE;
        state = (BlockState)block.func_176223_P().func_206870_a((Property)SnowFenceGateBlock.DOWN, (Comparable)Boolean.valueOf(false));
        TextureModel.register((ModelBakeEvent)event, (Block)block, (BlockState)state, (String)"0");
        block = WALL;
        TextureModel.register((ModelBakeEvent)event, (Block)block, null, (String)"0");
        TextureModel.registerInventory((ModelBakeEvent)event, (IItemProvider)block, (String)"0");
        ModBlockItem.INSTANT_UPDATE_TILES.add(TEXTURE_TILE);
    }

    public static ItemStack makeTextureItem(Item item, ItemStack mark) {
        ItemStack stack = new ItemStack((IItemProvider)item);
        NBTHelper helper = NBTHelper.of((ItemStack)stack);
        String v = Util.trimRL((ResourceLocation)mark.func_77973_b().getRegistryName());
        helper.setString("BlockEntityTag.Textures.0", NBTUtil.func_190009_a((BlockState)((BlockItem)mark.func_77973_b()).func_179223_d().func_176223_P()).toString());
        helper.setString("BlockEntityTag.Items.0", v);
        return stack;
    }

    public static void fillTextureItems(ITag.INamedTag<Item> tag, Block block, NonNullList<ItemStack> items) {
        MainModule.fillTextureItems(tag, block, items, (Predicate<Item>)Predicates.alwaysTrue());
    }

    public static void fillTextureItems(ITag.INamedTag<Item> tag, Block block, NonNullList<ItemStack> items, Predicate<Item> filter) {
        if (!Kiwi.areTagsUpdated()) {
            return;
        }
        Item item = block.func_199767_j();
        items.addAll((Collection)tag.func_230236_b_().stream().filter(i -> i instanceof BlockItem && ((BlockItem)i).func_179223_d().func_176223_P().func_200132_m() && !i.getRegistryName().func_110624_b().equals("snowrealmagic")).filter(filter).map(ItemStack::new).filter(FullBlockIngredient::isTextureBlock).map(m -> MainModule.makeTextureItem(item, m)).collect(Collectors.toList()));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onBlockTint(ColorHandlerEvent.Block event) {
        if (!SnowClientConfig.colorTint) {
            return;
        }
        BlockColors blockColors = event.getBlockColors();
        blockColors.func_186722_a((state, world, pos, index) -> {
            if (world == null || pos == null) {
                return -1;
            }
            Block block = state.func_177230_c();
            if (block instanceof ISnowVariant) {
                BlockState raw = ((ISnowVariant)block).getRaw(state, (IBlockReader)world, pos);
                return blockColors.func_228054_a_(raw, world, pos, index);
            }
            return -1;
        }, new Block[]{SLAB, STAIRS, WALL, FENCE, FENCE2, FENCE_GATE});
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onItemTint(ColorHandlerEvent.Item event) {
        if (!SnowClientConfig.colorTint) {
            return;
        }
        ItemColors itemColors = event.getItemColors();
        itemColors.func_199877_a((stack, index) -> {
            Item item;
            NBTHelper data = NBTHelper.of((ItemStack)stack);
            String rl = data.getString("BlockEntityTag.Items.0");
            if (rl != null && ResourceLocation.func_217855_b((String)rl) && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(rl))) != null) {
                return itemColors.func_186728_a(new ItemStack((IItemProvider)item), index);
            }
            return -1;
        }, new IItemProvider[]{SLAB, STAIRS, WALL, FENCE, FENCE2, FENCE_GATE});
    }
}

