/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.WallBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.RenderLayer;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.util.Util;
import snownee.snow.MainModule;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.IWaterLoggableSnowVariant;
import snownee.snow.block.ModSnowBlock;
import snownee.snow.block.SnowTextureTile;

@RenderLayer(value=RenderLayer.Layer.CUTOUT)
public class SnowWallBlock
extends WallBlock
implements IWaterLoggableSnowVariant {
    public static final BooleanProperty DOWN = SixWayBlock.field_196489_A;

    public SnowWallBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SnowTextureTile();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ModBlock.pickBlock((BlockState)state, (RayTraceResult)target, (IBlockReader)world, (BlockPos)pos, (PlayerEntity)player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String key = Util.getTextureItem((ItemStack)stack, (String)"0");
        if (!key.isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(key).func_240699_a_(TextFormatting.GRAY));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176256_a, field_235612_b_, field_235613_c_, field_235614_d_, field_235615_e_, BlockStateProperties.field_208198_y, DOWN});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(MainModule.BLOCK.isValidPosition(stateIn, (IWorldReader)worldIn, currentPos, true)));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockState stateIn = iblockreader.func_180495_p(blockpos);
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(MainModule.BLOCK.func_196260_a(stateIn, (IWorldReader)iblockreader, blockpos)));
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        MainModule.fillTextureItems((ITag.INamedTag<Item>)ItemTags.field_219778_z, (Block)this, items);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (SnowCommonConfig.retainOriginalBlocks) {
            worldIn.func_175656_a(pos, this.getRaw(state, (IBlockReader)worldIn, pos));
        } else if (ModUtil.shouldMelt((World)worldIn, pos)) {
            worldIn.func_175656_a(pos, this.getRaw(state, (IBlockReader)worldIn, pos));
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return super.func_220053_a((BlockState)state.func_206870_a((Property)DOWN, (Comparable)Boolean.TRUE), worldIn, pos, context);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return super.func_220071_b((BlockState)state.func_206870_a((Property)DOWN, (Comparable)Boolean.TRUE), worldIn, pos, context);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        VoxelShape shape = super.func_196247_c(state, worldIn, pos);
        if (((Boolean)state.func_177229_b((Property)DOWN)).booleanValue()) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)ModSnowBlock.SNOW_SHAPES_MAGIC[2], (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return this.getRaw(state, (IBlockReader)world, pos).getSoundType(world, pos, entity);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return this.getRaw(state, worldIn, pos).func_185903_a(player, worldIn, pos);
    }
}

