/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import edivad.solargeneration.blocks.containers.SolarPanelContainer;
import edivad.solargeneration.tile.TileEntitySolarPanel;
import java.util.Collections;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class SolarPanelScreen
extends ContainerScreen<SolarPanelContainer> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("solargeneration", "textures/gui/solar_panel.png");
    private final TileEntitySolarPanel tile;

    public SolarPanelScreen(SolarPanelContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tile = container.tile;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (mouseX > this.field_147003_i + 7 && mouseX < this.field_147003_i + 29 && mouseY > this.field_147009_r + 10 && mouseY < this.field_147009_r + 77) {
            this.renderTooltip(Collections.singletonList("Energy: " + this.getPercent() + "%"), mouseX, mouseY, this.font);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String energy = "Stored energy: " + this.getEnergyFormatted(this.tile.energyClient);
        this.font.func_211126_b(energy, (float)(this.field_146999_f / 2 - this.font.func_78256_a(energy) / 2 + 14), 20.0f, 0x404040);
        String maxEnergy = "Max capacity: " + this.getEnergyFormatted(this.tile.maxEnergy);
        this.font.func_211126_b(maxEnergy, (float)(this.field_146999_f / 2 - this.font.func_78256_a(maxEnergy) / 2 + 14), 30.0f, 0x404040);
        String generation = "Generation: " + this.tile.energyProductionClient + " FE/t";
        this.font.func_211126_b(generation, (float)(this.field_146999_f / 2 - this.font.func_78256_a(generation) / 2 + 14), 40.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURES);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int y = this.getEnergyScaled(60);
        this.blit(this.field_147003_i + 10, this.field_147009_r + 12 + y, 176, 0, 16, 60 - y);
    }

    private String getEnergyFormatted(int energy) {
        if (energy >= 1000000) {
            return energy / 1000 + " kFE";
        }
        return energy + " FE";
    }

    private int getEnergyScaled(int pixels) {
        return pixels - pixels * this.getPercent() / 100;
    }

    private int getPercent() {
        Long currentEnergy = new Long(this.tile.energyClient);
        int maxEnergy = this.tile.maxEnergy;
        long result = currentEnergy * 100L / (long)maxEnergy;
        return (int)result;
    }
}

