/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.items;

import edivad.solargeneration.setup.ModSetup;
import edivad.solargeneration.tools.ModelCustomArmour;
import edivad.solargeneration.tools.MyEnergyStorage;
import edivad.solargeneration.tools.ProductionSolarPanel;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Tooltip;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;

public class SolarHelmet
extends ArmorItem {
    private SolarPanelLevel levelSolarHelmet;
    private MyEnergyStorage energyStorage;
    private int energyGeneration;
    private int maxEnergyOutput;

    public SolarHelmet(SolarPanelLevel levelSolarHelmet) {
        super((IArmorMaterial)(levelSolarHelmet.ordinal() > 4 ? ArmorMaterial.DIAMOND : ArmorMaterial.IRON), EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(ModSetup.solarGenerationTab).func_200917_a(1));
        this.levelSolarHelmet = levelSolarHelmet;
        this.energyGeneration = (int)Math.pow(8.0, levelSolarHelmet.ordinal());
        this.maxEnergyOutput = this.energyGeneration * 2;
        this.energyStorage = new MyEnergyStorage(this.energyGeneration * 2, this.energyGeneration * 1000);
    }

    public boolean func_77645_m() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Tooltip.showInfoCtrl(this.getEnergyStored(stack), tooltip);
        Tooltip.showInfoShift(this.levelSolarHelmet, tooltip);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        if (itemStack != ItemStack.field_190927_a && itemStack.func_77973_b() instanceof ArmorItem) {
            ModelCustomArmour model = new ModelCustomArmour();
            model.field_78116_c.field_78806_j = armorSlot == EquipmentSlotType.HEAD;
            model.field_217114_e = _default.field_217114_e;
            model.field_217113_d = _default.field_217113_d;
            model.field_228270_o_ = _default.field_228270_o_;
            model.field_187076_m = _default.field_187076_m;
            model.field_187075_l = _default.field_187075_l;
            return (A)((Object)model);
        }
        return null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "solargeneration:textures/models/armor/solar_helmet_" + this.levelSolarHelmet.name().toLowerCase() + ".png";
    }

    public SolarPanelLevel getLevelSolarPanel() {
        return this.levelSolarHelmet;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored();
    }

    public void saveEnergyItem(ItemStack container) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new CompoundNBT());
        }
        container.func_77978_p().func_74768_a("energy", this.energyStorage.getEnergyStored());
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            return 0;
        }
        return container.func_77978_p().func_74762_e("energy");
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public void onArmorTick(ItemStack itemStack, World world, PlayerEntity player) {
        if (world.field_72995_K) {
            return;
        }
        if (this.getEnergyStored(itemStack) != this.getMaxEnergyStored()) {
            this.energyStorage.generatePower(this.currentAmountEnergyProduced(world, player));
        }
        this.sendEnergy(world, player);
        this.saveEnergyItem(itemStack);
    }

    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            this.energyStorage.setEnergy(0);
            this.saveEnergyItem(stack);
        } else {
            this.energyStorage.setEnergy(this.getEnergyStored(stack));
        }
        return super.getEquipmentSlot(stack);
    }

    private void sendEnergy(World world, PlayerEntity player) {
        ItemStack slot;
        int i;
        for (i = 36; i < 40 && this.energyStorage.getEnergyStored() > 0; ++i) {
            slot = player.field_71071_by.func_70301_a(i);
            this.chargegItem(slot);
        }
        for (i = 0; i < 36 && this.energyStorage.getEnergyStored() > 0; ++i) {
            slot = player.field_71071_by.func_70301_a(i);
            this.chargegItem(slot);
        }
    }

    private void chargegItem(ItemStack slot) {
        if (slot.func_190916_E() == 1) {
            slot.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> {
                if (handler.canReceive()) {
                    while (handler.getEnergyStored() < handler.getMaxEnergyStored() && this.energyStorage.getEnergyStored() > 0) {
                        int accepted = Math.min(this.maxEnergyOutput, handler.receiveEnergy(this.energyStorage.getEnergyStored(), true));
                        this.energyStorage.consumePower(accepted);
                        handler.receiveEnergy(accepted, false);
                    }
                }
            });
        }
    }

    private int currentAmountEnergyProduced(World world, PlayerEntity player) {
        if (!this.energyStorage.isFullEnergy()) {
            return (int)((float)this.energyGeneration * ProductionSolarPanel.computeSunIntensity(world, player.func_180425_c().func_177982_a(0, 1, 0), this.getLevelSolarPanel()));
        }
        return 0;
    }
}

