/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.tile;

import edivad.solargeneration.blocks.containers.SolarPanelAdvancedContainer;
import edivad.solargeneration.blocks.containers.SolarPanelHardenedContainer;
import edivad.solargeneration.blocks.containers.SolarPanelLeadstoneContainer;
import edivad.solargeneration.blocks.containers.SolarPanelRedstoneContainer;
import edivad.solargeneration.blocks.containers.SolarPanelResonantContainer;
import edivad.solargeneration.blocks.containers.SolarPanelSignalumContainer;
import edivad.solargeneration.blocks.containers.SolarPanelUltimateContainer;
import edivad.solargeneration.network.PacketHandler;
import edivad.solargeneration.network.packet.UpdateSolarPanel;
import edivad.solargeneration.tools.MyEnergyStorage;
import edivad.solargeneration.tools.ProductionSolarPanel;
import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.PacketDistributor;

public class TileEntitySolarPanel
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    private int energyGeneration;
    private int maxEnergyOutput;
    public int maxEnergy;
    private SolarPanelLevel levelSolarPanel;
    public int energyClient;
    public int energyProductionClient;

    public TileEntitySolarPanel(SolarPanelLevel levelSolarPanel, TileEntityType<?> tileEntitySolarPanel) {
        super(tileEntitySolarPanel);
        this.levelSolarPanel = levelSolarPanel;
        this.energyGeneration = (int)Math.pow(8.0, levelSolarPanel.ordinal());
        this.maxEnergyOutput = this.energyGeneration * 2;
        this.maxEnergy = this.energyGeneration * 1000;
        this.energyProductionClient = -1;
        this.energyClient = -1;
    }

    private IEnergyStorage createEnergy() {
        return new MyEnergyStorage(this.maxEnergyOutput, this.maxEnergy);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.energy.ifPresent(e -> ((MyEnergyStorage)((Object)e)).generatePower(this.currentAmountEnergyProduced()));
            this.sendEnergy();
            if (this.energyClient != this.getEnergy() || this.energyProductionClient != this.currentAmountEnergyProduced()) {
                int energyProduced = this.getEnergy() != this.getMaxEnergy() ? this.currentAmountEnergyProduced() : 0;
                PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UpdateSolarPanel(this.func_174877_v(), this.getEnergy(), energyProduced));
            }
        }
    }

    private int getMaxEnergy() {
        return (Integer)this.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse((Object)0);
    }

    private int getEnergy() {
        return (Integer)this.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse((Object)0);
    }

    private int currentAmountEnergyProduced() {
        return (int)((float)this.energyGeneration * ProductionSolarPanel.computeSunIntensity(this.field_145850_b, this.func_174877_v(), this.levelSolarPanel));
    }

    private void sendEnergy() {
        this.energy.ifPresent(energy -> {
            AtomicInteger capacity = new AtomicInteger(energy.getEnergyStored());
            for (int i = 0; i < Direction.values().length && capacity.get() > 0; ++i) {
                TileEntity tileEntity;
                Direction facing = Direction.values()[i];
                if (facing == Direction.UP || (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null) continue;
                tileEntity.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()).ifPresent(handler -> {
                    if (handler.canReceive()) {
                        int received = handler.receiveEnergy(Math.min(capacity.get(), this.maxEnergyOutput), false);
                        capacity.addAndGet(-received);
                        ((MyEnergyStorage)((Object)energy)).consumePower(received);
                    }
                });
            }
        });
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != Direction.UP) {
            return this.energy.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145839_a(CompoundNBT compound) {
        CompoundNBT energyTag = compound.func_74775_l("energy");
        this.energy.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)energyTag));
        super.func_145839_a(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.energy.ifPresent(h -> {
            CompoundNBT tag = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            compound.func_218657_a("energy", (INBT)tag);
        });
        return super.func_189515_b(compound);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        switch (this.levelSolarPanel) {
            case Advanced: {
                return new SolarPanelAdvancedContainer(id, this.field_145850_b, this.field_174879_c, playerEntity);
            }
            case Hardened: {
                return new SolarPanelHardenedContainer(id, this.field_145850_b, this.field_174879_c, playerEntity);
            }
            case Leadstone: {
                return new SolarPanelLeadstoneContainer(id, this.field_145850_b, this.field_174879_c, playerEntity);
            }
            case Redstone: {
                return new SolarPanelRedstoneContainer(id, this.field_145850_b, this.field_174879_c, playerEntity);
            }
            case Resonant: {
                return new SolarPanelResonantContainer(id, this.field_145850_b, this.field_174879_c, playerEntity);
            }
            case Signalum: {
                return new SolarPanelSignalumContainer(id, this.field_145850_b, this.field_174879_c, playerEntity);
            }
            case Ultimate: {
                return new SolarPanelUltimateContainer(id, this.field_145850_b, this.field_174879_c, playerEntity);
            }
        }
        return null;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
    }
}

