/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.blocks;

import edivad.solargeneration.tile.TileEntitySolarPanel;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Tooltip;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;

public class SolarPanel
extends Block
implements IWaterLoggable {
    private final SolarPanelLevel levelSolarPanel;
    private static final VoxelShape BOX = SolarPanel.createShape();
    private static final ResourceLocation WRENCH = new ResourceLocation("forge", "wrench");
    private static final BooleanProperty WATERLOGGED = BooleanProperty.func_177716_a((String)"waterlogged");

    public SolarPanel(SolarPanelLevel levelSolarPanel) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(5.0f, 30.0f));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.levelSolarPanel = levelSolarPanel;
    }

    private static VoxelShape createShape() {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(SolarPanel.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
        shapes.add(SolarPanel.func_208617_a((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0));
        shapes.add(SolarPanel.func_208617_a((double)6.0, (double)1.0, (double)9.0, (double)7.0, (double)9.0, (double)10.0));
        shapes.add(SolarPanel.func_208617_a((double)9.0, (double)1.0, (double)9.0, (double)10.0, (double)9.0, (double)10.0));
        shapes.add(SolarPanel.func_208617_a((double)9.0, (double)1.0, (double)6.0, (double)10.0, (double)9.0, (double)7.0));
        shapes.add(SolarPanel.func_208617_a((double)6.0, (double)1.0, (double)6.0, (double)7.0, (double)9.0, (double)7.0));
        shapes.add(SolarPanel.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0));
        VoxelShape combinedShape = VoxelShapes.func_197880_a();
        for (VoxelShape shape : shapes) {
            combinedShape = VoxelShapes.func_197882_b((VoxelShape)combinedShape, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return combinedShape;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BOX;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BOX;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            if (player.func_213453_ef() && player.func_184614_ca().func_77973_b().getTags().contains(WRENCH)) {
                this.dismantleBlock(worldIn, pos);
                return ActionResultType.SUCCESS;
            }
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof INamedContainerProvider) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void dismantleBlock(World worldIn, BlockPos pos) {
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        TileEntitySolarPanel localTileEntity = (TileEntitySolarPanel)worldIn.func_175625_s(pos);
        int internalEnergy = localTileEntity.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
        if (internalEnergy > 0) {
            CompoundNBT energyValue = new CompoundNBT();
            energyValue.func_74768_a("value", internalEnergy);
            CompoundNBT energy = new CompoundNBT();
            energy.func_218657_a("energy", (INBT)energyValue);
            CompoundNBT root = new CompoundNBT();
            root.func_218657_a("BlockEntityTag", (INBT)energy);
            itemStack.func_77982_d(root);
        }
        worldIn.func_217377_a(pos, false);
        ItemEntity entityItem = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack);
        entityItem.func_213293_j(0.0, entityItem.func_70033_W(), 0.0);
        worldIn.func_217376_c((Entity)entityItem);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_217377_a(pos, false);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntitySolarPanel(this.levelSolarPanel);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        int energy = 0;
        if (compoundnbt != null && compoundnbt.func_74764_b("energy")) {
            energy = compoundnbt.func_74775_l("energy").func_74762_e("value");
        }
        Tooltip.showInfoCtrl(energy, tooltip);
        Tooltip.showInfoShift(this.levelSolarPanel, tooltip);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }
}

