/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import edivad.solargeneration.container.SolarPanelContainer;
import edivad.solargeneration.tile.TileEntitySolarPanel;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SolarPanelScreen
extends ContainerScreen<SolarPanelContainer> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("solargeneration", "textures/gui/solar_panel.png");
    private final TileEntitySolarPanel tile;

    public SolarPanelScreen(SolarPanelContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tile = container.tile;
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(mStack, mouseX, mouseY);
        if (mouseX > this.field_147003_i + 7 && mouseX < this.field_147003_i + 29 && mouseY > this.field_147009_r + 10 && mouseY < this.field_147009_r + 77) {
            this.func_238652_a_(mStack, (ITextComponent)new StringTextComponent("Energy: " + this.getPercent() + "%"), mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack mStack, int mouseX, int mouseY) {
        String energy = new TranslationTextComponent("gui.solargeneration.stored_energy").func_240702_b_(" " + this.getEnergyFormatted(this.tile.energyClient)).getString();
        this.field_230712_o_.func_238421_b_(mStack, energy, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(energy) / 2 + 14), 20.0f, 0x404040);
        String maxEnergy = new TranslationTextComponent("gui.solargeneration.max_capacity").func_240702_b_(" " + this.getEnergyFormatted(this.tile.maxEnergy)).getString();
        this.field_230712_o_.func_238421_b_(mStack, maxEnergy, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(maxEnergy) / 2 + 14), 30.0f, 0x404040);
        String generation = new TranslationTextComponent("gui.solargeneration.generation").func_240702_b_(" " + this.tile.energyProductionClient + " FE/t").getString();
        this.field_230712_o_.func_238421_b_(mStack, generation, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(generation) / 2 + 14), 40.0f, 0x404040);
    }

    protected void func_230450_a_(MatrixStack mStack, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURES);
        this.func_238474_b_(mStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int y = this.getEnergyScaled(60);
        this.func_238474_b_(mStack, this.field_147003_i + 10, this.field_147009_r + 12 + y, this.field_146999_f, 0, 16, 60 - y);
    }

    private String getEnergyFormatted(int energy) {
        if (energy >= 1000000) {
            return energy / 1000 + " kFE";
        }
        return energy + " FE";
    }

    private int getEnergyScaled(int pixels) {
        return pixels - pixels * this.getPercent() / 100;
    }

    private int getPercent() {
        Long currentEnergy = new Long(this.tile.energyClient);
        int maxEnergy = this.tile.maxEnergy;
        long result = currentEnergy * 100L / (long)maxEnergy;
        return (int)result;
    }
}

