/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.setup;

import edivad.solargeneration.Main;
import edivad.solargeneration.blocks.SolarPanel;
import edivad.solargeneration.container.SolarPanelContainer;
import edivad.solargeneration.items.SolarHelmet;
import edivad.solargeneration.setup.ModSetup;
import edivad.solargeneration.tile.TileEntitySolarPanel;
import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class Registration {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"solargeneration");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"solargeneration");
    private static final DeferredRegister<TileEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"solargeneration");
    private static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"solargeneration");
    public static final Map<SolarPanelLevel, RegistryObject<SolarPanel>> SOLAR_PANEL_BLOCK = new HashMap<SolarPanelLevel, RegistryObject<SolarPanel>>();
    public static final Map<SolarPanelLevel, RegistryObject<Item>> SOLAR_PANEL_ITEM = new HashMap<SolarPanelLevel, RegistryObject<Item>>();
    public static final Map<SolarPanelLevel, RegistryObject<TileEntityType<TileEntitySolarPanel>>> SOLAR_PANEL_TILE = new HashMap<SolarPanelLevel, RegistryObject<TileEntityType<TileEntitySolarPanel>>>();
    public static final Map<SolarPanelLevel, RegistryObject<ContainerType<SolarPanelContainer>>> SOLAR_PANEL_CONTAINER = new HashMap<SolarPanelLevel, RegistryObject<ContainerType<SolarPanelContainer>>>();
    public static final Map<SolarPanelLevel, RegistryObject<Item>> HELMET = new HashMap<SolarPanelLevel, RegistryObject<Item>>();
    public static final Map<SolarPanelLevel, RegistryObject<Item>> CORE = new HashMap<SolarPanelLevel, RegistryObject<Item>>();
    private static final Item.Properties property = new Item.Properties().func_200916_a(ModSetup.solarGenerationTab);
    public static final RegistryObject<Item> LAPIS_SHARD = ITEMS.register("lapis_shard", () -> new Item(property));
    public static final RegistryObject<Item> PHOTOVOLTAIC_CELL = ITEMS.register("photovoltaic_cell", () -> new Item(property));

    public static void init() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        for (SolarPanelLevel level : SolarPanelLevel.values()) {
            SOLAR_PANEL_BLOCK.put(level, (RegistryObject<SolarPanel>)BLOCKS.register(level.getSolarPanelName(), () -> new SolarPanel(level)));
            SOLAR_PANEL_ITEM.put(level, (RegistryObject<Item>)ITEMS.register(level.getSolarPanelName(), () -> new BlockItem((Block)SOLAR_PANEL_BLOCK.get((Object)level).get(), property)));
            SOLAR_PANEL_TILE.put(level, (RegistryObject<TileEntityType<TileEntitySolarPanel>>)TILES.register(level.getSolarPanelName(), () -> TileEntityType.Builder.func_223042_a(() -> new TileEntitySolarPanel(level), (Block[])new Block[]{(Block)SOLAR_PANEL_BLOCK.get((Object)level).get()}).func_206865_a(null)));
            SOLAR_PANEL_CONTAINER.put(level, (RegistryObject<ContainerType<SolarPanelContainer>>)CONTAINERS.register(level.getSolarPanelName(), () -> IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                TileEntity te = inv.field_70458_d.func_130014_f_().func_175625_s(pos);
                if (!(te instanceof TileEntitySolarPanel)) {
                    Main.logger.error("Wrong type of tile entity (expected TileEntitySolarPanel)!");
                    return null;
                }
                TileEntitySolarPanel tile = (TileEntitySolarPanel)te;
                return new SolarPanelContainer(windowId, inv.field_70458_d, tile, level);
            })));
            HELMET.put(level, (RegistryObject<Item>)ITEMS.register(level.getSolarHelmetName(), () -> new SolarHelmet(level)));
            CORE.put(level, (RegistryObject<Item>)ITEMS.register(level.getSolarCoreName(), () -> new Item(property)));
        }
    }
}

