/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTileEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.ServerBackpackSoundHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WorldHelper;

public class BackpackBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape NORTH_SHAPE = BackpackBlock.func_208617_a((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)14.0, (double)10.0);
    private static final VoxelShape SOUTH_SHAPE = BackpackBlock.func_208617_a((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)14.0, (double)11.0);
    private static final VoxelShape WEST_SHAPE = BackpackBlock.func_208617_a((double)5.0, (double)0.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0);
    private static final VoxelShape EAST_SHAPE = BackpackBlock.func_208617_a((double)6.0, (double)0.0, (double)2.0, (double)11.0, (double)14.0, (double)14.0);
    private static final int BEDROCK_RESISTANCE = 3600000;

    public BackpackBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_226896_b_().func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public FluidState func_204507_t(BlockState state) {
        return Boolean.TRUE.equals(state.func_177229_b((Property)BlockStateProperties.field_208198_y)) ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (Boolean.TRUE.equals(stateIn.func_177229_b((Property)BlockStateProperties.field_208198_y))) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, BlockStateProperties.field_208198_y});
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        if (this.hasEverlastingUpgrade(world, pos)) {
            return 3600000.0f;
        }
        return super.getExplosionResistance(state, world, pos, explosion);
    }

    private boolean hasEverlastingUpgrade(IBlockReader world, BlockPos pos) {
        return WorldHelper.getTile(world, pos, BackpackTileEntity.class).map(te -> !te.getBackpackWrapper().getUpgradeHandler().getTypeWrappers(EverlastingUpgradeItem.TYPE).isEmpty()).orElse(false);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        switch (facing) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BackpackTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_() && player.func_184586_b(hand).func_190926_b()) {
            BackpackBlock.putInPlayersHandAndRemove(state, world, pos, player, hand);
            return ActionResultType.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((w, p, pl) -> new BackpackContainer(w, pl, new BackpackContext.Block(pos)), this.getBackpackDisplayName(world, pos)), buf -> buf.writeLong(pos.func_218275_a()));
        return ActionResultType.SUCCESS;
    }

    private ITextComponent getBackpackDisplayName(World world, BlockPos pos) {
        ITextComponent defaultDisplayName = new ItemStack((IItemProvider)ModItems.BACKPACK.get()).func_200301_q();
        return WorldHelper.getTile((IBlockReader)world, pos, BackpackTileEntity.class).map(te -> te.getBackpackWrapper().getBackpack().func_200301_q()).orElse(defaultDisplayName);
    }

    private static void putInPlayersHandAndRemove(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand) {
        ItemStack backpack = WorldHelper.getTile((IBlockReader)world, pos, BackpackTileEntity.class).map(te -> te.getBackpackWrapper().getBackpack()).orElse(ItemStack.field_190927_a);
        player.func_184611_a(hand, backpack);
        player.func_184811_cZ().func_185145_a(backpack.func_77973_b(), 5);
        world.func_217377_a(pos, false);
        BackpackBlock.stopBackpackSounds(backpack, world, pos);
        SoundType soundType = state.func_215695_r();
        world.func_184133_a(null, pos, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
    }

    private static void stopBackpackSounds(ItemStack backpack, World world, BlockPos pos) {
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.getContentsUuid().ifPresent(uuid -> ServerBackpackSoundHandler.stopPlayingDisc((ServerWorld)world, Vector3d.func_237489_a_((Vector3i)pos), uuid)));
    }

    public static void playerInteract(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        BlockPos pos = event.getPos();
        if (!player.func_225608_bj_() || !BackpackBlock.hasEmptyMainHandAndSomethingInOffhand(player) || BackpackBlock.didntInteractWithBackpack(event)) {
            return;
        }
        if (world.field_72995_K) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BackpackBlock)) {
            return;
        }
        BackpackBlock.putInPlayersHandAndRemove(state, world, pos, player, player.func_184614_ca().func_190926_b() ? Hand.MAIN_HAND : Hand.OFF_HAND);
        event.setCanceled(true);
        event.setCancellationResult(ActionResultType.SUCCESS);
    }

    private static boolean didntInteractWithBackpack(PlayerInteractEvent.RightClickBlock event) {
        return !(event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof BackpackBlock);
    }

    private static boolean hasEmptyMainHandAndSomethingInOffhand(PlayerEntity player) {
        return player.func_184614_ca().func_190926_b() && !player.func_184592_cb().func_190926_b();
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        super.func_196262_a(state, world, pos, entity);
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            WorldHelper.getTile((IBlockReader)world, pos, BackpackTileEntity.class).ifPresent(te -> this.tryToPickup(world, itemEntity, te.getBackpackWrapper()));
        }
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        if (this.hasEverlastingUpgrade(world, pos)) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    private void tryToPickup(World world, ItemEntity itemEntity, IBackpackWrapper w) {
        ItemStack remainingStack = itemEntity.func_92059_d().func_77946_l();
        InventoryHelper.runPickupOnBackpack(world, remainingStack, w, false);
        if (remainingStack.func_190916_E() < itemEntity.func_92059_d().func_190916_E()) {
            itemEntity.func_92058_a(remainingStack);
        }
    }
}

