/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTileEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.BackpackDyeRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingBackpackItemEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryInteractionHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ItemBase;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WorldHelper;

public class BackpackItem
extends ItemBase {
    public static final String BACKPACK_TOOLTIP = "item.sophisticatedbackpacks.backpack.tooltip.";
    private final IntSupplier numberOfSlots;
    private final IntSupplier numberOfUpgradeSlots;
    private final Supplier<BackpackBlock> blockSupplier;

    public BackpackItem(IntSupplier numberOfSlots, IntSupplier numberOfUpgradeSlots, Supplier<BackpackBlock> blockSupplier) {
        this(numberOfSlots, numberOfUpgradeSlots, blockSupplier, new Item.Properties());
    }

    public BackpackItem(IntSupplier numberOfSlots, IntSupplier numberOfUpgradeSlots, Supplier<BackpackBlock> blockSupplier, Item.Properties properties) {
        super(properties.func_200917_a(1));
        this.numberOfSlots = numberOfSlots;
        this.numberOfUpgradeSlots = numberOfUpgradeSlots;
        this.blockSupplier = blockSupplier;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (!this.func_194125_a(group) || this != ModItems.BACKPACK.get()) {
            return;
        }
        for (DyeColor color : DyeColor.values()) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            new BackpackWrapper(stack).setColors(color.getColorValue(), color.getColorValue());
            items.add((Object)stack);
        }
        int clothColor = BackpackDyeRecipe.calculateColor(13394234, 13394234, (List<DyeColor>)ImmutableList.of((Object)DyeColor.BLUE, (Object)DyeColor.YELLOW, (Object)DyeColor.LIME));
        int trimColor = BackpackDyeRecipe.calculateColor(6434330, 6434330, (List<DyeColor>)ImmutableList.of((Object)DyeColor.BLUE, (Object)DyeColor.BLACK));
        ItemStack stack = new ItemStack((IItemProvider)this);
        new BackpackWrapper(stack).setColors(clothColor, trimColor);
        items.add((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (flagIn == ITooltipFlag.TooltipFlags.ADVANCED) {
            stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(w -> w.getContentsUuid().ifPresent(uuid -> tooltip.add((ITextComponent)new StringTextComponent("UUID: " + uuid).func_240699_a_(TextFormatting.DARK_GRAY))));
        }
        if (!Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.sophisticatedbackpacks.backpack.tooltip.press_for_contents", new Object[]{new TranslationTextComponent("item.sophisticatedbackpacks.backpack.tooltip.shift").func_240699_a_(TextFormatting.AQUA)}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.hasEverlastingUpgrade(stack);
    }

    private boolean hasEverlastingUpgrade(ItemStack stack) {
        return stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(w -> !w.getUpgradeHandler().getTypeWrappers(EverlastingUpgradeItem.TYPE).isEmpty()).orElse(false);
    }

    @Nullable
    public Entity createEntity(World world, Entity entity, ItemStack itemstack) {
        if (!(entity instanceof ItemEntity)) {
            return null;
        }
        return this.hasEverlastingUpgrade(itemstack) ? this.createEverlastingBackpack(world, (ItemEntity)entity, itemstack) : null;
    }

    @Nullable
    private EverlastingBackpackItemEntity createEverlastingBackpack(World world, ItemEntity itemEntity, ItemStack itemstack) {
        EverlastingBackpackItemEntity backpackItemEntity = (EverlastingBackpackItemEntity)((EntityType)ModItems.EVERLASTING_BACKPACK_ITEM_ENTITY.get()).func_200721_a(world);
        if (backpackItemEntity != null) {
            backpackItemEntity.func_70107_b(itemEntity.func_226277_ct_(), itemEntity.func_226278_cu_(), itemEntity.func_226281_cx_());
            backpackItemEntity.func_92058_a(itemstack);
            backpackItemEntity.func_174867_a(this.getPickupDelay(itemEntity));
            backpackItemEntity.func_200216_c(itemEntity.func_200214_m());
            backpackItemEntity.func_213317_d(itemEntity.func_213322_ci());
        }
        return backpackItemEntity;
    }

    private int getPickupDelay(ItemEntity itemEntity) {
        Integer result = (Integer)ObfuscationReflectionHelper.getPrivateValue(ItemEntity.class, (Object)itemEntity, (String)"field_145804_b");
        if (result == null) {
            SophisticatedBackpacks.LOGGER.error("Reflection get of pickupDelay (field_145804_b) from ItemEntity returned null");
            return 20;
        }
        return result;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockItemUseContext blockItemUseContext;
        PlayerEntity player = context.func_195999_j();
        if (player == null || !player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        if (InventoryInteractionHelper.tryInventoryInteraction(context)) {
            return ActionResultType.SUCCESS;
        }
        Direction direction = player.func_174811_aO().func_176734_d();
        ActionResultType result = this.tryPlace(player, direction, blockItemUseContext = new BlockItemUseContext(context));
        return result == ActionResultType.PASS ? super.func_195939_a(context) : result;
    }

    public ActionResultType tryPlace(@Nullable PlayerEntity player, Direction direction, BlockItemUseContext blockItemUseContext) {
        if (!blockItemUseContext.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        World world = blockItemUseContext.func_195991_k();
        BlockPos pos = blockItemUseContext.func_195995_a();
        FluidState fluidstate = blockItemUseContext.func_195991_k().func_204610_c(pos);
        BlockState placementState = (BlockState)((BlockState)this.blockSupplier.get().func_176223_P().func_206870_a((Property)BackpackBlock.FACING, (Comparable)direction)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        if (!this.canPlace(blockItemUseContext, placementState)) {
            return ActionResultType.FAIL;
        }
        if (world.func_175656_a(pos, placementState)) {
            ItemStack backpack = blockItemUseContext.func_195996_i();
            WorldHelper.getTile((IBlockReader)world, pos, BackpackTileEntity.class).ifPresent(te -> te.setBackpack(this.getBackpackCopy(player, backpack)));
            SoundType soundtype = placementState.getSoundType((IWorldReader)world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (player == null || !player.func_184812_l_()) {
                backpack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private ItemStack getBackpackCopy(@Nullable PlayerEntity player, ItemStack backpack) {
        if (player == null || !player.func_184812_l_()) {
            return backpack.func_77946_l();
        }
        return backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(IBackpackWrapper::cloneBackpack).orElse(new ItemStack((IItemProvider)ModItems.BACKPACK.get()));
    }

    protected boolean canPlace(BlockItemUseContext context, BlockState state) {
        PlayerEntity playerentity = context.func_195999_j();
        ISelectionContext iselectioncontext = playerentity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)playerentity);
        return state.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) && context.func_195991_k().func_226663_a_(state, context.func_195995_a(), iselectioncontext);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
            String handlerName = hand == Hand.MAIN_HAND ? "main" : "offhand";
            int slot = hand == Hand.MAIN_HAND ? player.field_71071_by.field_70461_c : 0;
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((w, p, pl) -> new BackpackContainer(w, pl, new BackpackContext.Item(handlerName, slot)), stack.func_200301_q()), buf -> {
                buf.func_180714_a(handlerName);
                buf.writeInt(slot);
            });
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){
            private IBackpackWrapper wrapper = null;

            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                this.initWrapper();
                if (cap == CapabilityBackpackWrapper.getCapabilityInstance()) {
                    return LazyOptional.of(() -> this.wrapper).cast();
                }
                if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return LazyOptional.of(() -> this.wrapper.getInventoryForInputOutput()).cast();
                }
                return LazyOptional.empty();
            }

            private void initWrapper() {
                if (this.wrapper == null) {
                    this.wrapper = new BackpackWrapper(stack);
                }
            }
        };
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K || !(entityIn instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick((LivingEntity)player, player.field_70170_p, player.func_233580_cy_())));
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots.getAsInt();
    }

    public int getNumberOfUpgradeSlots() {
        return this.numberOfUpgradeSlots.getAsInt();
    }

    @Nullable
    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.CHEST;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.func_77973_b() == ModItems.GOLD_BACKPACK.get();
    }
}

