/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackUpgradeHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.InventoryModificationHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.NoopBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ItemStackKey;
import net.p3pp3rf1y.sophisticatedbackpacks.util.LootHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RandHelper;

public class BackpackWrapper
implements IBackpackWrapper {
    public static final int DEFAULT_CLOTH_COLOR = 13394234;
    public static final int DEFAULT_BORDER_COLOR = 6434330;
    private static final String CLOTH_COLOR_TAG = "clothColor";
    private static final String BORDER_COLOR_TAG = "borderColor";
    private static final String OPEN_TAB_ID_TAG = "openTabId";
    private static final String SORT_BY_TAG = "sortBy";
    private static final String CONTENTS_UUID_TAG = "contentsUuid";
    private static final String INVENTORY_SLOTS_TAG = "inventorySlots";
    private static final String UPGRADE_SLOTS_TAG = "upgradeSlots";
    private static final String LOOT_TABLE_NAME_TAG = "lootTableName";
    private static final String LOOT_PERCENTAGE_TAG = "lootPercentage";
    private final ItemStack backpack;
    private Runnable backpackSaveHandler = () -> {};
    @Nullable
    private BackpackInventoryHandler handler = null;
    @Nullable
    private BackpackUpgradeHandler upgradeHandler = null;
    @Nullable
    private InventoryIOHandler inventoryIOHandler = null;
    @Nullable
    private InventoryModificationHandler inventoryModificationHandler = null;

    public BackpackWrapper(ItemStack backpack) {
        this.backpack = backpack;
    }

    @Override
    public void setBackpackSaveHandler(Runnable saveHandler) {
        this.backpackSaveHandler = saveHandler;
        this.refreshInventoryForUpgradeProcessing();
    }

    @Override
    public IItemHandlerModifiable getInventoryForUpgradeProcessing() {
        if (this.inventoryModificationHandler == null) {
            this.inventoryModificationHandler = new InventoryModificationHandler(this);
        }
        return this.inventoryModificationHandler.getModifiedInventoryHandler();
    }

    @Override
    public BackpackInventoryHandler getInventoryHandler() {
        if (this.handler == null) {
            this.handler = new BackpackInventoryHandler(this.getNumberOfInventorySlots(), this, this.getBackpackContentsNbt(), this::markBackpackContentsDirty, StackUpgradeItem.getInventorySlotLimit(this));
        }
        return this.handler;
    }

    private int getNumberOfInventorySlots() {
        Optional<Integer> inventorySlots = NBTHelper.getInt(this.backpack, INVENTORY_SLOTS_TAG);
        if (inventorySlots.isPresent()) {
            return inventorySlots.get();
        }
        int itemInventorySlots = ((BackpackItem)this.backpack.func_77973_b()).getNumberOfSlots();
        this.setNumberOfInventorySlots(itemInventorySlots);
        return itemInventorySlots;
    }

    private void setNumberOfInventorySlots(int itemInventorySlots) {
        NBTHelper.setInteger(this.backpack, INVENTORY_SLOTS_TAG, itemInventorySlots);
    }

    private CompoundNBT getBackpackContentsNbt() {
        return BackpackStorage.get().getOrCreateBackpackContents(this.getOrCreateContentsUuid());
    }

    private void markBackpackContentsDirty() {
        BackpackStorage.get().func_76185_a();
    }

    @Override
    public IItemHandlerModifiable getInventoryForInputOutput() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler(this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    @Override
    public void copyDataTo(IBackpackWrapper otherBackpackWrapper) {
        this.getContentsUuid().ifPresent(originalUuid -> {
            this.getInventoryHandler().copyStacksTo(otherBackpackWrapper.getInventoryHandler());
            this.getUpgradeHandler().copyTo(otherBackpackWrapper.getUpgradeHandler());
        });
        if (this.backpack.func_82837_s()) {
            otherBackpackWrapper.getBackpack().func_200302_a(this.backpack.func_200301_q());
        }
        if (this.getClothColor() != 13394234 || this.getBorderColor() != 6434330) {
            otherBackpackWrapper.setColors(this.getClothColor(), this.getBorderColor());
        }
    }

    @Override
    public BackpackUpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = this.getContentsUuid().isPresent() ? new BackpackUpgradeHandler(this.getNumberOfUpgradeSlots(), this, this.getBackpackContentsNbt(), this::markBackpackContentsDirty, () -> {
                if (this.handler != null) {
                    this.handler.clearListeners();
                    this.handler.setSlotLimit(StackUpgradeItem.getInventorySlotLimit(this));
                }
                this.getInventoryHandler().clearListeners();
                this.inventoryIOHandler = null;
                this.inventoryModificationHandler = null;
            }) : NoopBackpackWrapper.INSTANCE.getUpgradeHandler();
        }
        return this.upgradeHandler;
    }

    private int getNumberOfUpgradeSlots() {
        Optional<Integer> upgradeSlots = NBTHelper.getInt(this.backpack, UPGRADE_SLOTS_TAG);
        if (upgradeSlots.isPresent()) {
            return upgradeSlots.get();
        }
        int itemUpgradeSlots = ((BackpackItem)this.backpack.func_77973_b()).getNumberOfUpgradeSlots();
        this.setNumberOfUpgradeSlots(itemUpgradeSlots);
        return itemUpgradeSlots;
    }

    @Override
    public Optional<UUID> getContentsUuid() {
        return NBTHelper.getUniqueId(this.backpack, CONTENTS_UUID_TAG);
    }

    private UUID getOrCreateContentsUuid() {
        Optional<UUID> contentsUuid = this.getContentsUuid();
        if (contentsUuid.isPresent()) {
            return contentsUuid.get();
        }
        this.clearDummyUpgradeHandler();
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        this.migrateBackpackContents(newUuid);
        return newUuid;
    }

    private void clearDummyUpgradeHandler() {
        if (this.upgradeHandler == NoopBackpackWrapper.INSTANCE.getUpgradeHandler()) {
            this.upgradeHandler = null;
        }
    }

    private void migrateBackpackContents(UUID newUuid) {
        this.migrateNbtTag(newUuid, "inventory");
        this.migrateNbtTag(newUuid, "upgradeInventory");
    }

    private void migrateNbtTag(UUID newUuid, String key) {
        NBTHelper.getCompound(this.backpack, key).ifPresent(nbt -> {
            BackpackStorage.get().getOrCreateBackpackContents(newUuid).func_218657_a(key, (INBT)nbt);
            this.markBackpackContentsDirty();
            NBTHelper.removeTag(this.backpack, key);
        });
    }

    @Override
    public int getClothColor() {
        return NBTHelper.getInt(this.backpack, CLOTH_COLOR_TAG).orElse(13394234);
    }

    @Override
    public int getBorderColor() {
        return NBTHelper.getInt(this.backpack, BORDER_COLOR_TAG).orElse(6434330);
    }

    @Override
    public Optional<Integer> getOpenTabId() {
        return NBTHelper.getInt(this.backpack, OPEN_TAB_ID_TAG);
    }

    @Override
    public void setOpenTabId(int openTabId) {
        NBTHelper.setInteger(this.backpack, OPEN_TAB_ID_TAG, openTabId);
        this.backpackSaveHandler.run();
    }

    @Override
    public void removeOpenTabId() {
        this.backpack.func_196082_o().func_82580_o(OPEN_TAB_ID_TAG);
        this.backpackSaveHandler.run();
    }

    @Override
    public void setColors(int clothColor, int borderColor) {
        this.backpack.func_77983_a(CLOTH_COLOR_TAG, (INBT)IntNBT.func_229692_a_((int)clothColor));
        this.backpack.func_77983_a(BORDER_COLOR_TAG, (INBT)IntNBT.func_229692_a_((int)borderColor));
        this.backpackSaveHandler.run();
    }

    @Override
    public void setSortBy(SortBy sortBy) {
        this.backpack.func_77983_a(SORT_BY_TAG, (INBT)StringNBT.func_229705_a_((String)sortBy.func_176610_l()));
        this.backpackSaveHandler.run();
    }

    @Override
    public SortBy getSortBy() {
        return NBTHelper.getEnumConstant(this.backpack, SORT_BY_TAG, SortBy::fromName).orElse(SortBy.NAME);
    }

    @Override
    public void sort() {
        InventorySorter.sortHandler((IItemHandlerModifiable)this.getInventoryHandler(), this.getComparator());
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        switch (this.getSortBy()) {
            case COUNT: {
                return InventorySorter.BY_COUNT;
            }
            case TAGS: {
                return InventorySorter.BY_TAGS;
            }
        }
        return InventorySorter.BY_NAME;
    }

    @Override
    public ItemStack getBackpack() {
        return this.backpack;
    }

    @Override
    public ItemStack cloneBackpack() {
        ItemStack clonedBackpack = this.cloneBackpack(this);
        clonedBackpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(this::cloneSubbackpacks);
        return clonedBackpack;
    }

    private void cloneSubbackpacks(IBackpackWrapper wrapperCloned) {
        BackpackInventoryHandler inventoryHandler = wrapperCloned.getInventoryHandler();
        InventoryHelper.iterate((IItemHandler)inventoryHandler, (slot, stack) -> {
            if (!(stack.func_77973_b() instanceof BackpackItem)) {
                return;
            }
            inventoryHandler.setStackInSlot((int)slot, stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(this::cloneBackpack).orElse(ItemStack.field_190927_a));
        });
    }

    private ItemStack cloneBackpack(IBackpackWrapper originalWrapper) {
        ItemStack backpackCopy = new ItemStack((IItemProvider)originalWrapper.getBackpack().func_77973_b());
        return backpackCopy.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapperCopy -> {
            originalWrapper.copyDataTo((IBackpackWrapper)wrapperCopy);
            return wrapperCopy.getBackpack();
        }).orElse(ItemStack.field_190927_a);
    }

    @Override
    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.getInventoryHandler().setPersistent(persistent);
        this.getUpgradeHandler().setPersistent(persistent);
    }

    @Override
    public void setSlotNumbers(int numberOfInventorySlots, int numberOfUpgradeSlots) {
        this.setNumberOfInventorySlots(numberOfInventorySlots);
        this.setNumberOfUpgradeSlots(numberOfUpgradeSlots);
    }

    @Override
    public void setLoot(ResourceLocation lootTableName, float lootPercentage) {
        this.backpack.func_77983_a(LOOT_TABLE_NAME_TAG, (INBT)StringNBT.func_229705_a_((String)lootTableName.toString()));
        this.backpack.func_77983_a(LOOT_PERCENTAGE_TAG, (INBT)FloatNBT.func_229689_a_((float)lootPercentage));
        this.backpackSaveHandler.run();
    }

    @Override
    public void fillWithLoot(PlayerEntity playerEntity) {
        if (playerEntity.field_70170_p.field_72995_K) {
            return;
        }
        NBTHelper.getString(this.backpack, LOOT_TABLE_NAME_TAG).ifPresent(ltName -> this.fillWithLootFromTable(playerEntity, (String)ltName));
    }

    @Override
    public void setContentsUuid(UUID backpackUuid) {
        NBTHelper.setUniqueId(this.backpack, CONTENTS_UUID_TAG, backpackUuid);
    }

    private void fillWithLootFromTable(PlayerEntity playerEntity, String lootName) {
        MinecraftServer server = playerEntity.field_70170_p.func_73046_m();
        if (server == null || !(playerEntity.field_70170_p instanceof ServerWorld)) {
            return;
        }
        ResourceLocation lootTableName = new ResourceLocation(lootName);
        float lootPercentage = NBTHelper.getFloat(this.backpack, LOOT_PERCENTAGE_TAG).orElse(Float.valueOf(0.0f)).floatValue();
        this.backpack.func_196083_e(LOOT_TABLE_NAME_TAG);
        this.backpack.func_196083_e(LOOT_PERCENTAGE_TAG);
        ServerWorld world = (ServerWorld)playerEntity.field_70170_p;
        List<ItemStack> loot = LootHelper.getLoot(lootTableName, server, world, (Entity)playerEntity);
        loot = RandHelper.getNRandomElements(loot, (int)((float)loot.size() * lootPercentage));
        LootHelper.fillWithLoot(world.field_73012_v, loot, (IItemHandlerModifiable)this.getInventoryHandler());
    }

    private void setNumberOfUpgradeSlots(int numberOfUpgradeSlots) {
        NBTHelper.setInteger(this.backpack, UPGRADE_SLOTS_TAG, numberOfUpgradeSlots);
    }

    @Override
    public void refreshInventoryForUpgradeProcessing() {
        this.inventoryModificationHandler = null;
        this.refreshInventoryForInputOutput();
    }

    @Override
    public void onContentsNbtUpdated() {
        this.handler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
    }
}

