/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TranslationHelper {
    private static final String GUI_PREFIX = "gui.sophisticatedbackpacks.";
    private static final String GUI_UPGRADE_PREFIX = "gui.sophisticatedbackpacks.upgrades.";
    private static final String BUTTONS_PREFIX = "gui.sophisticatedbackpacks.buttons.";
    private static final String ITEM_UPGRADE_PREFIX = "item.sophisticatedbackpacks.";
    private static final String UPGRADE_BUTTONS_PREFIX = "gui.sophisticatedbackpacks.upgrades.buttons.";
    private static final String KEYBIND_PREFIX = "keybind.sophisticatedbackpacks.";

    private TranslationHelper() {
    }

    public static String translUpgrade(String upgradeName) {
        return GUI_UPGRADE_PREFIX + upgradeName;
    }

    public static String translUpgradeTooltip(String upgradeName) {
        return TranslationHelper.translUpgrade(upgradeName) + ".tooltip";
    }

    public static ITextComponent translColoredButton(String buttonName, TextFormatting color) {
        return new TranslationTextComponent(TranslationHelper.translButton(buttonName)).func_240699_a_(color);
    }

    public static String translButton(String buttonName) {
        return BUTTONS_PREFIX + buttonName;
    }

    public static String translUpgradeButton(String buttonName) {
        return UPGRADE_BUTTONS_PREFIX + buttonName;
    }

    public static String translUpgradeItemTooltip(String upgradeName) {
        return ITEM_UPGRADE_PREFIX + upgradeName + ".tooltip";
    }

    public static List<StringTextComponent> getTranslatedLines(String translateKey, @Nullable Object parameters, TextFormatting ... textFormattings) {
        List<StringTextComponent> ret = TranslationHelper.getTranslatedLines(translateKey, parameters);
        ret.forEach(l -> l.func_240701_a_(textFormattings));
        return ret;
    }

    public static List<StringTextComponent> getTranslatedLines(String translateKey) {
        return TranslationHelper.getTranslatedLines(translateKey, null);
    }

    public static List<StringTextComponent> getTranslatedLines(String translateKey, @Nullable Object parameters) {
        String text = TranslationHelper.translate(translateKey, parameters);
        String[] lines = text.split("\n");
        ArrayList<StringTextComponent> ret = new ArrayList<StringTextComponent>();
        for (String line : lines) {
            ret.add(new StringTextComponent(line));
        }
        return ret;
    }

    public static String translate(String translateKey, Object ... parameters) {
        return I18n.func_135052_a((String)translateKey, (Object[])parameters);
    }

    public static String translKeybind(String keybindName) {
        return KEYBIND_PREFIX + keybindName;
    }
}

