/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rectangle2d;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.UpgradeSettingsTab;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.UpgradeSettingsTabManager;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.CompositeWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import org.apache.commons.lang3.mutable.MutableInt;

public class UpgradeSettingsControl
extends CompositeWidget<UpgradeSettingsTab<?>> {
    private static final int VERTICAL_SPACE = 1;
    @Nullable
    private UpgradeSettingsTab<?> openTab = null;

    public UpgradeSettingsControl(Position position, BackpackScreen screen) {
        super(position);
        int i = 0;
        for (Map.Entry<Integer, UpgradeContainerBase<?, ?>> entry : ((BackpackContainer)screen.func_212873_a_()).getUpgradeContainers().entrySet()) {
            UpgradeSettingsTab<UpgradeContainerBase<?, ?>> tab = this.addChild(UpgradeSettingsTabManager.getTab(entry.getValue(), new Position(this.x, this.getTopY(i)), screen));
            tab.setHandlers(t -> {
                if (this.differentTabIsOpen((UpgradeSettingsTab<?>)((Object)t))) {
                    this.openTab.close();
                }
                t.setZOffset(200);
                this.openTab = t;
                ((BackpackContainer)screen.func_212873_a_()).setOpenTabId((Integer)entry.getKey());
            }, t -> {
                if (this.openTab != null) {
                    this.openTab.setZOffset(0);
                    this.openTab = null;
                    ((BackpackContainer)screen.func_212873_a_()).removeOpenTabId();
                }
            }, t -> !this.differentTabIsOpen((UpgradeSettingsTab<?>)((Object)t)) || this.isNotCovered(this.openTab, (UpgradeSettingsTab<UpgradeContainerBase<?, ?>>)((Object)t), true), t -> this.openTab == null || this.isNotCovered(this.openTab, (UpgradeSettingsTab<UpgradeContainerBase<?, ?>>)((Object)t), false));
            tab.onAfterInit();
            ++i;
        }
    }

    private boolean isNotCovered(UpgradeSettingsTab<?> open, UpgradeSettingsTab<UpgradeContainerBase<?, ?>> t, boolean checkFullyCovered) {
        if (checkFullyCovered) {
            return open.getBottomY() < t.getBottomY() || open.getTopY() > t.getTopY();
        }
        return open.getBottomY() < t.getTopY() || open.getTopY() > t.getTopY();
    }

    private boolean differentTabIsOpen(UpgradeSettingsTab<?> tab) {
        return this.openTab != null && this.openTab != tab;
    }

    @Override
    protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
    }

    public void afterScreenRender(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.children.forEach(tab -> tab.afterScreenRender(matrixStack, mouseX, mouseY, partialTicks));
    }

    private int getTopY(int index) {
        return this.y + index * 25;
    }

    @Override
    public int getHeight() {
        MutableInt maxY = new MutableInt(0);
        this.children.forEach(tab -> {
            int bottomY = tab.getBottomY();
            if (bottomY > maxY.getValue()) {
                maxY.setValue(bottomY);
            }
        });
        return maxY.getValue() - this.y;
    }

    @Override
    public int getWidth() {
        MutableInt maxWidth = new MutableInt(0);
        this.children.forEach(tab -> {
            int width = tab.getWidth();
            if (width > maxWidth.getValue()) {
                maxWidth.setValue(width);
            }
        });
        return maxWidth.getValue();
    }

    public List<Rectangle2d> getTabRectangles() {
        ArrayList<Rectangle2d> ret = new ArrayList<Rectangle2d>();
        this.children.forEach(child -> ret.add(child.getRectangle()));
        return ret;
    }
}

