/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.CompositeWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ItemButton;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.Label;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.Widget;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;

public abstract class UpgradeSettingsTab<C extends UpgradeContainerBase<?, ?>>
extends CompositeWidget<Widget> {
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    public static final int DEFAULT_HEIGHT = 24;
    private static final int DEFAULT_WIDTH = 21;
    private static final int RIGHT_BORDER_WIDTH = 6;
    private static final int BOTTOM_BORDER_HEIGHT = 7;
    protected final BackpackScreen screen;
    private final List<ITextProperties> closedTooltip;
    private int width = 21;
    private int height = 24;
    private final C upgradeContainer;
    protected Dimension openTabDimension = new Dimension(0, 0);
    private Consumer<UpgradeSettingsTab<C>> onOpen = t -> {};
    private Consumer<UpgradeSettingsTab<C>> onClose = t -> {};
    private Predicate<UpgradeSettingsTab<C>> shouldRender = t -> true;
    private Predicate<UpgradeSettingsTab<C>> shouldShowTooltip = t -> true;
    private final List<Widget> hideableChildren = new ArrayList<Widget>();

    protected UpgradeSettingsTab(C upgradeContainer, Position position, BackpackScreen screen, ITextComponent tabLabel, ITextComponent closedTooltip) {
        super(position);
        this.upgradeContainer = upgradeContainer;
        this.closedTooltip = ImmutableList.of((Object)closedTooltip);
        this.addChild(new ItemButton(new Position(this.x + 1, this.y + 4), this::onTabIconClicked, ((UpgradeContainerBase)this.getContainer()).getUpgradeStack(), (UpgradeContainerBase)upgradeContainer){
            final /* synthetic */ UpgradeContainerBase val$upgradeContainer;
            {
                this.val$upgradeContainer = upgradeContainerBase;
                super(position, onClick, stack);
            }

            @Override
            protected void renderWidget(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                super.renderWidget(matrixStack, mouseX, mouseY, partialTicks);
                if (!this.val$upgradeContainer.isOpen() && UpgradeSettingsTab.this.shouldShowTooltip.test(UpgradeSettingsTab.this) && this.func_231047_b_(mouseX, mouseY)) {
                    GuiHelper.setTooltipToRender(UpgradeSettingsTab.this.closedTooltip);
                }
            }
        });
        this.addHideableChild(new Label(new Position(this.x + 20, this.y + 8), tabLabel));
        this.screen = screen;
        this.moveSlotsOutOfView();
    }

    public void setHandlers(Consumer<UpgradeSettingsTab<C>> onOpen, Consumer<UpgradeSettingsTab<C>> onClose, Predicate<UpgradeSettingsTab<C>> shouldRender, Predicate<UpgradeSettingsTab<C>> shouldShowTooltip) {
        this.onOpen = onOpen;
        this.onClose = onClose;
        this.shouldRender = shouldRender;
        this.shouldShowTooltip = shouldShowTooltip;
    }

    private void onTabIconClicked(int button) {
        if (button != 0) {
            return;
        }
        this.setOpen(!((UpgradeContainerBase)this.upgradeContainer).isOpen());
    }

    protected C getContainer() {
        return this.upgradeContainer;
    }

    protected <U extends Widget> U addHideableChild(U widget) {
        this.hideableChildren.add(widget);
        this.updateOpenTabDimension(widget);
        return widget;
    }

    private <U extends Widget> void updateOpenTabDimension(U widget) {
        int widgetMaxWidthExtension = widget.getX() + widget.getWidth() + 6 - this.x;
        int widgetMaxHeightExtension = widget.getY() + widget.getHeight() + 7 - this.y;
        this.openTabDimension = new Dimension(Math.max(this.openTabDimension.getWidth(), widgetMaxWidthExtension), Math.max(this.openTabDimension.getHeight(), widgetMaxHeightExtension));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.shouldRender.test(this)) {
            return;
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        minecraft.func_110434_K().func_110577_a(GuiHelper.GUI_CONTROLS);
        int halfHeight = this.height / 2;
        UpgradeSettingsTab.func_238463_a_((MatrixStack)matrixStack, (int)this.x, (int)this.y, (float)(256.0f - (float)this.width), (float)0.0f, (int)this.width, (int)halfHeight, (int)256, (int)256);
        UpgradeSettingsTab.func_238463_a_((MatrixStack)matrixStack, (int)this.x, (int)(this.y + halfHeight), (float)(256.0f - (float)this.width), (float)(256.0f - (float)halfHeight), (int)this.width, (int)halfHeight, (int)256, (int)256);
        this.func_238474_b_(matrixStack, this.x - 3, this.y, 128, 256 - this.height, 3, this.height);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getTopY() {
        return this.y;
    }

    public int getBottomY() {
        return this.y + this.getHeight();
    }

    public void close() {
        this.setOpen(false);
        this.onTabClose();
    }

    protected void onTabOpen() {
        this.width = this.openTabDimension.getWidth();
        this.height = this.openTabDimension.getHeight();
        this.hideableChildren.forEach(this::addChild);
        this.onOpen.accept(this);
        this.moveSlotsToTab();
    }

    protected abstract void moveSlotsToTab();

    protected void moveSlotsOutOfView() {
        ((UpgradeContainerBase)this.getContainer()).getSlots().forEach(slot -> {
            slot.field_75223_e = -1000;
        });
    }

    protected void onTabClose() {
        this.width = 21;
        this.height = 24;
        this.children.removeAll(this.hideableChildren);
        this.onClose.accept(this);
        this.moveSlotsOutOfView();
    }

    private void setOpen(boolean isOpen) {
        ((UpgradeContainerBase)this.upgradeContainer).setIsOpen(isOpen);
        if (isOpen) {
            this.onTabOpen();
        } else {
            this.onTabClose();
        }
    }

    public Rectangle2d getRectangle() {
        return new Rectangle2d(this.x, this.y, this.width, this.height);
    }

    public void onAfterInit() {
        if (((UpgradeContainerBase)this.upgradeContainer).isOpen()) {
            this.setOpen(true);
        }
    }

    public void afterScreenRender(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }
}

