/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ToggleButton;

public class ButtonDefinition {
    private final Dimension dimension;
    private final TextureBlitData backgroundTexture;
    @Nullable
    private final TextureBlitData hoveredBackgroundTexture;
    @Nullable
    private final TextureBlitData foregroundTexture;
    private final ITextComponent tooltip;

    public ButtonDefinition(Dimension dimension, TextureBlitData backgroundTexture, @Nullable TextureBlitData hoveredBackgroundTexture) {
        this(dimension, backgroundTexture, hoveredBackgroundTexture, null, (ITextComponent)new StringTextComponent(""));
    }

    public ButtonDefinition(Dimension dimension, TextureBlitData backgroundTexture, @Nullable TextureBlitData hoveredBackgroundTexture, @Nullable TextureBlitData foregroundTexture, ITextComponent tooltip) {
        this.dimension = dimension;
        this.backgroundTexture = backgroundTexture;
        this.hoveredBackgroundTexture = hoveredBackgroundTexture;
        this.foregroundTexture = foregroundTexture;
        this.tooltip = tooltip;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public TextureBlitData getBackgroundTexture() {
        return this.backgroundTexture;
    }

    @Nullable
    public TextureBlitData getHoveredBackgroundTexture() {
        return this.hoveredBackgroundTexture;
    }

    @Nullable
    public TextureBlitData getForegroundTexture() {
        return this.foregroundTexture;
    }

    public ITextComponent getTooltip() {
        return this.tooltip;
    }

    public static class Toggle<T extends Comparable<T>>
    extends ButtonDefinition {
        private final Map<T, ToggleButton.StateData> stateData;

        public Toggle(Dimension dimension, TextureBlitData backgroundTexture, Map<T, ToggleButton.StateData> stateData, @Nullable TextureBlitData hoveredBackgroundTexture) {
            super(dimension, backgroundTexture, hoveredBackgroundTexture);
            this.stateData = stateData;
        }

        public Map<T, ToggleButton.StateData> getStateData() {
            return this.stateData;
        }
    }
}

