/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class BackpackLayerRenderer<T extends LivingEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static final float CHILD_Y_OFFSET = 0.3f;
    private static final float CHILD_Z_OFFSET = 0.1f;
    private static final float CHILD_SCALE = 0.55f;
    private static final ResourceLocation BACKPACK_TEXTURE = new ResourceLocation("sophisticatedbackpacks", "textures/entity/backpack.png");
    private static final BackpackModel MODEL = new BackpackModel();
    private static final Map<Item, ModelRenderer> BACKPACK_CLIPS = ImmutableMap.of((Object)((Item)ModItems.BACKPACK.get()), (Object)BackpackLayerRenderer.MODEL.leatherClips, (Object)((Item)ModItems.IRON_BACKPACK.get()), (Object)BackpackLayerRenderer.MODEL.ironClips, (Object)((Item)ModItems.GOLD_BACKPACK.get()), (Object)BackpackLayerRenderer.MODEL.goldClips, (Object)((Item)ModItems.DIAMOND_BACKPACK.get()), (Object)BackpackLayerRenderer.MODEL.diamondClips, (Object)((Item)ModItems.NETHERITE_BACKPACK.get()), (Object)BackpackLayerRenderer.MODEL.netheriteClips);
    private static final Map<EntityType<?>, Vector3d> entityTranslations = new HashMap();

    public BackpackLayerRenderer(IEntityRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)entity;
            PlayerInventoryProvider.getBackpackFromRendered((PlayerEntity)player).ifPresent(backpackRenderInfo -> {
                matrixStack.func_227860_a_();
                boolean wearsArmor = !backpackRenderInfo.isArmorSlot() && !((ItemStack)player.field_71071_by.field_70460_b.get(EquipmentSlotType.CHEST.func_188454_b())).func_190926_b();
                ItemStack backpack = backpackRenderInfo.getBackpack();
                BackpackLayerRenderer.renderBackpack((LivingEntity)player, matrixStack, buffer, packedLight, backpack, wearsArmor);
                matrixStack.func_227865_b_();
            });
        } else {
            ItemStack chestStack = entity.func_184582_a(EquipmentSlotType.CHEST);
            if (chestStack.func_77973_b() instanceof BackpackItem) {
                BackpackLayerRenderer.renderBackpack(entity, matrixStack, buffer, packedLight, chestStack, false);
            }
        }
    }

    public static void renderBackpack(LivingEntity livingEntity, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, ItemStack backpack, boolean wearsArmor) {
        if (livingEntity.func_213453_ef()) {
            matrixStack.func_227861_a_(0.0, 0.2, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(28.647888f));
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        float zOffset = wearsArmor ? -0.25f : -0.2f;
        float yOffset = -0.75f;
        if (livingEntity.func_70631_g_()) {
            zOffset += 0.1f;
            yOffset = 0.3f;
        }
        matrixStack.func_227861_a_(0.0, (double)yOffset, (double)zOffset);
        if (livingEntity.func_70631_g_()) {
            matrixStack.func_227862_a_(0.55f, 0.55f, 0.55f);
        }
        if (entityTranslations.containsKey(livingEntity.func_200600_R())) {
            Vector3d translVector = entityTranslations.get(livingEntity.func_200600_R());
            matrixStack.func_227861_a_(translVector.func_82615_a(), translVector.func_82617_b(), translVector.func_82616_c());
        }
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)RenderType.func_228640_c_((ResourceLocation)BACKPACK_TEXTURE), (boolean)false, (boolean)false);
            int color = wrapper.getClothColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            BackpackLayerRenderer.MODEL.cloth.func_228309_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
            color = wrapper.getBorderColor();
            red = (float)(color >> 16 & 0xFF) / 255.0f;
            green = (float)(color >> 8 & 0xFF) / 255.0f;
            blue = (float)(color & 0xFF) / 255.0f;
            BackpackLayerRenderer.MODEL.border.func_228309_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
            BACKPACK_CLIPS.getOrDefault(backpack.func_77973_b(), BackpackLayerRenderer.MODEL.leatherClips).func_228309_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        });
    }

    static {
        entityTranslations.put(EntityType.field_200803_q, new Vector3d(0.0, -0.8, 0.0));
    }
}

